/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph;

import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.text.Message;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnnoDatasetParser {
    public static final String RB_KEY = "AnnoDatasetParser.";
    public static final String COLUMN_ID = "ID";
    public static final String COLUMN_FUNCTION = "FUNCTION";
    public static final String COLUMN_ANCHOR = "ANCHOR";
    public static final String COLUMN_LABEL = "LABEL";
    public static final String COLUMN_BORDER = "BORDER";
    public static final String COLUMN_DISCRETEOFFSET = "DISCRETEOFFSET";
    public static final String COLUMN_JUSTIFY = "JUSTIFY";
    public static final String COLUMN_LAYER = "LAYER";
    public static final String COLUMN_ROTATE = "ROTATE";
    public static final String COLUMN_CORNERRADIUS = "CORNERRADIUS";
    public static final String COLUMN_TRANSPARENCY = "TRANSPARENCY";
    public static final String COLUMN_FILLTRANSPARENCY = "FILLTRANSPARENCY";
    public static final String COLUMN_IMAGE = "IMAGE";
    public static final String COLUMN_IMAGESCALE = "IMAGESCALE";
    public static final String COLUMN_SCALE = "SCALE";
    public static final String COLUMN_SHAPE = "SHAPE";
    public static final String COLUMN_DIRECTION = "DIRECTION";
    public static final String COLUMN_DISPLAY = "DISPLAY";
    public static final String COLUMN_XAXIS = "XAXIS";
    public static final String COLUMN_YAXIS = "YAXIS";
    public static final String COLUMN_WIDTH = "WIDTH";
    public static final String COLUMN_WIDTHUNIT = "WIDTHUNIT";
    public static final String COLUMN_HEIGHT = "HEIGHT";
    public static final String COLUMN_HEIGHTUNIT = "HEIGHTUNIT";
    public static final String COLUMN_X1 = "X1";
    public static final String COLUMN_Y1 = "Y1";
    public static final String COLUMN_X2 = "X2";
    public static final String COLUMN_Y2 = "Y2";
    public static final String COLUMN_XC1 = "XC1";
    public static final String COLUMN_YC1 = "YC1";
    public static final String COLUMN_XC2 = "XC2";
    public static final String COLUMN_YC2 = "YC2";
    public static final String COLUMN_X1SPACE = "X1SPACE";
    public static final String COLUMN_Y1SPACE = "Y1SPACE";
    public static final String COLUMN_X2SPACE = "X2SPACE";
    public static final String COLUMN_Y2SPACE = "Y2SPACE";
    public static final String COLUMN_DRAWSPACE = "DRAWSPACE";
    public static final String COLUMN_FILLSTYLEELEMENT = "FILLSTYLEELEMENT";
    public static final String COLUMN_FILLCOLOR = "FILLCOLOR";
    public static final String COLUMN_LINESTYLEELEMENT = "LINESTYLEELEMENT";
    public static final String COLUMN_LINECOLOR = "LINECOLOR";
    public static final String COLUMN_LINEPATTERN = "LINEPATTERN";
    public static final String COLUMN_LINETHICKNESS = "LINETHICKNESS";
    public static final String COLUMN_TEXTSTYLEELEMENT = "TEXTSTYLEELEMENT";
    public static final String COLUMN_TEXTCOLOR = "TEXTCOLOR";
    public static final String COLUMN_TEXTFONT = "TEXTFONT";
    public static final String COLUMN_TEXTSIZE = "TEXTSIZE";
    public static final String COLUMN_TEXTWEIGHT = "TEXTWEIGHT";
    public static final String COLUMN_TEXTSTYLE = "TEXTSTYLE";
    public static final String COLUMN_PAD = "PAD";
    public static final String COLUMN_VALUE = "VALUE";
    public static final String COLUMN_MARKERSTYLEELEMENT = "MARKERSTYLEELEMENT";
    public static final String COLUMN_MARKERSYMBOL = "MARKERSYMBOL";
    public static final String COLUMN_MARKERCOLOR = "MARKERCOLOR";
    public static final String COLUMN_MARKERSIZE = "MARKERSIZE";
    public static final String COLUMN_MARKERWEIGHT = "MARKERWEIGHT";
    public static final String COLUMN_MARKERTRANSPARENCY = "MARKERTRANSPARENCY";
    public static final String COLUMN_URL = "URL";
    public static final String COLUMN_NOCASE = "NOCASE";
    public static final String COLUMN_LEGENDPOLICY = "SHOW";
    public static final String COLUMN_FILLSTYLE = "FILLSTYLE";
    public static final String COLUMN_LINESTYLE = "LINESTYLE";
    public static final String COLUMN_MARKERSTYLE = "MARKERSTYLE";

    public static void load(StatGraph graph, Element elem) {
        Element annoElem;
        int i;
        NodeList list = elem.getElementsByTagName("Annotate");
        for (i = 0; i < list.getLength(); ++i) {
            annoElem = (Element)list.item(i);
            DataModel m = graph.getData(annoElem.getAttribute("model"));
            if (m == null) continue;
            m.setSpecializedData(true);
            String idStr = null;
            if (annoElem.hasAttribute("id")) {
                idStr = annoElem.getAttribute("id");
                idStr = idStr.trim().length() == 0 ? "" : idStr;
            }
            AnnoDatasetParser.generateDrawStatements(annoElem, m, idStr);
        }
        for (i = 0; i < list.getLength(); ++i) {
            annoElem = (Element)list.item(i);
            Node parent = annoElem.getParentNode();
            parent.removeChild(annoElem);
        }
    }

    private static double getDoubleValue(DataModel m, String columnName, int obs) {
        if (!m.hasColumn(columnName)) {
            return Double.NaN;
        }
        int col = m.getColumn(columnName);
        double d = m.getDoubleColumn(col)[obs];
        return AnnoDatasetParser.isValidNumAttr(columnName, d) ? d : Double.NaN;
    }

    private static boolean isValidNumAttr(String columnName, double d) {
        if (d != d) {
            return false;
        }
        boolean ok = true;
        if (columnName == COLUMN_TEXTSIZE) {
            ok = d > 0.0;
        } else if (columnName == COLUMN_LINETHICKNESS) {
            ok = d > 0.0;
        } else if (columnName == COLUMN_WIDTH) {
            ok = d > 0.0;
        } else if (columnName == COLUMN_HEIGHT) {
            ok = d > 0.0;
        } else if (columnName == COLUMN_SCALE) {
            ok = d > 0.0;
        } else if (columnName == COLUMN_PAD) {
            ok = d > 0.0;
        } else if (columnName == COLUMN_DISCRETEOFFSET) {
            ok = d >= -0.5 && d <= 0.5;
        } else if (columnName == COLUMN_CORNERRADIUS) {
            ok = d >= 0.0 && d <= 1.0;
        } else if (columnName == COLUMN_TRANSPARENCY) {
            ok = d >= 0.0 && d <= 1.0;
        } else if (columnName == COLUMN_FILLTRANSPARENCY) {
            ok = d >= 0.0 && d <= 1.0;
        } else if (columnName == COLUMN_MARKERTRANSPARENCY) {
            ok = d >= 0.0 && d <= 1.0;
        } else if (columnName == COLUMN_MARKERSIZE) {
            ok = d >= 0.0;
        } else if (columnName == COLUMN_LINEPATTERN) {
            boolean bl = ok = d >= 1.0 && d <= 46.0 && d == (double)((int)d);
        }
        if (!ok) {
            Message msg = new Message(RB.getStringResource(RB_KEY, "range.fmt.txt"));
            StatGraph.printNote(msg.toString((Object)columnName, (Object)d));
        }
        return ok;
    }

    public static String getStringValue(DataModel m, String columnName, int obs) {
        if (!m.hasColumn(columnName)) {
            return null;
        }
        int col = m.getColumn(columnName);
        return m.getStringColumn(col)[obs];
    }

    private static boolean isIntegerColumn(String columnName) {
        return columnName == COLUMN_TEXTSIZE || columnName == COLUMN_LINETHICKNESS || columnName == COLUMN_MARKERSIZE || columnName == COLUMN_LINEPATTERN;
    }

    public static void addAttrBundle(Document doc, Element elem, String bundle, String[] columns, String[] attrs, DataModel m, int obs) {
        Element e = doc.createElement(bundle);
        boolean used = false;
        for (int i = 0; i < columns.length; ++i) {
            if (!m.hasColumn(columns[i])) continue;
            int col = m.getColumn(columns[i]);
            ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(col);
            if (cmd.getType() == 1) {
                double d = AnnoDatasetParser.getDoubleValue(m, columns[i], obs);
                if (d != d) continue;
                used = true;
                if (AnnoDatasetParser.isIntegerColumn(columns[i])) {
                    e.setAttribute(attrs[i], Integer.toString((int)d));
                    continue;
                }
                e.setAttribute(attrs[i], Double.toString(d));
                continue;
            }
            String s = AnnoDatasetParser.getStringValue(m, columns[i], obs);
            if (s == null || s.trim().isEmpty()) continue;
            used = true;
            e.setAttribute(attrs[i], s);
        }
        if (used) {
            elem.appendChild(e);
        }
    }

    private static boolean isInPlay(DataModel m, String idStr, int obs) {
        if (idStr == null) {
            return true;
        }
        int idCol = m.getColumn(COLUMN_ID);
        Class idClass = m.getColumnClass(idCol);
        if (idClass == Double.class) {
            return true;
        }
        String strVal = AnnoDatasetParser.getStringValue(m, COLUMN_ID, obs);
        if (idStr.length() == 0 && (strVal == null || strVal.trim().length() == 0)) {
            return true;
        }
        return idStr.equals(strVal);
    }

    private static void generateDrawStatements(Element elem, DataModel m, String idStr) {
        int fcol = m.getColumn(COLUMN_FUNCTION);
        String[] functions = m.getStringColumn(fcol);
        Document doc = elem.getOwnerDocument();
        Node parent = elem.getParentNode();
        Element lastTextElem = null;
        Element lastPolyElem = null;
        for (int i = 0; i < m.getRowCount(); ++i) {
            if (!AnnoDatasetParser.isInPlay(m, idStr, i)) continue;
            boolean ok = true;
            Element drawElem = null;
            if (functions[i] == null || functions[i].trim().isEmpty()) continue;
            if (!functions[i].equalsIgnoreCase("TEXTCONT")) {
                lastTextElem = null;
            }
            if (!functions[i].equalsIgnoreCase("POLYCONT")) {
                lastPolyElem = null;
            }
            if (functions[i].equalsIgnoreCase("RECTANGLE")) {
                drawElem = doc.createElement("DrawRectangle");
                ok = AnnoDatasetParser.createRectangle(doc, drawElem, m, i);
            } else if (functions[i].equalsIgnoreCase("OVAL")) {
                drawElem = doc.createElement("DrawOval");
                ok = AnnoDatasetParser.createOval(doc, drawElem, m, i);
            } else if (functions[i].equalsIgnoreCase("LINE")) {
                drawElem = doc.createElement("DrawLine");
                ok = AnnoDatasetParser.createLine(doc, drawElem, m, i);
            } else if (functions[i].equalsIgnoreCase("ARROW")) {
                drawElem = doc.createElement("DrawArrow");
                ok = AnnoDatasetParser.createArrow(doc, drawElem, m, i);
            } else if (functions[i].equalsIgnoreCase("TEXT")) {
                drawElem = doc.createElement("DrawText");
                ok = AnnoDatasetParser.createText(doc, drawElem, m, i);
                lastTextElem = drawElem;
            } else if (functions[i].equalsIgnoreCase("TEXTCONT")) {
                ok = AnnoDatasetParser.continueText(doc, lastTextElem, m, i);
            } else if (functions[i].equalsIgnoreCase(COLUMN_IMAGE)) {
                drawElem = doc.createElement("DrawImage");
                ok = AnnoDatasetParser.createImage(doc, drawElem, m, i);
            } else if (functions[i].equalsIgnoreCase("POLYGON")) {
                drawElem = doc.createElement("DrawPolygon");
                ok = AnnoDatasetParser.createPolygon(doc, drawElem, m, i);
                lastPolyElem = drawElem;
            } else if (functions[i].equalsIgnoreCase("POLYLINE")) {
                drawElem = doc.createElement("DrawPolyline");
                ok = AnnoDatasetParser.createPolyline(doc, drawElem, m, i);
                lastPolyElem = drawElem;
            } else if (functions[i].equalsIgnoreCase("POLYCONT")) {
                ok = AnnoDatasetParser.continuePoly(doc, lastPolyElem, m, i);
            } else {
                Message msg = new Message(RB.getStringResource(RB_KEY, "function.fmt.txt"));
                StatGraph.printNote(msg.toString((Object)functions[i]));
            }
            if (!ok || drawElem == null) continue;
            parent.insertBefore(drawElem, elem);
        }
    }

    private static boolean setNumAttr(Element elem, DataModel m, int obs, String columnName, String attr) {
        double d = AnnoDatasetParser.getDoubleValue(m, columnName, obs);
        if (d != d) {
            return false;
        }
        if (columnName == COLUMN_PAD) {
            elem.setAttribute(attr, Integer.toString((int)d));
        } else {
            elem.setAttribute(attr, Double.toString(d));
        }
        return true;
    }

    public static boolean setStrAttr(Element elem, DataModel m, int obs, String columnName, String attr) {
        String s = AnnoDatasetParser.getStringValue(m, columnName, obs);
        if (s == null || s.trim().isEmpty()) {
            return false;
        }
        elem.setAttribute(attr, s);
        return true;
    }

    private static boolean setPosAttr(Element elem, DataModel m, int obs, String numColumn, String strColumn, String spaceColumn, String attr) {
        String space = AnnoDatasetParser.getStringValue(m, spaceColumn, obs);
        if (space == null) {
            space = AnnoDatasetParser.getStringValue(m, COLUMN_DRAWSPACE, obs);
        }
        if (space == null || !space.equalsIgnoreCase("DATAVALUE")) {
            return AnnoDatasetParser.setNumAttr(elem, m, obs, numColumn, attr);
        }
        String attrValue = AnnoDatasetParser.getStringValue(m, strColumn, obs);
        double d = AnnoDatasetParser.getDoubleValue(m, numColumn, obs);
        if (d == d) {
            attrValue = DataModel.defaultFormat.format((Object)new Double(d)).trim();
        } else if (attrValue == null || attrValue.trim().isEmpty()) {
            return false;
        }
        elem.setAttribute(attr, attrValue);
        return true;
    }

    private static void setCommonAttrs(Element elem, DataModel m, int obs) {
        AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_DISCRETEOFFSET, "discreteOffset");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_LAYER, "layer");
        AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_TRANSPARENCY, "transparency");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_XAXIS, "xAxis");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_YAXIS, "yAxis");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_DRAWSPACE, "drawSpace");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_URL, "url");
    }

    private static boolean createRectangle(Document doc, Element elem, DataModel m, int obs) {
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_X1, COLUMN_XC1, COLUMN_X1SPACE, "x")) {
            return false;
        }
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_Y1, COLUMN_YC1, COLUMN_Y1SPACE, "y")) {
            return false;
        }
        if (!AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_WIDTH, "width")) {
            return false;
        }
        if (!AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_HEIGHT, "height")) {
            return false;
        }
        AnnoDatasetParser.setCommonAttrs(elem, m, obs);
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_X1SPACE, "xSpace");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_Y1SPACE, "ySpace");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_ANCHOR, "anchor");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_DISPLAY, "display");
        AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_CORNERRADIUS, "cornerRadius");
        AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_ROTATE, "rotate");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_WIDTHUNIT, "widthUnit");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_HEIGHTUNIT, "heightUnit");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_LINESTYLEELEMENT, "outlineAttrs");
        AnnoDatasetParser.addAttrBundle(doc, elem, "OutlineAttrs", new String[]{COLUMN_LINECOLOR, COLUMN_LINEPATTERN, COLUMN_LINETHICKNESS}, new String[]{"color", "pattern", "thickness"}, m, obs);
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_FILLSTYLEELEMENT, "fillAttrs");
        AnnoDatasetParser.addAttrBundle(doc, elem, "FillAttrs", new String[]{COLUMN_FILLCOLOR, COLUMN_FILLTRANSPARENCY}, new String[]{"color", "transparency"}, m, obs);
        return true;
    }

    private static boolean createOval(Document doc, Element elem, DataModel m, int obs) {
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_X1, COLUMN_XC1, COLUMN_X1SPACE, "x")) {
            return false;
        }
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_Y1, COLUMN_YC1, COLUMN_Y1SPACE, "y")) {
            return false;
        }
        if (!AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_WIDTH, "width")) {
            return false;
        }
        if (!AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_HEIGHT, "height")) {
            return false;
        }
        AnnoDatasetParser.setCommonAttrs(elem, m, obs);
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_X1SPACE, "xSpace");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_Y1SPACE, "ySpace");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_DISPLAY, "display");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_WIDTHUNIT, "widthUnit");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_HEIGHTUNIT, "heightUnit");
        AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_ROTATE, "rotate");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_LINESTYLEELEMENT, "outlineAttrs");
        AnnoDatasetParser.addAttrBundle(doc, elem, "OutlineAttrs", new String[]{COLUMN_LINECOLOR, COLUMN_LINEPATTERN, COLUMN_LINETHICKNESS}, new String[]{"color", "pattern", "thickness"}, m, obs);
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_FILLSTYLEELEMENT, "fillAttrs");
        AnnoDatasetParser.addAttrBundle(doc, elem, "FillAttrs", new String[]{COLUMN_FILLCOLOR, COLUMN_FILLTRANSPARENCY}, new String[]{"color", "transparency"}, m, obs);
        return true;
    }

    private static boolean createLine(Document doc, Element elem, DataModel m, int obs) {
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_X1, COLUMN_XC1, COLUMN_X1SPACE, "x1")) {
            return false;
        }
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_Y1, COLUMN_YC1, COLUMN_Y1SPACE, "y1")) {
            return false;
        }
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_X2, COLUMN_XC2, COLUMN_X2SPACE, "x2")) {
            return false;
        }
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_Y2, COLUMN_YC2, COLUMN_Y2SPACE, "y2")) {
            return false;
        }
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_X1SPACE, "x1Space");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_Y1SPACE, "y1Space");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_X2SPACE, "x2Space");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_Y2SPACE, "y2Space");
        AnnoDatasetParser.setCommonAttrs(elem, m, obs);
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_LINESTYLEELEMENT, "lineAttrs");
        AnnoDatasetParser.addAttrBundle(doc, elem, "LineAttrs", new String[]{COLUMN_LINECOLOR, COLUMN_LINEPATTERN, COLUMN_LINETHICKNESS}, new String[]{"color", "pattern", "thickness"}, m, obs);
        return true;
    }

    private static boolean createArrow(Document doc, Element elem, DataModel m, int obs) {
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_X1, COLUMN_XC1, COLUMN_X1SPACE, "x1")) {
            return false;
        }
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_Y1, COLUMN_YC1, COLUMN_Y1SPACE, "y1")) {
            return false;
        }
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_X2, COLUMN_XC2, COLUMN_X2SPACE, "x2")) {
            return false;
        }
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_Y2, COLUMN_YC2, COLUMN_Y2SPACE, "y2")) {
            return false;
        }
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_X1SPACE, "x1Space");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_Y1SPACE, "y1Space");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_X2SPACE, "x2Space");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_Y2SPACE, "y2Space");
        AnnoDatasetParser.setCommonAttrs(elem, m, obs);
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_SHAPE, "arrowHeadShape");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_DIRECTION, "arrowHeadDirection");
        AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_SCALE, "arrowHeadScale");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_LINESTYLEELEMENT, "lineAttrs");
        AnnoDatasetParser.addAttrBundle(doc, elem, "LineAttrs", new String[]{COLUMN_LINECOLOR, COLUMN_LINEPATTERN, COLUMN_LINETHICKNESS}, new String[]{"color", "pattern", "thickness"}, m, obs);
        return true;
    }

    private static String cleanUnicode(String str) {
        int idx;
        int idx2;
        int start = 0;
        while (str.indexOf("&#x", start) >= 0 && (idx2 = str.indexOf(";", idx = str.indexOf("&#x", start))) >= 0 && idx2 - idx <= 9) {
            String subStr = str.substring(idx + 3, idx2);
            try {
                int num = Integer.parseInt(subStr, 16);
                str = str.replace("&#x" + subStr + ";", Character.toString((char)num));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++start;
        }
        return str;
    }

    private static Element createTextItems(Document doc, Element elem, String label) {
        Element item;
        label = AnnoDatasetParser.cleanUnicode(label);
        label = label.replaceAll("&lt;", "<");
        label = label.replaceAll("&gt;", ">");
        label = label.replaceAll("&amp;", "&");
        label = label.replaceAll("&#39;", "'");
        label = label.replaceAll("&quot;", "\"");
        label = label.replaceAll("__SUP_", "\u0001");
        label = label.replaceAll("_SUP__", "\u0003");
        label = label.replaceAll("__SUB_", "\u0002");
        label = label.replaceAll("_SUB__", "\u0003");
        StringTokenizer st = new StringTokenizer(label, "\u0001\u0002\u0003", true);
        Element theElemToAttachTextAttrs = item = doc.createElement("EntryItem");
        elem.appendChild(item);
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            if (str.equals("\u0001")) {
                Element sup = doc.createElement("Sup");
                elem.appendChild(sup);
                item = doc.createElement("EntryItem");
                sup.appendChild(item);
                theElemToAttachTextAttrs = sup;
                continue;
            }
            if (str.equals("\u0002")) {
                Element sub = doc.createElement("Sub");
                elem.appendChild(sub);
                item = doc.createElement("EntryItem");
                sub.appendChild(item);
                theElemToAttachTextAttrs = sub;
                continue;
            }
            if (str.equals("\u0003")) {
                item = doc.createElement("EntryItem");
                elem.appendChild(item);
                continue;
            }
            if (str.trim().length() <= 0) continue;
            item.setTextContent(str);
        }
        return theElemToAttachTextAttrs;
    }

    private static boolean createText(Document doc, Element elem, DataModel m, int obs) {
        String label = AnnoDatasetParser.getStringValue(m, COLUMN_LABEL, obs);
        if (label == null || label.trim().isEmpty()) {
            return false;
        }
        AnnoDatasetParser.createTextItems(doc, elem, label);
        AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_X1, COLUMN_XC1, COLUMN_X1SPACE, "x");
        AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_Y1, COLUMN_YC1, COLUMN_Y1SPACE, "y");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_X1SPACE, "xSpace");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_Y1SPACE, "ySpace");
        AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_WIDTH, "width");
        AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_HEIGHT, "height");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_WIDTHUNIT, "widthUnit");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_HEIGHTUNIT, "heightUnit");
        AnnoDatasetParser.setCommonAttrs(elem, m, obs);
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_ANCHOR, "anchor");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_BORDER, "border");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_JUSTIFY, "justify");
        AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_ROTATE, "rotate");
        AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_PAD, "pad");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_TEXTSTYLEELEMENT, "textAttrs");
        AnnoDatasetParser.addAttrBundle(doc, elem, "TextAttrs", new String[]{COLUMN_TEXTCOLOR, COLUMN_TEXTFONT, COLUMN_TEXTSIZE, COLUMN_TEXTSTYLE, COLUMN_TEXTWEIGHT}, new String[]{"color", "family", "size", "style", "weight"}, m, obs);
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_LINESTYLEELEMENT, "borderAttrs");
        AnnoDatasetParser.addAttrBundle(doc, elem, "BorderAttrs", new String[]{COLUMN_LINECOLOR, COLUMN_LINEPATTERN, COLUMN_LINETHICKNESS}, new String[]{"color", "pattern", "thickness"}, m, obs);
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_FILLSTYLEELEMENT, "backgroundAttrs");
        AnnoDatasetParser.addAttrBundle(doc, elem, "BackgroundAttrs", new String[]{COLUMN_FILLCOLOR, COLUMN_FILLTRANSPARENCY}, new String[]{"color", "transparency"}, m, obs);
        return true;
    }

    private static boolean continueText(Document doc, Element elem, DataModel m, int obs) {
        String label = AnnoDatasetParser.getStringValue(m, COLUMN_LABEL, obs);
        if (label == null || label.trim().isEmpty()) {
            return false;
        }
        Element item = AnnoDatasetParser.createTextItems(doc, elem, label);
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_TEXTSTYLEELEMENT, "textAttrs");
        AnnoDatasetParser.addAttrBundle(doc, item, "TextAttrs", new String[]{COLUMN_TEXTCOLOR, COLUMN_TEXTFONT, COLUMN_TEXTSIZE, COLUMN_TEXTSTYLE, COLUMN_TEXTWEIGHT}, new String[]{"color", "family", "size", "style", "weight"}, m, obs);
        return true;
    }

    private static boolean createImage(Document doc, Element elem, DataModel m, int obs) {
        if (!AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_IMAGE, "image")) {
            return false;
        }
        AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_X1, COLUMN_XC1, COLUMN_X1SPACE, "x");
        AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_Y1, COLUMN_YC1, COLUMN_Y1SPACE, "y");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_X1SPACE, "xSpace");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_Y1SPACE, "ySpace");
        AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_WIDTH, "width");
        AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_HEIGHT, "height");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_WIDTHUNIT, "widthUnit");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_HEIGHTUNIT, "heightUnit");
        AnnoDatasetParser.setCommonAttrs(elem, m, obs);
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_ANCHOR, "anchor");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_BORDER, "border");
        AnnoDatasetParser.setNumAttr(elem, m, obs, COLUMN_ROTATE, "rotate");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_IMAGESCALE, "scale");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_LINESTYLEELEMENT, "borderAttrs");
        AnnoDatasetParser.addAttrBundle(doc, elem, "BorderAttrs", new String[]{COLUMN_LINECOLOR, COLUMN_LINEPATTERN, COLUMN_LINETHICKNESS}, new String[]{"color", "pattern", "thickness"}, m, obs);
        return true;
    }

    private static boolean createPolygon(Document doc, Element elem, DataModel m, int obs) {
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_X1, COLUMN_XC1, COLUMN_X1SPACE, "x")) {
            return false;
        }
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_Y1, COLUMN_YC1, COLUMN_Y1SPACE, "y")) {
            return false;
        }
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_X1SPACE, "xSpace");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_Y1SPACE, "ySpace");
        AnnoDatasetParser.setCommonAttrs(elem, m, obs);
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_DISPLAY, "display");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_LINESTYLEELEMENT, "outlineAttrs");
        AnnoDatasetParser.addAttrBundle(doc, elem, "OutlineAttrs", new String[]{COLUMN_LINECOLOR, COLUMN_LINEPATTERN, COLUMN_LINETHICKNESS}, new String[]{"color", "pattern", "thickness"}, m, obs);
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_FILLSTYLEELEMENT, "fillAttrs");
        AnnoDatasetParser.addAttrBundle(doc, elem, "FillAttrs", new String[]{COLUMN_FILLCOLOR, COLUMN_FILLTRANSPARENCY}, new String[]{"color", "transparency"}, m, obs);
        return true;
    }

    private static boolean createPolyline(Document doc, Element elem, DataModel m, int obs) {
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_X1, COLUMN_XC1, COLUMN_X1SPACE, "x")) {
            return false;
        }
        if (!AnnoDatasetParser.setPosAttr(elem, m, obs, COLUMN_Y1, COLUMN_YC1, COLUMN_Y1SPACE, "y")) {
            return false;
        }
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_X1SPACE, "xSpace");
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_Y1SPACE, "ySpace");
        AnnoDatasetParser.setCommonAttrs(elem, m, obs);
        AnnoDatasetParser.setStrAttr(elem, m, obs, COLUMN_LINESTYLEELEMENT, "lineAttrs");
        AnnoDatasetParser.addAttrBundle(doc, elem, "LineAttrs", new String[]{COLUMN_LINECOLOR, COLUMN_LINEPATTERN, COLUMN_LINETHICKNESS}, new String[]{"color", "pattern", "thickness"}, m, obs);
        return true;
    }

    private static boolean continuePoly(Document doc, Element elem, DataModel m, int obs) {
        Element drawElem = doc.createElement("Draw");
        if (!AnnoDatasetParser.setPosAttr(drawElem, m, obs, COLUMN_X1, COLUMN_XC1, COLUMN_X1SPACE, "x")) {
            return false;
        }
        if (!AnnoDatasetParser.setPosAttr(drawElem, m, obs, COLUMN_Y1, COLUMN_YC1, COLUMN_Y1SPACE, "y")) {
            return false;
        }
        AnnoDatasetParser.setStrAttr(drawElem, m, obs, COLUMN_X1SPACE, "xSpace");
        AnnoDatasetParser.setStrAttr(drawElem, m, obs, COLUMN_Y1SPACE, "ySpace");
        AnnoDatasetParser.setStrAttr(drawElem, m, obs, COLUMN_DRAWSPACE, "drawSpace");
        elem.appendChild(drawElem);
        return true;
    }
}

