/*
 * Decompiled with CFR 0.152.
 */
package com.sas.security.password.util;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.security.password.util.IndexedKeyValuePair;
import com.sas.security.password.util.InvalidFormatException;
import com.sas.security.password.util.PWResourceBundle;
import com.sas.security.password.util.StringUtil;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;

public class PasswordUpdater {
    private static String m_file;
    private static String m_metaRepositoryName;
    private static String m_metaPass;
    private static String m_metaUser;
    private static String m_metaPort;
    private static String m_metaServer;
    private static CMetadata m_repository;
    private static MdObjectStore m_store;
    private static MdOMRConnection m_metaWorkspace;
    private static MdFactory m_factory;
    private static LoginData[] m_loginDataArray;
    private static boolean m_verbose;
    private static boolean m_noPrompt;
    private static final String META_SERVER = "-metaServer";
    private static final String META_PORT = "-metaPort";
    private static final String META_USER = "-metaUser";
    private static final String META_PASSWORD = "-metaPass";
    private static final String META_REPOSITORY = "-metaRepository";
    private static final String FILE = "-file";
    private static final String DASH = "-";
    private static final String VERBOSE = "-verbose";
    private static final String NO_PROMPT = "-NoPrompt";
    private static final String USER_ID_STR = "-userID";
    private static final String AUTHDOM_STR = "-authDom";
    private static final String PASSWORD_STR = "-password";
    private static final String IDENTITY_NAME_STR = "-ownerName";
    private static final String IDENTITY_TYPE_STR = "-ownerType";
    private static final String LOGFILE_STR = "-logFile";
    private static final String ERRORFILE_STR = "-errorFile";
    private static String m_userID;
    private static String m_authDom;
    private static String m_password;
    private static String m_identityName;
    private static String m_identityType;
    private static String m_logFile;
    private static String m_errorFile;
    private static PrintWriter m_logWriter;
    private static final int USER_ID = 0;
    private static final int AUTH_DOMAIN = 1;
    private static final int PASSWORD = 2;
    private static final int IDENTITY_NAME = 3;
    private static final int IDENTITY_TYPE = 4;
    private static final int SUCCESS = 0;
    private static final int SOME_ERRORS = 8;
    private static final int FAILURE = 32;
    private static int m_errorCode;
    private static final String[][] KEY_ARRAYS;
    protected static final PWResourceBundle bundle;

    private PasswordUpdater() {
    }

    public static void main(String[] args) {
        PasswordUpdater.processCommandLineArguments(args);
        PrintStream err = null;
        try {
            if (m_logFile != null) {
                m_logWriter = new PrintWriter(new FileOutputStream(m_logFile, true));
            }
            if (m_errorFile != null && (err = new PrintStream(new FileOutputStream(m_errorFile, true))) != null) {
                System.setErr(err);
            }
            if (m_verbose) {
                PasswordUpdater.printlnLog("\n" + new Date() + ": " + bundle.getString("PasswordSynchronizer.ConnectToMetaServer.txt"));
            }
            PasswordUpdater.connectToMetadataServer(m_metaServer, m_metaPort, m_metaUser, m_metaPass, m_metaRepositoryName);
            if (m_verbose) {
                PasswordUpdater.printlnLog(new Date() + ": " + bundle.messageString("PasswordSynchronizer.ConnectedToMetaServerAtPort.txt", m_metaServer, m_metaPort));
            }
        }
        catch (FileNotFoundException e2) {
            System.err.println(new Date() + ": " + e2.getMessage());
        }
        catch (Exception e) {
            PasswordUpdater.printErrorMessageAndExit(e.getMessage());
        }
        if (m_file != null) {
            PasswordUpdater.readAndUpdateLoginFromFile();
        } else if (m_noPrompt) {
            PasswordUpdater.readAndUpdateLoginFromStdin();
        } else if (m_userID != null && m_authDom != null && m_password != null) {
            try {
                PasswordUpdater.updatePassword(m_userID, m_authDom, m_password, m_identityName, m_identityType);
                PasswordUpdater.printlnLog(new Date() + ": " + bundle.messageString("PasswordSynchronizer.LoginUpdated.txt", "[userID =" + m_userID + "  authDom = " + m_authDom + "]"));
            }
            catch (Exception e2) {
                System.err.println(new Date() + ": " + e2.getMessage());
                m_errorCode |= 8;
            }
        } else if (m_userID != null || m_authDom != null || m_password != null) {
            PasswordUpdater.printUsageAndExit();
        } else {
            PasswordUpdater.readAndUpdateLoginFromCommandPrompt();
        }
        if (m_logFile != null && m_logWriter != null) {
            m_logWriter.close();
        }
        if (err != null) {
            err.close();
        }
        try {
            m_loginDataArray = null;
            m_metaPass = null;
            m_password = null;
            PasswordUpdater.disconnect();
        }
        catch (RemoteException e3) {
            e3.printStackTrace();
        }
        if (m_verbose) {
            PasswordUpdater.printlnLog("\n" + new Date() + ": " + bundle.getString("PasswordSynchronizer.DisConnectToMetaServer.txt"));
        }
        if (m_errorCode != 0) {
            System.exit(8);
        } else {
            System.exit(0);
        }
    }

    private static void readAndUpdateLoginFromFile() {
        int i;
        m_loginDataArray = PasswordUpdater.readLoginData();
        if (m_verbose) {
            PasswordUpdater.printlnLog(new Date() + ": " + bundle.getString("PasswordSynchronizer.RetrievingLogin.txt"));
        }
        int loginsCount = 0;
        int[] updatedLoginIndexArray = new int[m_loginDataArray.length];
        for (i = 0; i < m_loginDataArray.length; ++i) {
            try {
                m_loginDataArray[i].updatePassword();
            }
            catch (Exception e1) {
                m_errorCode |= 8;
                System.err.println(new Date() + ": " + e1.getMessage());
            }
            if (m_loginDataArray[i].m_login == null) continue;
            updatedLoginIndexArray[loginsCount++] = i;
        }
        if (m_verbose) {
            PasswordUpdater.printlnLog(new Date() + ": " + bundle.messageString("PasswordSynchronizer.TotalNumberLogin.txt", new Integer(loginsCount)));
        }
        try {
            if (loginsCount > 0) {
                if (m_verbose) {
                    PasswordUpdater.printlnLog(new Date() + ": " + bundle.getString("PasswordSynchronizer.UpdatingLogin.txt"));
                }
                m_store.updatedMetadataAll();
                PasswordUpdater.printlnLog(new Date() + ": " + bundle.messageString("PasswordSynchronizer.TotalNumberLoginUpdated.txt", new Integer(loginsCount)));
            }
            for (i = 0; i < loginsCount; ++i) {
                PasswordUpdater.printlnLog("userID = " + m_loginDataArray[updatedLoginIndexArray[i]].getUserID() + "  authDom = " + m_loginDataArray[updatedLoginIndexArray[i]].getAuthDomainName());
            }
        }
        catch (Exception e) {
            m_errorCode |= 8;
            System.err.println(new Date() + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readAndUpdateLoginFromStdin() {
        BufferedReader in = null;
        int loginsCount = 0;
        try {
            in = new LineNumberReader(new InputStreamReader(System.in));
            String line = null;
            while ((line = ((LineNumberReader)in).readLine()) != null) {
                LoginData data = new LoginData(line, ((LineNumberReader)in).getLineNumber());
                try {
                    if (!data.updatePassword()) continue;
                    m_store.updatedMetadataAll();
                    ++loginsCount;
                    PasswordUpdater.printlnLog(new Date() + ": " + bundle.messageString("PasswordSynchronizer.LoginUpdated.txt", "\"userID =" + data.getUserID() + "  authDom = " + data.getAuthDomainName() + "\""));
                }
                catch (Exception e1) {
                    m_errorCode |= 8;
                    System.err.println(new Date() + ": " + e1.getMessage());
                }
                finally {
                    data = null;
                }
            }
        }
        catch (IOException e) {
            PasswordUpdater.printErrorMessageAndExit(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (loginsCount > 0) {
            PasswordUpdater.printlnLog(new Date() + ": " + bundle.messageString("PasswordSynchronizer.NumberLoginUpdated.txt", new Integer(loginsCount)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readAndUpdateLoginFromCommandPrompt() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String userID = null;
        String authDomain = null;
        String password = null;
        String moreLogin = null;
        boolean hasMoreLogins = true;
        try {
            while (hasMoreLogins) {
                String identityName = null;
                String identityType = null;
                boolean validUserID = false;
                do {
                    System.out.print(bundle.getString("PasswordSynchronizer.EnterUserID.txt"));
                    userID = br.readLine();
                    userID = userID.trim();
                    userID = StringEscapeUtils.escapeHtml((String)userID);
                    if (userID.length() == 0) {
                        System.out.println(bundle.getString("PasswordSynchronizer.InvalidUserID.txt"));
                        continue;
                    }
                    validUserID = true;
                } while (!validUserID);
                System.out.print(bundle.getString("PasswordSynchronizer.EnterDomainName.txt"));
                authDomain = br.readLine();
                authDomain = StringEscapeUtils.escapeHtml((String)authDomain);
                boolean reEnterPassword = true;
                while (reEnterPassword) {
                    System.out.print(bundle.getString("PasswordSynchronizer.EnterPassword.txt"));
                    password = br.readLine();
                    System.out.print(bundle.getString("PasswordSynchronizer.ConfirmPassword.txt"));
                    String password2 = br.readLine();
                    reEnterPassword = !password.equals(password2);
                    password2 = null;
                }
                String yes = bundle.getString("PasswordSynchronizer.Yes.txt");
                String identityYesNo = bundle.getString("PasswordSynchronizer.VerifyIdentity.YesNo.txt");
                System.out.print(identityYesNo);
                String verifyYesNo = br.readLine();
                if (verifyYesNo != null && verifyYesNo.equalsIgnoreCase(yes)) {
                    System.out.print(bundle.getString("PasswordSynchronizer.EnterIdentityName.txt"));
                    identityName = br.readLine().trim();
                    if (identityName.length() == 0) {
                        identityName = null;
                    }
                    System.out.print(bundle.getString("PasswordSynchronizer.EnterIdentityType.txt"));
                    identityType = br.readLine().trim();
                    if (identityType.length() == 0) {
                        identityType = null;
                    }
                }
                try {
                    PasswordUpdater.updatePassword(userID, authDomain, password, identityName, identityType);
                    if (m_logWriter != null) {
                        System.out.println(new Date() + ": " + bundle.messageString("PasswordSynchronizer.LoginUpdated.txt", "[userID =" + userID + "  authDom = " + authDomain + "]"));
                    }
                    PasswordUpdater.printlnLog(new Date() + ": " + bundle.messageString("PasswordSynchronizer.LoginUpdated.txt", "[userID =" + userID + "  authDom = " + authDomain + "]"));
                }
                catch (Exception e2) {
                    System.out.println("\n" + new Date() + ": " + e2.getMessage());
                }
                String yesNo = bundle.getString("PasswordSynchronizer.YesNo.txt");
                System.out.print(bundle.messageString("PasswordSynchronizer.MoreLogins.txt", yesNo));
                moreLogin = br.readLine();
                if (moreLogin == null || moreLogin.equalsIgnoreCase(yes)) continue;
                hasMoreLogins = false;
            }
        }
        catch (IOException e) {
            m_errorCode |= 8;
            System.err.println(new Date() + ": " + e.getMessage());
        }
        finally {
            password = null;
            try {
                br.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private static void processCommandLineArguments(String[] saArgs) {
        for (int iArgCount = 0; iArgCount < saArgs.length; ++iArgCount) {
            if (saArgs[iArgCount].equalsIgnoreCase(META_SERVER)) {
                if (iArgCount + 1 < saArgs.length && saArgs[iArgCount + 1].startsWith(DASH) || iArgCount + 1 == saArgs.length) continue;
                m_metaServer = saArgs[++iArgCount];
                continue;
            }
            if (saArgs[iArgCount].equalsIgnoreCase(META_PORT)) {
                if (iArgCount + 1 < saArgs.length && saArgs[iArgCount + 1].startsWith(DASH) || iArgCount + 1 == saArgs.length) continue;
                m_metaPort = saArgs[++iArgCount];
                continue;
            }
            if (saArgs[iArgCount].equalsIgnoreCase(META_USER)) {
                if (iArgCount + 1 < saArgs.length && saArgs[iArgCount + 1].startsWith(DASH) || iArgCount + 1 == saArgs.length) continue;
                m_metaUser = saArgs[++iArgCount];
                continue;
            }
            if (saArgs[iArgCount].equalsIgnoreCase(META_PASSWORD)) {
                if (iArgCount + 1 < saArgs.length && saArgs[iArgCount + 1].startsWith(DASH) || iArgCount + 1 == saArgs.length) continue;
                m_metaPass = saArgs[++iArgCount];
                continue;
            }
            if (saArgs[iArgCount].equalsIgnoreCase(META_REPOSITORY)) {
                if (iArgCount + 1 < saArgs.length && saArgs[iArgCount + 1].startsWith(DASH) || iArgCount + 1 == saArgs.length) continue;
                m_metaRepositoryName = saArgs[++iArgCount];
                continue;
            }
            if (saArgs[iArgCount].equalsIgnoreCase(FILE)) {
                if (iArgCount + 1 < saArgs.length && saArgs[iArgCount + 1].startsWith(DASH) || iArgCount + 1 == saArgs.length) continue;
                m_file = saArgs[++iArgCount];
                continue;
            }
            if (saArgs[iArgCount].equalsIgnoreCase(VERBOSE)) {
                m_verbose = true;
                continue;
            }
            if (saArgs[iArgCount].equalsIgnoreCase(NO_PROMPT)) {
                m_noPrompt = true;
                continue;
            }
            if (saArgs[iArgCount].equalsIgnoreCase(USER_ID_STR)) {
                if (iArgCount + 1 < saArgs.length && saArgs[iArgCount + 1].startsWith(DASH) || iArgCount + 1 == saArgs.length) continue;
                m_userID = saArgs[++iArgCount];
                continue;
            }
            if (saArgs[iArgCount].equalsIgnoreCase(AUTHDOM_STR)) {
                if (iArgCount + 1 < saArgs.length && saArgs[iArgCount + 1].startsWith(DASH) || iArgCount + 1 == saArgs.length) continue;
                m_authDom = saArgs[++iArgCount];
                continue;
            }
            if (saArgs[iArgCount].equalsIgnoreCase(PASSWORD_STR)) {
                if (iArgCount + 1 < saArgs.length && saArgs[iArgCount + 1].startsWith(DASH) || iArgCount + 1 == saArgs.length) continue;
                m_password = saArgs[++iArgCount];
                continue;
            }
            if (saArgs[iArgCount].equalsIgnoreCase(LOGFILE_STR)) {
                if (iArgCount + 1 < saArgs.length && saArgs[iArgCount + 1].startsWith(DASH) || iArgCount + 1 == saArgs.length) continue;
                m_logFile = saArgs[++iArgCount];
                continue;
            }
            if (saArgs[iArgCount].equalsIgnoreCase(ERRORFILE_STR)) {
                if (iArgCount + 1 < saArgs.length && saArgs[iArgCount + 1].startsWith(DASH) || iArgCount + 1 == saArgs.length) continue;
                m_errorFile = saArgs[++iArgCount];
                continue;
            }
            if (saArgs[iArgCount].equalsIgnoreCase(IDENTITY_NAME_STR)) {
                if (iArgCount + 1 < saArgs.length && saArgs[iArgCount + 1].startsWith(DASH) || iArgCount + 1 == saArgs.length) continue;
                m_identityName = saArgs[++iArgCount];
                continue;
            }
            if (!saArgs[iArgCount].equalsIgnoreCase(IDENTITY_TYPE_STR) || iArgCount + 1 < saArgs.length && saArgs[iArgCount + 1].startsWith(DASH) || iArgCount + 1 == saArgs.length) continue;
            m_identityType = saArgs[++iArgCount];
        }
        if (m_metaRepositoryName == null || m_metaRepositoryName.trim().length() == 0) {
            m_metaRepositoryName = "Foundation";
        }
        if (m_metaServer == null || m_metaPort == null || m_metaUser == null || m_metaPass == null) {
            PasswordUpdater.printUsageAndExit();
        }
    }

    private static void printUsageAndExit() {
        System.err.println(bundle.getString("PasswordSynchronizer.CommandUsage.txt"));
        System.exit(32);
    }

    private static void printErrorMessageAndExit(String msg) {
        System.err.println(msg);
        if (m_verbose) {
            PasswordUpdater.printlnLog("\n" + new Date() + ": " + bundle.getString("PasswordSynchronizer.DisConnectToMetaServer.txt"));
        }
        System.exit(32);
    }

    private static CMetadata getRepository(String repositoryName) throws MdException, RemoteException {
        CMetadata repos = null;
        List repositoryList = null;
        repositoryList = m_factory.getOMIUtil().getRepositories();
        if (repositoryList == null || repositoryList.isEmpty()) {
            return null;
        }
        for (int i = 0; i < repositoryList.size(); ++i) {
            repos = (CMetadata)repositoryList.get(i);
            if (!repos.getName().equalsIgnoreCase(repositoryName)) continue;
            return repos;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LoginData[] readLoginData() {
        ArrayList<LoginData> loginDataList = new ArrayList<LoginData>();
        BufferedReader in = null;
        try {
            if (m_verbose) {
                PasswordUpdater.printlnLog(new Date() + ": " + bundle.messageString("PasswordSynchronizer.OpeningPasswordFile.txt", m_file));
            }
            File file = new File(m_file);
            String canonicalPath = file.getCanonicalPath();
            FileReader fr = new FileReader(canonicalPath);
            in = new LineNumberReader(fr);
            String line = null;
            while ((line = ((LineNumberReader)in).readLine()) != null) {
                loginDataList.add(new LoginData(line, ((LineNumberReader)in).getLineNumber()));
            }
        }
        catch (IOException e) {
            PasswordUpdater.printErrorMessageAndExit(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        LoginData[] dataArray = new LoginData[loginDataList.size()];
        loginDataList.toArray(dataArray);
        return dataArray;
    }

    public static void connectToMetadataServer(IOMI iomConnection, String repositoryName) throws RemoteException, MdException {
        m_metaRepositoryName = repositoryName;
        m_factory = new MdFactoryImpl(false);
        m_metaWorkspace = m_factory.getConnection();
        m_metaWorkspace.setCMRHandle(iomConnection);
        m_store = m_factory.createObjectStore();
        m_factory.getInstance().setLoggingEnabled(false);
        m_repository = PasswordUpdater.getRepository(m_metaRepositoryName);
        if (m_repository == null) {
            throw new MdException(bundle.messageString("PasswordSynchronizer.NoRepositoryFound.fmt.txt", m_metaRepositoryName));
        }
    }

    public static void connectToMetadataServer(String metaServer, String metaPort, String metaUser, String metaPassword, String repositoryName) throws RemoteException, MdException {
        m_metaServer = metaServer;
        m_metaPort = metaPort;
        m_metaUser = metaUser;
        m_metaPass = metaPassword;
        m_metaRepositoryName = repositoryName;
        m_factory = new MdFactoryImpl(false);
        m_metaWorkspace = m_factory.getConnection();
        m_metaWorkspace.makeOMRConnection(m_metaServer, m_metaPort, m_metaUser, m_metaPass);
        m_factory.getInstance().setLoggingEnabled(false);
        m_repository = PasswordUpdater.getRepository(m_metaRepositoryName);
        m_store = m_factory.createObjectStore();
        if (m_repository == null) {
            PasswordUpdater.disconnect();
            throw new MdException(bundle.messageString("PasswordSynchronizer.NoRepositoryFound.fmt.txt", m_metaRepositoryName));
        }
    }

    public static void updatePassword(String userID, String authDomainName, String newPassword) throws MdException, RemoteException {
        PasswordUpdater.updatePassword(userID, authDomainName, newPassword, null, null);
    }

    public static void updatePassword(String userID, String authDomainName, String newPassword, String identityName, String identityType) throws MdException, RemoteException {
        LoginData data;
        if (authDomainName == null) {
            authDomainName = "";
        }
        if ((data = new LoginData(userID, authDomainName, newPassword, identityName, identityType)).updatePassword()) {
            m_store.updatedMetadataAll();
        }
        data = null;
    }

    private static void printlnLog(String msg) {
        msg = StringEscapeUtils.escapeHtml((String)msg);
        if (m_logWriter != null) {
            m_logWriter.println(msg);
        } else {
            System.out.println(msg);
        }
    }

    public static void disconnect() throws RemoteException {
        if (m_metaWorkspace != null) {
            m_metaWorkspace.closeOMRConnection();
        }
    }

    private static Login getLoginObjectByUserIDandAuthDomain(String userID, String authDomainName, String strReposId) throws MdException, RemoteException {
        String searchOptions = (authDomainName = authDomainName.trim()).length() != 0 ? "<TEMPLATES><Login Id=\"\" UserID=\"\"/></TEMPLATES><XMLSELECT search=\"Login[@UserID = '" + userID + "'][Domain/AuthenticationDomain[@Name = '" + authDomainName + "'] ] \"/>" : "<TEMPLATES><Login Id=\"\" UserID=\"\"/></TEMPLATES><XMLSELECT search=\"Login[@UserID = '" + userID + "']\"/>";
        int flags = 8596;
        List objects = m_factory.getOMIUtil().getMetadataObjectsSubset((MdStore)m_store, strReposId, "Login", flags, searchOptions);
        if (objects.size() == 1) {
            return (Login)objects.get(0);
        }
        if (objects.size() > 1) {
            for (int i = 0; i < objects.size(); ++i) {
                AuthenticationDomain domain = ((Login)objects.get(i)).getDomain();
                if (!(domain == null ? authDomainName.length() == 0 : authDomainName.equalsIgnoreCase(domain.getName()))) continue;
                return (Login)objects.get(i);
            }
        }
        return null;
    }

    static {
        m_errorCode = 0;
        KEY_ARRAYS = new String[][]{{"UserID", "Login:UserID", "UID", "Login", "ID"}, {"AuthDom", "AuthenticationDomain:Name", "Domain", "AuthDomain", "DM", "DomainName"}, {"Password", "Login:Password", "Passwd", "PWD", "PW"}, {"IdentityName", "Identity", "Owner", "OwnerName", "OwningIdentity"}, {"IdentityType", "OwnerType", "OwningIdentityType"}};
        bundle = new PWResourceBundle(PasswordUpdater.class);
    }

    static class LoginData {
        private String m_userID;
        private String m_authDomainName;
        private String m_password;
        private String m_identityName;
        private String m_identityType;
        private Login m_login;
        private boolean m_isValid = true;
        private int m_lineNumber = -1;

        public LoginData(String inputLine, int lineNumber) {
            this.m_lineNumber = lineNumber;
            if (inputLine == null || inputLine.length() == 0) {
                this.m_isValid = false;
            } else {
                this.processInputLine(inputLine);
            }
        }

        public LoginData(String userID, String authDomanName, String passWord) {
            this.m_userID = userID;
            this.m_authDomainName = authDomanName;
            this.m_password = passWord;
            if (this.m_userID == null || this.m_userID.length() == 0 || this.m_authDomainName == null || this.m_password == null) {
                this.m_isValid = false;
            }
            this.m_isValid = this.m_userID != null && this.m_userID.length() != 0 && this.m_authDomainName != null && this.m_password != null;
        }

        public LoginData(String userID, String authDomanName, String passWord, String identityName, String identityType) {
            this(userID, authDomanName, passWord);
            this.m_identityName = identityName;
            this.m_identityType = identityType;
        }

        public boolean isValid() {
            return this.m_isValid;
        }

        public void processInputLine(String inputLine) {
            IndexedKeyValuePair[] pairs;
            try {
                pairs = StringUtil.getIndexedKeyValuePairs(inputLine, KEY_ARRAYS);
            }
            catch (InvalidFormatException e) {
                if (this.isValid() && this.m_lineNumber != -1) {
                    System.err.println(new Date() + ": " + bundle.messageString("LoginData.InvalidInputLine.ParsingError.txt", new Integer(this.m_lineNumber), e.getMessage()));
                    m_errorCode |= 8;
                }
                this.m_isValid = false;
                return;
            }
            block9: for (int i = 0; i < pairs.length; ++i) {
                String value = pairs[i].getValue();
                switch (pairs[i].getIndex()) {
                    case 0: {
                        this.setUserID(value);
                        continue block9;
                    }
                    case 1: {
                        this.setAuthDomainName(value);
                        continue block9;
                    }
                    case 2: {
                        this.setPassword(value);
                        continue block9;
                    }
                    case 3: {
                        this.setIdentityName(value);
                        continue block9;
                    }
                    case 4: {
                        this.setIdentityType(value);
                    }
                }
            }
            if (!this.isValid()) {
                return;
            }
            if (this.m_userID == null) {
                System.err.println(new Date() + ": " + bundle.messageString("LoginData.InvalidInputLine.MissingUserID.txt", new Integer(this.m_lineNumber)));
                this.m_isValid = false;
                m_errorCode |= 8;
            } else if (this.m_userID.length() == 0) {
                System.err.println(new Date() + ": " + bundle.messageString("LoginData.InvalidInputLine.InvalidUserID.txt", new Integer(this.m_lineNumber)));
                this.m_isValid = false;
                m_errorCode |= 8;
            } else if (this.m_authDomainName == null) {
                System.err.println(new Date() + ": " + bundle.messageString("LoginData.InvalidInputLine.MissingAuthDomain.txt", new Integer(this.m_lineNumber)));
                this.m_isValid = false;
                m_errorCode |= 8;
            } else if (this.m_password == null) {
                System.err.println(new Date() + ": " + bundle.messageString("LoginData.InvalidInputLine.MissingPassword.txt", new Integer(this.m_lineNumber)));
                this.m_isValid = false;
                m_errorCode |= 8;
            }
        }

        public String getAuthDomainName() {
            return this.m_authDomainName;
        }

        public String getPassword() {
            return this.m_password;
        }

        public String getUserID() {
            return this.m_userID;
        }

        public void setAuthDomainName(String authDomainName) {
            this.m_authDomainName = authDomainName;
        }

        public void setPassword(String password) {
            this.m_password = password;
        }

        public void setUserID(String userID) {
            this.m_userID = userID;
        }

        public String getIdentityType() {
            return this.m_identityType;
        }

        public void setIdentityType(String type) {
            this.m_identityType = type;
        }

        public String getIdentityName() {
            return this.m_identityName;
        }

        public void setIdentityName(String name) {
            this.m_identityName = name;
        }

        private Login getLogin() throws MdException, RemoteException {
            if (this.m_login != null) {
                return this.m_login;
            }
            if (!this.isValid()) {
                return null;
            }
            this.m_login = PasswordUpdater.getLoginObjectByUserIDandAuthDomain(this.m_userID, this.m_authDomainName, m_repository.getFQID());
            return this.m_login;
        }

        public boolean updatePassword() throws MdException, RemoteException {
            Identity owner;
            this.getLogin();
            if (!this.isValid()) {
                return false;
            }
            if (this.m_login == null) {
                m_errorCode |= 8;
                throw new MdException(bundle.messageString("PasswordSynchronizer.UnableToRetrieveLogin.txt", this.getDisplayString()));
            }
            if ((this.m_identityName != null || this.m_identityType != null) && ((owner = this.m_login.getAssociatedIdentity()) == null || this.m_identityName != null && !this.m_identityName.equalsIgnoreCase(owner.getName()) || this.m_identityType != null && !this.m_identityType.equalsIgnoreCase(owner.getCMetadataType()))) {
                throw new MdException(bundle.getString("PasswordSynchronizer.InvalidOwningIdentity.txt") + " " + this.getDisplayString());
            }
            if (this.m_password.trim().length() == 0 || SasPasswordString.isEncoded((String)this.m_password)) {
                this.m_login.setPassword(this.m_password);
            } else {
                try {
                    this.m_login.setPassword(SasPasswordString.encode((String)"sas002", (String)this.m_password));
                }
                catch (SasPasswordEncodingException e) {
                    this.m_login.setPassword(this.m_password);
                }
            }
            return true;
        }

        public String getDisplayString() {
            String authDom = this.m_authDomainName.length() == 0 ? "\"\"" : this.m_authDomainName;
            String retStr = KEY_ARRAYS[0][0] + "=\"" + this.m_userID + "\" " + KEY_ARRAYS[1][0] + "=\"" + authDom + "\"";
            if (this.m_identityName != null) {
                retStr = retStr.concat(" " + KEY_ARRAYS[3][0] + "=\"" + this.m_identityName + "\"");
            }
            if (this.m_identityType != null) {
                retStr = retStr.concat(" " + KEY_ARRAYS[4][0] + "=\"" + this.m_identityType + "\"");
            }
            return retStr;
        }
    }
}

