/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.environment.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class EnvironmentResolver
implements EntityResolver {
    public static final String SAS_SCHEMA_MAPPINGS_LOCATION = "META-INF/sas.schemas";
    public static final String EXTERNAL_SCHEMA_MAPPINGS_LOCATION = "META-INF/external.schemas";
    private static final Logger logger = LogManager.getLogger(EnvironmentResolver.class);
    private final ClassLoader classLoader;
    private final String schemaMappingsLocation;
    private Properties schemaMappings;

    public EnvironmentResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.schemaMappingsLocation = SAS_SCHEMA_MAPPINGS_LOCATION;
    }

    public EnvironmentResolver(ClassLoader classLoader, String schemaMappingsLocation) {
        this.classLoader = classLoader;
        this.schemaMappingsLocation = schemaMappingsLocation;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        String resourceLocation;
        if (logger.isTraceEnabled()) {
            logger.trace("Trying to resolve XML entity with public id [" + publicId + "] and system id [" + systemId + "]");
        }
        if (systemId != null && (resourceLocation = this.getSchemaMapping(systemId)) != null) {
            InputSource source = new InputSource(this.classLoader.getResourceAsStream(resourceLocation));
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            if (logger.isDebugEnabled()) {
                logger.debug("Found XML schema [" + systemId + "] in classpath: " + resourceLocation);
            }
            return source;
        }
        if (systemId.contains("www.sas.com/xml/schema/sas-environments")) {
            return new InputSource();
        }
        return null;
    }

    protected String getSchemaMapping(String systemId) {
        if (this.schemaMappings == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Loading schema mappings from [" + this.schemaMappingsLocation + "]");
            }
            try {
                this.schemaMappings = this.loadAllProperties(this.schemaMappingsLocation, this.classLoader);
                if (logger.isDebugEnabled()) {
                    logger.debug("Loaded schema mappings: " + this.schemaMappings);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load schema mappings from location [" + this.schemaMappingsLocation + "]", ex);
            }
        }
        return this.schemaMappings.getProperty(systemId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadAllProperties(String resourceName, ClassLoader classLoader) throws IOException {
        ClassLoader clToUse = classLoader;
        if (clToUse == null) {
            clToUse = Thread.currentThread().getContextClassLoader();
        }
        Properties properties = new Properties();
        Enumeration<URL> urls = clToUse.getResources(resourceName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream is = null;
            try {
                URLConnection con = url.openConnection();
                con.setUseCaches(false);
                is = con.getInputStream();
                properties.load(is);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return properties;
    }
}

