/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.environment;

import com.sas.svcs.environment.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Environment {
    public static final String JAVA_INTERFACE_TYPE = "java";
    public static final String SOAP_INTERFACE_TYPE = "soap";
    public static final String REST_INTERFACE_TYPE = "rest";
    private String name;
    private String description;
    private String blockDescription;
    private String tooltip;
    private String serviceRegistry;
    private Map<String, String> registries = new HashMap<String, String>();
    private String iomHost;
    private int iomPort;
    private Map<String, Component> components = new HashMap<String, Component>();
    private Map<Locale, String> localizedDescriptions = new HashMap<Locale, String>();
    private Map<Locale, String> localizedBlockDescriptions = new HashMap<Locale, String>();
    private Map<Locale, String> localizedTooltips = new HashMap<Locale, String>();
    private boolean defaultFlag;
    private String platformVersion = "9.3";

    public Environment() {
    }

    public Environment(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public String getDescription(Locale locale) {
        String desc = null;
        List<Locale> locales = this.localeLookupList(locale);
        Iterator<Locale> it = locales.iterator();
        while (it.hasNext() && null == desc) {
            Locale l = it.next();
            desc = this.localizedDescriptions.get(l);
        }
        if (null == desc) {
            return this.getDescription();
        }
        return desc;
    }

    public void setDescription(Locale locale, String desc) {
        this.localizedDescriptions.put(locale, desc);
    }

    public String getBlockDescription() {
        return this.blockDescription == null ? this.description : this.blockDescription;
    }

    public void setBlockDescription(String s) {
        this.blockDescription = s;
    }

    public String getBlockDescription(Locale locale) {
        String blockDesc = null;
        List<Locale> locales = this.localeLookupList(locale);
        Iterator<Locale> it = locales.iterator();
        while (it.hasNext() && null == blockDesc) {
            Locale l = it.next();
            blockDesc = this.localizedBlockDescriptions.get(l);
        }
        if (null == blockDesc) {
            String nonLocalizedBlockDescription = this.getBlockDescription();
            if (nonLocalizedBlockDescription.equals(this.description)) {
                return this.getDescription(locale);
            }
            return nonLocalizedBlockDescription;
        }
        return blockDesc;
    }

    public void setBlockDescription(Locale locale, String blockDesc) {
        this.localizedBlockDescriptions.put(locale, blockDesc);
    }

    public String getTooltip() {
        return this.tooltip == null ? this.description : this.tooltip;
    }

    public void setTooltip(String s) {
        this.tooltip = s;
    }

    public String getTooltip(Locale locale) {
        String tip = null;
        List<Locale> locales = this.localeLookupList(locale);
        Iterator<Locale> it = locales.iterator();
        while (it.hasNext() && null == tip) {
            Locale l = it.next();
            tip = this.localizedTooltips.get(l);
        }
        if (null == tip) {
            String nonLocalizedTip = this.getTooltip();
            if (nonLocalizedTip.equals(this.description)) {
                return this.getDescription(locale);
            }
            return nonLocalizedTip;
        }
        return tip;
    }

    public void setTooltip(Locale locale, String tooltip) {
        this.localizedTooltips.put(locale, tooltip);
    }

    public String getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setServiceRegistry(String s) {
        this.serviceRegistry = s;
    }

    public void addRegistry(String type, String url) {
        this.registries.put(type, url);
    }

    public String getRegistry(String type) {
        return this.registries.get(type);
    }

    public Map<String, Component> getComponents() {
        return this.components;
    }

    public void setComponents(Map<String, Component> components) {
        this.components = components;
    }

    public Component getComponent(String name) {
        return this.components.get(name);
    }

    public void setComponent(Component comp) {
        this.components.put(comp.getName(), comp);
    }

    public String getIOMServerHost() {
        return this.iomHost;
    }

    public void setIOMServerHost(String iomHost) {
        this.iomHost = iomHost;
    }

    public int getIOMServerPort() {
        return this.iomPort;
    }

    public void setIOMServerPort(int iomPort) {
        this.iomPort = iomPort;
    }

    public void setDefault(boolean b) {
        this.defaultFlag = b;
    }

    public boolean isDefault() {
        return this.defaultFlag;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    private List<Locale> localeLookupList(Locale locale) {
        ArrayList<Locale> list = new ArrayList<Locale>(4);
        if (locale != null) {
            list.add(locale);
            if (locale.getVariant().length() > 0) {
                list.add(new Locale(locale.getLanguage(), locale.getCountry()));
            }
            if (locale.getCountry().length() > 0) {
                list.add(new Locale(locale.getLanguage(), ""));
            }
        }
        return Collections.unmodifiableList(list);
    }
}

