/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.batchsec.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.olapadmin.batchsec.model.GenerateCode;
import com.sas.olapadmin.batchsec.visuals.ModifyBulkPermissionsDialog;
import com.sas.olapadmin.batchsec.visuals.NewPermTableWizard;
import com.sas.olapadmin.batchsec.visuals.PhysicalTablePanelEdit;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.utilities.ComparableObject;
import com.sas.olapadmin.utilities.CubeButtons;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.ExportCodeDialog;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.visuals.Resources;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManagePermissionTables
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(ManagePermissionTables.class);
    public static final String OLAP_ROLE_NAME = "OLAPRole";
    public static final String OLAP_CUBE_PERMISSIONS = "OLAP CUBE PERMISSIONS";
    public static final String PROPERTY_NAME = "PermissionTableObject";
    private JList tableList;
    private MdObjectStore parentStore;
    private CubeButtons buttons;
    private DefaultListModel listModel;

    public ManagePermissionTables() {
        this.setHelpProduct("shared");
        this.setHelpTopic("security_batch_manage");
        this.initializeWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (!saveToModel) {
            this.parentStore = Workspace.getMdFactory().createObjectStore();
            try {
                this.populateList();
                this.setButtonsState();
            }
            catch (ServiceException e) {
                Workspace.handleServiceException((ServiceException)e);
            }
        }
        return true;
    }

    private void populateList() throws MdException, RemoteException, ServiceException {
        String xmlSelect = "<XMLSELECT Search=\"*[Roles/Role[@ObjectRole='OLAP CUBE PERMISSIONS']]\"/>";
        ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
        Filter filter = new Filter();
        filter.setOMRFlags(8576);
        filter.setExplicitSearchString("omi", xmlSelect);
        filter.setType("PhysicalTable");
        List lObjects = server.browseSearch((FilterInterface)filter);
        ArrayList<ComparableObject> comparableObjects = new ArrayList<ComparableObject>();
        for (BrowseMetadataInterface browseObj : lObjects) {
            SimpleBrowseObjectImpl simpleObj = new SimpleBrowseObjectImpl(browseObj);
            ComparableObject thisObj = new ComparableObject((SimpleBrowseObject)simpleObj);
            comparableObjects.add(thisObj);
        }
        Collections.sort(comparableObjects);
        this.listModel.clear();
        int size = comparableObjects.size();
        for (int i = 0; i < size; ++i) {
            this.listModel.addElement(comparableObjects.get(i));
        }
    }

    public boolean validateData() {
        return true;
    }

    private void initializeWidgets() {
        this.setLayout(new GridBagLayout());
        JLabel tableListLabel = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)tableListLabel, (String)bundle.getString("ManagePermissionTables.TableList.control.label"));
        this.listModel = new DefaultListModel();
        this.tableList = new JList(this.listModel);
        tableListLabel.setLabelFor(this.tableList);
        JScrollPane tablePane = new JScrollPane(this.tableList);
        tablePane.setPreferredSize(new Dimension(300, 350));
        this.tableList.setCellRenderer(new TableIconListCellRenderer());
        this.tableList.addListSelectionListener(new TableListSelectionListener());
        this.buttons = new CubeButtons();
        this.buttons.removeDefaultButton();
        this.buttons.removeResetButton();
        this.buttons.getAddButton().addActionListener(new AddButtonListener());
        this.buttons.getModifyButton().addActionListener(new ModifyButtonListener());
        this.buttons.getDeleteButton().addActionListener(new DeleteButtonListener());
        this.buttons.getApplyButton().addActionListener(new ApplyButtonListener());
        this.add(tableListLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 10), 0, 0));
        this.add(tablePane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 10, 10), 0, 0));
        this.add((Component)this.buttons, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setButtonsState() {
        boolean canWriteTable = false;
        int numberOfTables = this.tableList.getSelectedIndices().length;
        JButton modifyButton = this.buttons.getModifyButton();
        JButton deleteButton = this.buttons.getDeleteButton();
        JButton applyButton = this.buttons.getApplyButton();
        if (numberOfTables == 1) {
            canWriteTable = this.canWrite();
        }
        if (numberOfTables > 0) {
            modifyButton.setEnabled(numberOfTables == 1 && canWriteTable);
            applyButton.setEnabled(numberOfTables == 1);
            deleteButton.setEnabled(this.canWrite());
        } else {
            modifyButton.setEnabled(false);
            applyButton.setEnabled(false);
            deleteButton.setEnabled(false);
        }
    }

    public void saveSettingsAndCleanUp() {
        try {
            if (this.parentStore != null && !this.parentStore.isDisposed()) {
                this.parentStore.dispose();
                this.parentStore = null;
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    public boolean canWrite() {
        boolean writeMetadata = false;
        try {
            Object[] items = this.tableList.getSelectedValues();
            int howManySelected = items.length;
            if (howManySelected == 1) {
                SimpleBrowseObject simpleObject = ((ComparableObject)items[0]).getObject();
                PhysicalTable table = (PhysicalTable)ObjectConverter.getInstance().convertToJOMAObject(this.parentStore, (SimpleObject)simpleObject);
                writeMetadata = ModelUtilities.canWrite((String)"PhysicalTable", (CMetadata)table);
                if (writeMetadata) {
                    SASLibrary libraryObject = LibraryUtil.getLibrary((DataTable)table, null);
                    writeMetadata = ModelUtilities.canWrite((String)"SASLibrary", (CMetadata)libraryObject);
                }
            } else if (howManySelected > 1) {
                boolean canIWrite = true;
                int size = howManySelected;
                for (int i = 0; i < size && canIWrite; ++i) {
                    SimpleBrowseObject simpleObject = ((ComparableObject)items[i]).getObject();
                    PhysicalTable table = (PhysicalTable)ObjectConverter.getInstance().convertToJOMAObject(this.parentStore, (SimpleObject)simpleObject);
                    writeMetadata = ModelUtilities.canWrite((String)"PhysicalTable", (CMetadata)table);
                    if (writeMetadata) {
                        SASLibrary libraryObject = LibraryUtil.getLibrary((DataTable)table, null);
                        writeMetadata = ModelUtilities.canWrite((String)"SASLibrary", (CMetadata)libraryObject);
                    }
                    canIWrite = writeMetadata;
                }
            }
        }
        catch (RemoteException e1) {
            Workspace.handleRemoteException((RemoteException)e1);
        }
        catch (MdException e1) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
        }
        return writeMetadata;
    }

    private void handleNoServer(StringBuffer code) {
        String message = bundle.getString("ModifyBulkPermissions.ApplicationServer.down.txt");
        int optionSelected = MessageUtil.displayMessage((String)message, (String)Utilities.getMessageWindowTitle(), (int)1, (int)0);
        if (optionSelected == 0) {
            ExportCodeDialog dialog = new ExportCodeDialog(bundle.getString("Common.ExportCodePanel.instructions.txt"), code, null);
            dialog.show();
        }
    }

    public class TableIconListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setIcon(Resources.getImageIcon((String)"Table_metadata.gif", (int)16));
            return this;
        }
    }

    private final class TableListSelectionListener
    implements ListSelectionListener {
        private TableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ManagePermissionTables.this.setButtonsState();
            }
        }
    }

    private class AddButtonListener
    implements ActionListener {
        private AddButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NewPermTableWizard dlg = new NewPermTableWizard(ManagePermissionTables.this.parentStore);
            dlg.show();
            try {
                ManagePermissionTables.this.populateList();
            }
            catch (RemoteException e1) {
                Workspace.handleRemoteException((RemoteException)e1);
            }
            catch (MdException e1) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
            }
            catch (ServiceException e1) {
                Workspace.handleServiceException((ServiceException)e1);
            }
        }
    }

    public class ModifyButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ComparableObject item = (ComparableObject)ManagePermissionTables.this.tableList.getSelectedValue();
                SimpleBrowseObject simpleObject = item.getObject();
                PhysicalTable table = (PhysicalTable)ObjectConverter.getInstance().convertToJOMAObject(ManagePermissionTables.this.parentStore, (SimpleObject)simpleObject);
                WAStandardDialog parent = (WAStandardDialog)ManagePermissionTables.this.getTopLevelAncestor();
                ModifyBulkPermissionsDialog dlg = new ModifyBulkPermissionsDialog((Dialog)parent, bundle.formatString("ModifyBulkPermissions.ViewData.Title.fmt.txt", (Object)table.getName()), table);
                dlg.setResizable(true);
                dlg.setPreferredSize(new Dimension(700, 700));
                dlg.setCancelButtonVisible(false);
                dlg.show();
                PhysicalTablePanelEdit permission = dlg.getPermissionPanel();
                if (permission != null) {
                    permission.clearAllEdit();
                }
            }
            catch (RemoteException e1) {
                Workspace.handleRemoteException((RemoteException)e1);
            }
            catch (MdException e1) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
            }
        }
    }

    public class DeleteButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Object[] items = ManagePermissionTables.this.tableList.getSelectedValues();
                int howManySelected = items.length;
                int choice = 0;
                if (howManySelected == 1) {
                    SimpleBrowseObject simpleObject = ((ComparableObject)items[0]).getObject();
                    String name = simpleObject.getName();
                    choice = MessageUtil.displayMessage((String)bundle.formatString("ManagePermissionTables.Delete.Message.fmt.txt", (Object)simpleObject.getName()), (String)bundle.getString("ManagePermissionTables.DeleteTable.window.title"), (int)1, (int)0);
                } else {
                    choice = MessageUtil.displayMessage((String)bundle.getString("ManagePermissionTables.DeleteTables.txt"), (String)bundle.getString("ManagePermissionTables.DeleteTables.window.title"), (int)1, (int)0);
                }
                if (choice == 0) {
                    ManagePermissionTables.this.setCursor(Cursor.getPredefinedCursor(3));
                    HashMap<SASLibrary, List<String>> mapOfLibraries = new HashMap<SASLibrary, List<String>>();
                    ArrayList<PhysicalTable> tablesToDelete = new ArrayList<PhysicalTable>();
                    for (int i = 0; i < howManySelected; ++i) {
                        List<String> listOfTables;
                        SimpleBrowseObject simpleObject = ((ComparableObject)items[i]).getObject();
                        PhysicalTable table = (PhysicalTable)ObjectConverter.getInstance().convertToJOMAObject(ManagePermissionTables.this.parentStore, (SimpleObject)simpleObject);
                        String tableName = table.getSASTableName();
                        SASLibrary lib = LibraryUtil.getLibrary((DataTable)table, null);
                        if (!mapOfLibraries.containsKey(lib)) {
                            listOfTables = new ArrayList();
                            mapOfLibraries.put(lib, listOfTables);
                            listOfTables.add(tableName);
                        } else {
                            listOfTables = (List)mapOfLibraries.get(lib);
                            listOfTables.add(tableName);
                        }
                        tablesToDelete.add(table);
                    }
                    int size = tablesToDelete.size();
                    for (int t = 0; t < size; ++t) {
                        boolean found = false;
                        PhysicalTable deleteTable = (PhysicalTable)tablesToDelete.get(t);
                        deleteTable.delete();
                        String id = deleteTable.getId();
                        int listModelSize = ManagePermissionTables.this.listModel.getSize();
                        for (int s = 0; s < listModelSize && !found; ++s) {
                            ComparableObject object = (ComparableObject)ManagePermissionTables.this.listModel.getElementAt(s);
                            String lookingForId = object.getObject().getID();
                            if (!id.equals(lookingForId)) continue;
                            found = true;
                            ManagePermissionTables.this.listModel.removeElementAt(s);
                        }
                    }
                    String str3 = bundle.getString("ManagePermissionTables.DeleteRegistration.window.title");
                    String str4 = bundle.getString("ManagePermissionTables.DeleteRegistrationProgress.txt");
                    UpdateMetadata updateMetadata = new UpdateMetadata(tablesToDelete);
                    OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str3, str4);
                    request.setProgressShownOnStatusBar(false);
                    request.execute((Runnable)updateMetadata);
                    StringBuffer code = GenerateCode.getDeleteTableCode(mapOfLibraries);
                    WsAppServer server = WsRunCode.getServer();
                    if (server == null) {
                        ManagePermissionTables.this.handleNoServer(code);
                    } else {
                        WsRunCode runCode = new WsRunCode(server);
                        if (runCode.hasSubmitError) {
                            ManagePermissionTables.this.handleNoServer(code);
                        } else {
                            runCode.showLogMessagesInDetails(true);
                            String str1 = bundle.getString("ManagePermissionTab.Delete.Table.window.title");
                            String str2 = bundle.getString("ManagePermissionTab.Delete.TableProgress.txt");
                            runCode.executeCode(code, str2, str1);
                        }
                    }
                    ManagePermissionTables.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            catch (RemoteException e1) {
                Workspace.handleRemoteException((RemoteException)e1);
                ManagePermissionTables.this.setCursor(Cursor.getPredefinedCursor(0));
            }
            catch (MdException e1) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
                ManagePermissionTables.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public class ApplyButtonListener
    implements ActionListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int option = MessageUtil.displayMessage((String)bundle.getString("ManagePermissionTables.Apply.Prompt.txt"), (int)1, (int)0);
                if (option == 0) {
                    ManagePermissionTables.this.setCursor(Cursor.getPredefinedCursor(3));
                    ComparableObject item = (ComparableObject)ManagePermissionTables.this.tableList.getSelectedValue();
                    SimpleBrowseObject simpleObject = item.getObject();
                    PhysicalTable table = (PhysicalTable)ObjectConverter.getInstance().convertToJOMAObject(ManagePermissionTables.this.parentStore, (SimpleObject)simpleObject);
                    String tableName = table.getSASTableName();
                    SASLibrary lib = LibraryUtil.getLibrary((DataTable)table, null);
                    WsAppServer server = WsRunCode.getServer();
                    if (server == null) {
                        StringBuffer code = GenerateCode.getImportCode((SASLibrary)lib, (String)tableName, this.getClass(), (boolean)false);
                        ManagePermissionTables.this.handleNoServer(code);
                    } else {
                        StringBuffer code = GenerateCode.getImportCode((SASLibrary)lib, (String)tableName, this.getClass(), (boolean)true);
                        WsRunCode runCode = new WsRunCode(server);
                        if (runCode.hasSubmitError) {
                            ManagePermissionTables.this.handleNoServer(code);
                        } else {
                            String str1 = bundle.getString("NewPermTableWizard.RegisterProgress.window.title");
                            String str2 = bundle.getString("NewPermTableWizard.RegisterProgress.txt");
                            runCode.showLogMessagesInDetails(true);
                            boolean submitError = runCode.executeCode(code, str2, str1);
                            String processingProblems = server.getMacroVariableValue("ErrorProcessing");
                            if (!submitError && processingProblems == null) {
                                Utilities.displayNonCriticalMessage((String)bundle.getString("ModifyBulkPermissions.Apply.ProcessingErrors.txt"));
                            } else if (!submitError && processingProblems != null) {
                                if (processingProblems.equals("0")) {
                                    Utilities.displayNonCriticalMessage((String)bundle.getString("ManagePermissionTab.Apply.RanSuccessful.txt"));
                                } else if (processingProblems.equals("1")) {
                                    Utilities.displayNonCriticalMessage((String)bundle.getString("ModifyBulkPermissions.Apply.ProcessingErrors.txt"));
                                }
                            }
                        }
                    }
                }
            }
            catch (SQLException sql) {
                ExceptionHandler.handleException((Exception)sql);
            }
            catch (WsAppServerFailException app) {
                ExceptionHandler.handleException((Exception)((Object)app));
            }
            catch (RemoteException remoteError) {
                Workspace.handleRemoteException((RemoteException)remoteError);
            }
            catch (MdException mdError) {
                MessageUtil.displayMetadataExceptionMessage((MdException)mdError, (String)"Accessing");
            }
            finally {
                ManagePermissionTables.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    class UpdateMetadata
    implements Runnable {
        private List tables;
        private boolean status;

        public UpdateMetadata(List listOfTables) {
            this.tables = listOfTables;
        }

        @Override
        public void run() {
            try {
                int size = this.tables.size();
                for (int i = 0; i < size; ++i) {
                    PhysicalTable table = (PhysicalTable)this.tables.get(i);
                    table.updateMetadataAll();
                    this.status = true;
                }
            }
            catch (RemoteException e) {
                this.status = false;
            }
            catch (MdException e) {
                this.status = false;
            }
        }

        public boolean getStatus() {
            return this.status;
        }
    }
}

