/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.types;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIDescriptor;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

@XmlRootElement(name="contentObjectType")
public class ObjectTypeUIDescriptorData {
    public static final String MEDIA_TYPE = "application/vnd.sas.content.object.type";
    public static final String MEDIA_TYPE_XML = "application/vnd.sas.content.object.type+xml";
    public static final String MEDIA_TYPE_JSON = "application/vnd.sas.content.object.type+json";
    private static final Locale DEFAULT_LOCALE = Locale.US;
    @XmlAttribute
    public String id;
    @XmlAttribute
    public String name;
    @XmlAttribute
    public String label;
    @XmlAttribute
    public int version = 1;
    private List<Link> links;

    public ObjectTypeUIDescriptorData(ObjectType objectType, ObjectTypeUIDescriptor ui, Locale locale, List<Link> links) {
        this.id = Long.toString(ui.getId());
        this.name = objectType.getName();
        this.links = links;
        Properties props = ui.getLocalizedNames();
        if (props == null) {
            this.label = this.name;
        } else {
            Locale tmpLocale = locale;
            if (tmpLocale == null) {
                tmpLocale = DEFAULT_LOCALE;
            }
            this.label = props.containsKey(tmpLocale.toString()) ? props.getProperty(tmpLocale.toString()) : props.getProperty(DEFAULT_LOCALE.toString());
            if (this.label == null) {
                this.label = this.name;
            }
        }
    }

    public ObjectTypeUIDescriptorData(ObjectType objectType, ObjectTypeUIDescriptor ui, List<Link> links) {
        this(objectType, ui, null, links);
    }

    public ObjectTypeUIDescriptorData() {
    }

    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this.links;
    }
}

