/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.storedprocess;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.storedprocess.client.DataItem;
import com.sas.svcs.content.storedprocess.client.DataTable;
import com.sas.svcs.content.storedprocess.client.GenericStream;
import com.sas.svcs.content.storedprocess.client.OutputParameter;
import com.sas.svcs.content.storedprocess.client.StoredProcess;
import com.sas.svcs.content.storedprocess.client.XMLStream;
import com.sas.svcs.content.storedprocesscommon.client.SimpleReferenceList;
import com.sas.svcs.resource.platform.resourcebase.client.Directory;
import com.sas.svcs.resource.platform.serverdata.client.LogicalServer;
import com.sas.svcs.resource.platform.serverdata.client.ServerContext;
import com.sas.svcs.web.data.content.ContentNodeData;
import com.sas.svcs.web.data.storedprocess.DataItemData;
import com.sas.svcs.web.data.storedprocess.OutputParameterData;
import com.sas.svcs.web.data.storedprocess.Util;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name="storedProcess")
public class StoredProcessData
extends ContentNodeData {
    private StoredProcess _storedProcess;
    private List<Link> _links;

    public StoredProcessData() {
        this(new StoredProcess(), false);
    }

    public StoredProcessData(StoredProcess storedProcess, boolean createLinks) {
        super((ContentNode)storedProcess);
        this._storedProcess = storedProcess;
        if (createLinks) {
            Link lsLink;
            Directory directory;
            ArrayList<Link> linkList = new ArrayList<Link>();
            if (storedProcess.getSourceCodeLocation() == StoredProcess.SourceCodeLocation.FILE_SYSTEM && (directory = (Directory)storedProcess.getSourceCodeRepository().getTarget()) != null) {
                Link scrLink = new Link("GET", "sourceCodeRepository", Util.getUriForContentComponent((ContentComponent)directory));
                linkList.add(scrLink);
            }
            if (storedProcess.getVersion() == StoredProcess.Version.V1) {
                LogicalServer logicalServer = (LogicalServer)storedProcess.getLogicalServer().getTarget();
                if (logicalServer != null) {
                    lsLink = new Link("GET", "logicalServer", Util.getUriForContentComponent((ContentComponent)logicalServer));
                    linkList.add(lsLink);
                }
            } else {
                ServerContext serverContext = (ServerContext)storedProcess.getServerContext().getTarget();
                if (serverContext != null) {
                    lsLink = new Link("GET", "serverContext", Util.getUriForContentComponent((ContentComponent)serverContext));
                    linkList.add(lsLink);
                }
            }
            this.setLinks(linkList);
        }
    }

    public StoredProcessVersion getVersion() {
        StoredProcessVersion retVersion = null;
        StoredProcess.Version spVersion = this._storedProcess.getVersion();
        if (spVersion != null) {
            switch (spVersion) {
                case V1: {
                    retVersion = StoredProcessVersion.V1;
                    break;
                }
                case V2: {
                    retVersion = StoredProcessVersion.V2;
                }
            }
        }
        return retVersion;
    }

    public void setVersion(StoredProcessVersion version) {
        StoredProcess.Version spVersion = null;
        switch (version.ordinal()) {
            case 0: {
                spVersion = StoredProcess.Version.V1;
                break;
            }
            case 1: {
                spVersion = StoredProcess.Version.V2;
            }
        }
        this._storedProcess.setVersion(spVersion);
    }

    public boolean isHiddenFromUser() {
        return this._storedProcess.isHiddenFromUser();
    }

    public void setHideFromUser(boolean hideFromUser) {
        this._storedProcess.setHiddenFromUser(hideFromUser);
    }

    public boolean isPackageCapable() {
        return this._storedProcess.isPackageCapable();
    }

    public void setPackageCapable(boolean isPackageCapable) {
        this._storedProcess.setPackageCapable(isPackageCapable);
    }

    public boolean isStreamingCapable() {
        return this._storedProcess.isStreamingCapable();
    }

    public void setStreamingCapable(boolean isStreamingCapable) {
        this._storedProcess.setStreamingCapable(isStreamingCapable);
    }

    public StoredProcess.LogicalServerType getLogicalServerType() {
        return this._storedProcess.getLogicalServerType();
    }

    public void setLogicalServerType(StoredProcess.LogicalServerType logicalServerType) {
        this._storedProcess.setLogicalServerType(logicalServerType);
    }

    public StoredProcess.SourceCodeLocation getSourceCodeLocation() {
        return this._storedProcess.getSourceCodeLocation();
    }

    public void setSourceCodeLocation(StoredProcess.SourceCodeLocation sourceCodeLocation) {
        this._storedProcess.setSourceCodeLocation(sourceCodeLocation);
    }

    public String getSourceFileName() {
        return (String)((Object)this._storedProcess.getSourceFileName().getTarget());
    }

    public void setSourceFileName(String fileName) {
        this._storedProcess.getSourceFileName().setTarget((Serializable)((Object)fileName));
    }

    @XmlElementWrapper(name="outputParameters")
    @XmlElement(name="outputParameter")
    public List<OutputParameterData> getOutputParameters() {
        ArrayList<OutputParameterData> opdList = new ArrayList<OutputParameterData>();
        SimpleReferenceList opRefList = this._storedProcess.getOutputParameters();
        ArrayList opList = (ArrayList)opRefList.getTargetCollection();
        if (opList != null) {
            for (OutputParameter op : opList) {
                OutputParameterData opd = new OutputParameterData(op);
                opdList.add(opd);
            }
        }
        return opdList;
    }

    public void setOutputParameters(List<OutputParameterData> outputParameters) {
        SimpleReferenceList opRefList = this._storedProcess.getOutputParameters();
        ArrayList<OutputParameter> opList = new ArrayList<OutputParameter>();
        if (outputParameters != null) {
            for (OutputParameterData opd : outputParameters) {
                OutputParameter.Type targetType;
                OutputParameter op = new OutputParameter();
                op.setName(opd.getName());
                op.setLabel(opd.getLabel());
                op.setDescription(opd.getDescription());
                switch (opd.getType()) {
                    case DATE: {
                        targetType = OutputParameter.Type.DATE;
                        break;
                    }
                    case DOUBLE: {
                        targetType = OutputParameter.Type.DOUBLE;
                        break;
                    }
                    case INTEGER: {
                        targetType = OutputParameter.Type.INTEGER;
                        break;
                    }
                    case STRING: {
                        targetType = OutputParameter.Type.STRING;
                        break;
                    }
                    case TIME: {
                        targetType = OutputParameter.Type.TIME;
                        break;
                    }
                    case TIMESTAMP: {
                        targetType = OutputParameter.Type.TIMESTAMP;
                        break;
                    }
                    default: {
                        targetType = null;
                    }
                }
                op.setType(targetType);
                opList.add(op);
            }
        }
        opRefList.setTargetCollection(opList);
    }

    @XmlElementWrapper(name="dataItems")
    @XmlElement(name="dataItem")
    public List<DataItemData> getDataItems() {
        ArrayList<DataItemData> didList = new ArrayList<DataItemData>();
        SimpleReferenceList diRefList = this._storedProcess.getDataItems();
        ArrayList diList = (ArrayList)diRefList.getTargetCollection();
        if (diList != null) {
            for (DataItem di : diList) {
                DataItemData did = new DataItemData(di);
                didList.add(did);
            }
        }
        return didList;
    }

    public void setDataItems(List<DataItemData> dataItems) {
        SimpleReferenceList diRefList = this._storedProcess.getDataItems();
        ArrayList<DataTable> diList = new ArrayList<DataTable>();
        for (DataItemData did : dataItems) {
            DataTable di;
            switch (did.getType()) {
                case DataTable: {
                    di = new DataTable();
                    break;
                }
                case GenericStream: {
                    di = new GenericStream();
                    break;
                }
                case XMLStream: {
                    di = new XMLStream();
                    break;
                }
                default: {
                    di = null;
                }
            }
            if (di == null) continue;
            di.setSource(did.isSource());
            di.setLabel(did.getLabel());
            di.setDescription(did.getDescription());
            if (di instanceof DataTable) {
                di.setParameterName(did.getParameterName());
            } else {
                if (di instanceof XMLStream) {
                    ((XMLStream)di).setReferenceName(did.getReferenceName());
                    ((XMLStream)di).setReferenceNameSpace(did.getReferenceNameSpace());
                    ((XMLStream)di).setReferenceTypeForSchemaElement(did.isReferenceTypeForSchemaElement());
                    ((XMLStream)di).setSchemaAvailable(did.isSchemaAvailable());
                    ((XMLStream)di).setSchemaEmbeddedInWSDL(did.isSchemaEmbeddedInWSDL());
                    ((XMLStream)di).setSchemaURI(did.getSchemaURI());
                }
                ((GenericStream)di).setRewindingAllowed(did.isRewindingAllowed());
                ((GenericStream)di).setExpectedContentType(did.getExpectedContentType());
                ((GenericStream)di).setFileref(did.getFileref());
            }
            diList.add(di);
        }
        diRefList.setTargetCollection(diList);
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> links) {
        this._links = links;
    }

    public static enum StoredProcessVersion {
        V1,
        V2;

    }
}

