/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.storedprocess;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.platform.di.client.Table;
import com.sas.svcs.content.storedprocess.client.DataItem;
import com.sas.svcs.content.storedprocess.client.DataTable;
import com.sas.svcs.content.storedprocess.client.GenericStream;
import com.sas.svcs.content.storedprocess.client.XMLStream;
import com.sas.svcs.web.data.storedprocess.Util;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import java.util.ArrayList;
import java.util.List;

public class DataItemData {
    private DIDType _type;
    private boolean _isSource;
    private String _label;
    private String _description;
    private String _fileref;
    private boolean _rewindingAllowed;
    private String _expectedContentType;
    private boolean _schemaAvailable;
    private String _schemaURI;
    private String _referenceNameSpace;
    private String _referenceName;
    private boolean _referenceTypeForSchemaElement;
    private boolean _schemaEmbeddedInWSDL;
    private String _parameterName;
    private List<Link> _links;

    public DataItemData() {
    }

    public DataItemData(DataItem di) {
        this._isSource = di.isSource();
        this._label = di.getLabel();
        this._description = di.getDescription();
        if (di instanceof GenericStream) {
            this._fileref = ((GenericStream)di).getFileref();
            this._rewindingAllowed = ((GenericStream)di).isRewindingAllowed();
            this._expectedContentType = ((GenericStream)di).getExpectedContentType();
            if (di instanceof XMLStream) {
                this._schemaAvailable = ((XMLStream)di).isSchemaAvailable();
                this._schemaURI = ((XMLStream)di).getSchemaURI();
                this._referenceNameSpace = ((XMLStream)di).getReferenceNameSpace();
                this._referenceName = ((XMLStream)di).getReferenceName();
                this._referenceTypeForSchemaElement = ((XMLStream)di).isReferenceTypeForSchemaElement();
                this._schemaEmbeddedInWSDL = ((XMLStream)di).isSchemaEmbeddedInWSDL();
                this._type = DIDType.XMLStream;
            } else {
                this._type = DIDType.GenericStream;
            }
        } else if (di instanceof DataTable) {
            this._parameterName = ((DataTable)di).getParameterName();
            Table table = ((DataTable)di).getTemplateTable();
            if (table != null) {
                ArrayList<Link> linkList = new ArrayList<Link>(1);
                Link templateTableLink = new Link("GET", "table", Util.getUriForContentComponent((ContentComponent)table));
                linkList.add(templateTableLink);
                this.setLinks(linkList);
            }
            this._type = DIDType.DataTable;
        }
    }

    public DIDType getType() {
        return this._type;
    }

    public void setType(DIDType type) {
        this._type = type;
    }

    public boolean isSource() {
        return this._isSource;
    }

    public void setSource(boolean isSource) {
        this._isSource = isSource;
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getFileref() {
        return this._fileref;
    }

    public void setFileref(String fileref) {
        this._fileref = fileref;
    }

    public boolean isRewindingAllowed() {
        return this._rewindingAllowed;
    }

    public void setRewindingAllowed(boolean rewindingAllowed) {
        this._rewindingAllowed = rewindingAllowed;
    }

    public String getExpectedContentType() {
        return this._expectedContentType;
    }

    public void setExpectedContentType(String expectedContentType) {
        this._expectedContentType = expectedContentType;
    }

    public boolean isSchemaAvailable() {
        return this._schemaAvailable;
    }

    public void setSchemaAvailable(boolean schemaIsAvailable) {
        this._schemaAvailable = schemaIsAvailable;
    }

    public String getSchemaURI() {
        return this._schemaURI;
    }

    public void setSchemaURI(String schemaURI) {
        this._schemaURI = schemaURI;
    }

    public String getReferenceNameSpace() {
        return this._referenceNameSpace;
    }

    public void setReferenceNameSpace(String referenceNameSpace) {
        this._referenceNameSpace = referenceNameSpace;
    }

    public String getReferenceName() {
        return this._referenceName;
    }

    public void setReferenceName(String referenceName) {
        this._referenceName = referenceName;
    }

    public boolean isReferenceTypeForSchemaElement() {
        return this._referenceTypeForSchemaElement;
    }

    public void setReferenceTypeForSchemaElement(boolean referenceTypeIsForSchemaElement) {
        this._referenceTypeForSchemaElement = referenceTypeIsForSchemaElement;
    }

    public boolean isSchemaEmbeddedInWSDL() {
        return this._schemaEmbeddedInWSDL;
    }

    public void setSchemaEmbeddedInWSDL(boolean schemaIsToBeEmbeddedInWSDL) {
        this._schemaEmbeddedInWSDL = schemaIsToBeEmbeddedInWSDL;
    }

    public String getParameterName() {
        return this._parameterName;
    }

    public void setParameterName(String parameterName) {
        this._parameterName = parameterName;
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> links) {
        this._links = links;
    }

    public static enum DIDType {
        GenericStream,
        XMLStream,
        DataTable;

    }
}

