/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.servers;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.common.client.ChildReferenceList;
import com.sas.svcs.common.client.ReferenceList;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.resource.platform.machine.client.Machine;
import com.sas.svcs.resource.platform.serverdata.client.LogicalServer;
import com.sas.svcs.resource.platform.serverdata.client.ServerBase;
import com.sas.svcs.resource.platform.serverdata.client.ServerComponent;
import com.sas.svcs.resource.platform.software.client.Connection;
import com.sas.svcs.resource.platform.software.client.SoftwareResourceBase;
import com.sas.svcs.web.data.servers.ConnectionData;
import com.sas.svcs.web.data.servers.Connections;
import com.sas.svcs.web.data.servers.MachineData;
import com.sas.svcs.web.data.servers.Machines;
import com.sas.svcs.web.data.servers.ServerBaseData;
import com.sas.svcs.web.data.servers.ServerDataUtil;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name="serverComponent")
public class ServerComponentData
extends ServerBaseData {
    ServerComponent serverComponent;

    public ServerComponentData() {
        this(new ServerComponent());
    }

    public ServerComponentData(ServerComponent serverComponent) {
        super((ServerBase)serverComponent);
        this.serverComponent = serverComponent;
    }

    public ServerComponentData(ServerComponent serverComponent, boolean doFull) {
        super((ServerBase)serverComponent, doFull);
        this.serverComponent = serverComponent;
    }

    @XmlElement
    public Connections getConnections() {
        Connections result = null;
        ChildReferenceList connectionRef = this.serverComponent.getConnections();
        if (connectionRef != null && connectionRef.getTargetList() != null && ((ArrayList)connectionRef.getTargetList()).size() > 0) {
            ArrayList<ConnectionData> cdList = new ArrayList<ConnectionData>();
            for (Connection connection : (ArrayList)connectionRef.getTargetList()) {
                cdList.add(ServerDataUtil.getConnectionData(connection));
            }
            result = new Connections(cdList);
        }
        return result;
    }

    @XmlElement
    public Machines getMachines() {
        if (!this.doFull) {
            return null;
        }
        Machines result = null;
        ReferenceList machineRef = this.serverComponent.getMachines();
        if (machineRef != null && machineRef.getTargetList() != null) {
            ArrayList<MachineData> machineDataList = new ArrayList<MachineData>();
            ArrayList machineList = (ArrayList)machineRef.getTargetList();
            for (Machine machine : machineList) {
                machineDataList.add(new MachineData(machine));
            }
            result = new Machines(machineDataList);
        }
        return result;
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    public List<Link> getLinks() {
        ReferenceList machineRef;
        List<Link> result = this.getLinkList();
        if (!this.doFull && (machineRef = this.serverComponent.getMachines()) != null && machineRef.getTargetList() != null && ((ArrayList)machineRef.getTargetList()).size() > 0) {
            for (Machine nextMachine : (ArrayList)machineRef.getTargetList()) {
                result.add(new Link("GET", "host", "/content/50/" + ContentRESTUtils.getIdForLink((String)nextMachine.getId())));
            }
        }
        if (this.serverComponent != null) {
            LogicalServer logicalServer = null;
            ReferenceList usedRef = this.serverComponent.getUsedByServers();
            if (usedRef != null && usedRef.getTargetList() != null) {
                for (SoftwareResourceBase nextResource : (ArrayList)usedRef.getTargetList()) {
                    if (!(nextResource instanceof LogicalServer)) continue;
                    logicalServer = (LogicalServer)nextResource;
                    break;
                }
            }
            if (logicalServer != null) {
                Link lsLink = new Link("GET", "logicalServer", "/content/94/" + ContentRESTUtils.getIdForLink((String)logicalServer.getId()));
                result.add(lsLink);
            }
        }
        return result;
    }

    public ServerComponent toServerComponent() {
        return this.serverComponent;
    }
}

