/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.servers;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.common.client.ReferenceList;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.resource.platform.serverdata.client.InitProcess;
import com.sas.svcs.resource.platform.serverdata.client.ServerBase;
import com.sas.svcs.resource.platform.software.client.SoftwareResourceBase;
import com.sas.svcs.web.data.content.ContentObjectAttrData;
import com.sas.svcs.web.data.content.ContentObjectData;
import com.sas.svcs.web.data.content.ContentObjects;
import com.sas.svcs.web.data.servers.InitProcessData;
import com.sas.svcs.web.data.servers.InitProcesses;
import com.sas.svcs.web.data.servers.ServerDataUtil;
import com.sas.svcs.web.data.servers.SoftwareResourceBaseData;
import com.sas.svcs.web.data.servers.SoftwareResourceBases;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import java.util.ArrayList;
import java.util.List;

public class ServerBaseData
extends SoftwareResourceBaseData {
    protected String SERVERBASE_DATA_VERSION = "1";
    boolean doFull = false;
    ServerBase base;

    public ServerBaseData() {
        this(new ServerBase());
    }

    public ServerBaseData(ServerBase base) {
        super((SoftwareResourceBase)base);
        this.base = base;
    }

    public ServerBaseData(ServerBase base, boolean doFull) {
        this(base);
        this.doFull = doFull;
    }

    @XmlElementWrapper(name="dataPackages")
    @XmlElement(name="contentObject")
    public List<ContentObjectAttrData> getDataPackages() {
        if (!this.doFull) {
            return null;
        }
        ArrayList<ContentObjectAttrData> dpDataList = null;
        ReferenceList dpRef = this.base.getDataPackages();
        if (dpRef != null && dpRef.getTargetList() != null) {
            dpDataList = new ArrayList<ContentObjectAttrData>();
            ArrayList dpList = (ArrayList)dpRef.getTargetList();
            for (ContentComponent cod : dpList) {
                dpDataList.add(new ContentObjectAttrData(cod));
            }
        }
        return dpDataList;
    }

    public void setDataPackages(ContentObjects objects) {
        if (objects != null && objects.getContentObjects() != null) {
            ArrayList<ContentComponent> contentObjectList = new ArrayList<ContentComponent>();
            for (ContentObjectData cod : objects.getContentObjects()) {
                contentObjectList.add(cod.toContentComponent());
            }
            this.base.setDataPackages(new ReferenceList(contentObjectList));
        }
    }

    public final SoftwareResourceBases getDependentComponents() {
        if (!this.doFull) {
            return null;
        }
        SoftwareResourceBases result = null;
        ReferenceList dependRef = this.base.getDependentComponents();
        if (dependRef != null && dependRef.getTargetList() != null) {
            ArrayList<SoftwareResourceBaseData> dependDataList = new ArrayList<SoftwareResourceBaseData>();
            ArrayList dependList = (ArrayList)dependRef.getTargetList();
            for (SoftwareResourceBase base : dependList) {
                dependDataList.add(ServerDataUtil.getDataForServer(base));
            }
            result = new SoftwareResourceBases(dependDataList);
        }
        return result;
    }

    public final void setDependentComponents(SoftwareResourceBases bases) {
        if (bases != null && bases.getSoftwareResourceBases() != null) {
            ArrayList<SoftwareResourceBase> rbList = new ArrayList<SoftwareResourceBase>();
            for (SoftwareResourceBaseData base : bases.getSoftwareResourceBases()) {
                rbList.add(base.toSoftwareResourceBase());
            }
            this.base.setDependentComponents(new ReferenceList(rbList));
        }
    }

    public final SoftwareResourceBases getDependsOnComponents() {
        if (!this.doFull) {
            return null;
        }
        SoftwareResourceBases result = null;
        ReferenceList dependRef = this.base.getDependsOnComponents();
        if (dependRef != null && dependRef.getTargetList() != null) {
            ArrayList<SoftwareResourceBaseData> dependDataList = new ArrayList<SoftwareResourceBaseData>();
            ArrayList dependList = (ArrayList)dependRef.getTargetList();
            for (SoftwareResourceBase base : dependList) {
                dependDataList.add(ServerDataUtil.getDataForServer(base));
            }
            result = new SoftwareResourceBases(dependDataList);
        }
        return result;
    }

    public final void setDependsOnComponents(SoftwareResourceBases bases) {
        if (bases != null && bases.getSoftwareResourceBases() != null) {
            ArrayList<SoftwareResourceBase> rbList = new ArrayList<SoftwareResourceBase>();
            for (SoftwareResourceBaseData base : bases.getSoftwareResourceBases()) {
                rbList.add(base.toSoftwareResourceBase());
            }
            this.base.setDependsOnComponents(new ReferenceList(rbList));
        }
    }

    public final InitProcesses getInitProcesses() {
        InitProcesses result = null;
        List ipList = this.base.getInitProcesses();
        if (ipList != null && ipList.size() > 0) {
            ArrayList<InitProcessData> ipDataList = new ArrayList<InitProcessData>();
            for (InitProcess ip : ipList) {
                ipDataList.add(new InitProcessData(ip));
            }
            result = new InitProcesses(ipDataList);
        }
        return result;
    }

    public final void setInitProcesses(InitProcesses initProcesses) {
        if (initProcesses != null && initProcesses.getInitProcesses() != null) {
            ArrayList<InitProcess> initProcessList = new ArrayList<InitProcess>();
            for (InitProcessData ipd : initProcesses.getInitProcesses()) {
                initProcessList.add(ipd.toInitProcess());
            }
            this.base.setInitProcesses(initProcessList);
        }
    }

    public SoftwareResourceBases getUsedByServers() {
        if (!this.doFull) {
            return null;
        }
        SoftwareResourceBases result = null;
        ReferenceList dependRef = this.base.getUsedByServers();
        if (dependRef != null && dependRef.getTargetList() != null) {
            ArrayList<SoftwareResourceBaseData> dependDataList = new ArrayList<SoftwareResourceBaseData>();
            ArrayList dependList = (ArrayList)dependRef.getTargetList();
            for (SoftwareResourceBase base : dependList) {
                dependDataList.add(ServerDataUtil.getDataForServer(base));
            }
            result = new SoftwareResourceBases(dependDataList);
        }
        return result;
    }

    public void setUsedByServers(SoftwareResourceBases usedByServers) {
        if (usedByServers != null && usedByServers.getSoftwareResourceBases() != null) {
            ArrayList<SoftwareResourceBase> rbList = new ArrayList<SoftwareResourceBase>();
            for (SoftwareResourceBaseData base : usedByServers.getSoftwareResourceBases()) {
                rbList.add(base.toSoftwareResourceBase());
            }
            this.base.setUsedByServers(new ReferenceList(rbList));
        }
    }

    public SoftwareResourceBases getUsingServers() {
        if (!this.doFull) {
            return null;
        }
        SoftwareResourceBases result = null;
        ReferenceList dependRef = this.base.getUsingServers();
        if (dependRef != null && dependRef.getTargetList() != null) {
            ArrayList<SoftwareResourceBaseData> dependDataList = new ArrayList<SoftwareResourceBaseData>();
            ArrayList dependList = (ArrayList)dependRef.getTargetList();
            for (SoftwareResourceBase base : dependList) {
                dependDataList.add(ServerDataUtil.getDataForServer(base));
            }
            result = new SoftwareResourceBases(dependDataList);
        }
        return result;
    }

    public void setUsingServers(SoftwareResourceBases usingServers) {
        if (usingServers != null && usingServers.getSoftwareResourceBases() != null) {
            ArrayList<SoftwareResourceBase> rbList = new ArrayList<SoftwareResourceBase>();
            for (SoftwareResourceBaseData base : usingServers.getSoftwareResourceBases()) {
                rbList.add(base.toSoftwareResourceBase());
            }
            this.base.setUsingServers(new ReferenceList(rbList));
        }
    }

    @XmlElementWrapper(name="serviceTypes")
    @XmlElement(name="serviceType")
    public List<String> getServiceTypes() {
        return this.base.getServiceTypes();
    }

    public void setServiceTypes(List<String> serviceTypes) {
        this.base.setServiceTypes(serviceTypes);
    }

    @XmlAttribute
    public String getVersion() {
        return this.SERVERBASE_DATA_VERSION;
    }

    protected List<Link> getLinkList() {
        ArrayList<Link> linkList = new ArrayList<Link>();
        linkList.add(new Link("GET", "self", "/content/" + ServerDataUtil.getGenericServerType((SoftwareResourceBase)this.base) + "/" + ContentRESTUtils.getIdForLink((String)this.base.getId())));
        if (!this.doFull) {
            ReferenceList usedByRef;
            ReferenceList usingRef;
            ReferenceList dependsOnRef;
            ReferenceList dependentRef = this.base.getDependentComponents();
            if (dependentRef != null && dependentRef.getTargetList() != null && ((ArrayList)dependentRef.getTargetList()).size() > 0) {
                for (SoftwareResourceBase nextResource : (ArrayList)dependentRef.getTargetList()) {
                    String type = ServerDataUtil.getGenericServerType(nextResource);
                    linkList.add(new Link("GET", "dependentComponent", "/content/" + type + "/" + ContentRESTUtils.getIdForLink((String)nextResource.getId())));
                }
            }
            if ((dependsOnRef = this.base.getDependsOnComponents()) != null && dependsOnRef.getTargetList() != null && ((ArrayList)dependsOnRef.getTargetList()).size() > 0) {
                for (SoftwareResourceBase nextResource : (ArrayList)dependsOnRef.getTargetList()) {
                    String type = ServerDataUtil.getGenericServerType(nextResource);
                    linkList.add(new Link("GET", "dependsOnComponent", "/content/" + type + "/" + ContentRESTUtils.getIdForLink((String)nextResource.getId())));
                }
            }
            if ((usingRef = this.base.getUsingServers()) != null && usingRef.getTargetList() != null && ((ArrayList)usingRef.getTargetList()).size() > 0) {
                for (SoftwareResourceBase nextResource : (ArrayList)usingRef.getTargetList()) {
                    String type = ServerDataUtil.getGenericServerType(nextResource);
                    linkList.add(new Link("GET", "usingComponent", "/content/" + type + "/" + ContentRESTUtils.getIdForLink((String)nextResource.getId())));
                }
            }
            if ((usedByRef = this.base.getUsedByServers()) != null && usedByRef.getTargetList() != null && ((ArrayList)usedByRef.getTargetList()).size() > 0) {
                for (SoftwareResourceBase nextResource : (ArrayList)usedByRef.getTargetList()) {
                    String type = ServerDataUtil.getGenericServerType(nextResource);
                    linkList.add(new Link("GET", "usedByComponent", "/content/" + type + "/" + ContentRESTUtils.getIdForLink((String)nextResource.getId())));
                }
            }
        }
        return linkList;
    }
}

