/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.identity;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.resource.platform.identity.client.Identity;
import com.sas.svcs.resource.platform.identity.client.UserGroup;
import com.sas.svcs.resource.platform.resourcebase.client.Login;
import com.sas.svcs.web.data.identity.IdentityData;
import com.sas.svcs.web.data.identity.LoginData;
import com.sas.svcs.web.data.identity.Logins;
import com.sas.svcs.web.data.identity.Members;
import com.sas.svcs.web.data.identity.Memberships;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@XmlRootElement(name="usergroup")
public class UserGroupData
extends IdentityData {
    public UserGroupData() {
        this(new UserGroup());
    }

    public UserGroupData(UserGroup userGroup) {
        super((Identity)userGroup);
    }

    @XmlElement
    public Logins getLogins() {
        Logins result = null;
        List loginList = this.toUserGroup().getLogins();
        if (loginList != null) {
            ArrayList<LoginData> loginDataList = new ArrayList<LoginData>();
            for (Login login : loginList) {
                loginDataList.add(new LoginData(login));
            }
            result = new Logins(loginDataList);
        }
        return result;
    }

    public void setLogins(Logins logins) {
        Collection<LoginData> loginDataList = logins.getLogins();
        if (logins == null || loginDataList == null) {
            return;
        }
        ArrayList<Login> loginList = new ArrayList<Login>(loginDataList.size());
        for (LoginData loginData : loginDataList) {
            loginList.add(loginData.toLogin());
        }
        this.toUserGroup().setLogins(loginList);
    }

    @XmlElement
    public Members getMembers() {
        Members result = null;
        List memberList = this.toUserGroup().getMembers();
        if (memberList != null) {
            ArrayList<IdentityData> identityDataList = new ArrayList<IdentityData>();
            for (Identity identity : memberList) {
                identityDataList.add(new IdentityData(identity));
            }
            result = new Members(identityDataList);
        }
        return result;
    }

    public void setMembers(Members members) {
        Collection<IdentityData> identityDataList = members.getMembers();
        if (members == null || identityDataList == null) {
            return;
        }
        ArrayList<Identity> identityList = new ArrayList<Identity>(identityDataList.size());
        for (IdentityData identityData : identityDataList) {
            identityList.add(identityData.toIdentity());
        }
        this.toUserGroup().setMembers(identityList);
    }

    @XmlElement
    public Memberships getMemberships() {
        Memberships result = null;
        List memberShipList = this.toUserGroup().getMemberships();
        if (memberShipList != null) {
            ArrayList<IdentityData> identityDataList = new ArrayList<IdentityData>();
            for (Identity identity : memberShipList) {
                identityDataList.add(new IdentityData(identity));
            }
            result = new Memberships(identityDataList);
        }
        return result;
    }

    public void setMemberships(Memberships memberships) {
        Collection<IdentityData> identityDataList = memberships.getMemberships();
        if (memberships == null || identityDataList == null) {
            return;
        }
        ArrayList<Identity> identityList = new ArrayList<Identity>(identityDataList.size());
        for (IdentityData identityData : identityDataList) {
            identityList.add(identityData.toIdentity());
        }
        this.toUserGroup().setMemberships(identityList);
    }

    @XmlElement(name="link")
    public List<Link> getLinks() {
        ArrayList<Link> result = null;
        if (this.toUserGroup() != null) {
            Link lsLink = null;
            if (this.toUserGroup().getLogins() == null) {
                if (result == null) {
                    result = new ArrayList<Link>();
                }
                lsLink = new Link("GET", "logins", "/identity/152/" + ContentRESTUtils.getIdForLink((String)this.toUserGroup().getId()) + "/logins");
                result.add(lsLink);
            }
            if (this.toUserGroup().getMemberships() == null) {
                if (result == null) {
                    result = new ArrayList();
                }
                lsLink = new Link("GET", "memberships", "/identity/152/" + ContentRESTUtils.getIdForLink((String)this.toUserGroup().getId()) + "/memberships");
                result.add(lsLink);
            }
            if (this.toUserGroup().getMembers() == null) {
                if (result == null) {
                    result = new ArrayList();
                }
                lsLink = new Link("GET", "members", "/identity/152/" + ContentRESTUtils.getIdForLink((String)this.toUserGroup().getId()) + "/members");
                result.add(lsLink);
            }
        }
        return result;
    }

    public UserGroup toUserGroup() {
        return (UserGroup)this.toContentComponent();
    }
}

