/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.directory;

import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import com.sas.svcs.common.client.Reference;
import com.sas.svcs.common.client.ReferenceList;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.resource.platform.resourcebase.client.Directory;
import com.sas.svcs.resource.platform.serverdata.client.LogicalServer;
import com.sas.svcs.resource.platform.serverdata.client.ServerComponent;
import com.sas.svcs.resource.platform.serverdata.client.ServerContext;
import com.sas.svcs.resource.platform.software.client.SoftwareResourceBase;
import com.sas.svcs.web.data.content.ContentObjectAttrData;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Properties;

@XmlRootElement(name="directory")
public class DirectoryData
extends ContentObjectAttrData {
    private static final String DIRECTORY_DATA_VERSION = "1";
    private Directory directory;

    public DirectoryData() {
        this(new Directory());
    }

    public DirectoryData(Directory directory) {
        super((ContentComponent)directory);
        this.directory = directory;
    }

    public Properties getProperties() {
        return this.directory.getProperties();
    }

    public void setProperties(Properties properties) {
        this.directory.setProperties(properties);
    }

    public String getDirectoryPath() {
        return this.directory.getDirectoryPath();
    }

    public void setDirectoryPath(String directoryPath) {
        this.directory.setDirectoryPath(directoryPath);
    }

    @XmlAttribute
    public boolean isRelative() {
        return this.directory.isRelative();
    }

    public void setRelative(boolean isRelative) {
        this.directory.setRelative(isRelative);
    }

    @XmlAttribute
    public String getVersion() {
        return DIRECTORY_DATA_VERSION;
    }

    @XmlElement(name="links")
    public Links getLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        if (this.directory != null) {
            ReferenceList serverRef;
            Link selfLink = new Link("GET", "self", "/content/directories/" + ContentRESTUtils.getIdForLink((String)this.directory.getId()));
            result.add(selfLink);
            Reference parentRef = this.directory.getParent();
            if (parentRef != null && parentRef.getTarget() != null) {
                Link lsLink = new Link("GET", "up", "/content/directories/" + ContentRESTUtils.getIdForLink((String)((Directory)parentRef.getTarget()).getId()));
                result.add(lsLink);
            }
            if ((serverRef = this.directory.getServerData()) != null && serverRef.getTargetList() != null) {
                for (SoftwareResourceBase nextResource : (ArrayList)serverRef.getTargetList()) {
                    long type = -1L;
                    if (nextResource instanceof ServerContext) {
                        type = 42L;
                    }
                    if (nextResource instanceof LogicalServer) {
                        type = 94L;
                    }
                    if (nextResource instanceof ServerComponent) {
                        type = 93L;
                    }
                    Link serverLink = new Link("GET", "host", "/content/" + type + "/" + ContentRESTUtils.getIdForLink((String)nextResource.getId()));
                    result.add(serverLink);
                }
            }
        }
        return new Links(result);
    }
}

