/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.data.config;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.web.data.config.ApplicationSetting;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.springframework.web.util.UriUtils;

@XmlRootElement(name="application")
public class ApplicationData {
    String name;
    String uri;
    Properties settings = new Properties();

    public ApplicationData() {
    }

    public ApplicationData(String name) {
        this.name = name;
    }

    public ApplicationData(String name, Properties settings) {
        this.name = name;
        this.settings = settings;
    }

    public ApplicationData(String name, Properties settings, String uri) {
        this.name = name;
        this.settings = settings;
        this.uri = uri;
    }

    @XmlElement
    public String getUri() {
        return this.uri;
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    @XmlElement(name="setting")
    public List<ApplicationSetting> getSettings() {
        if (null == this.settings || this.settings.isEmpty()) {
            return null;
        }
        ArrayList<ApplicationSetting> result = new ArrayList<ApplicationSetting>();
        Enumeration<?> names = this.settings.propertyNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            String value = this.settings.getProperty(key);
            result.add(new ApplicationSetting(key, value));
        }
        return result;
    }

    @XmlElement(name="link")
    public List<Link> getLinks() throws UnsupportedEncodingException {
        ArrayList<Link> links = new ArrayList<Link>();
        String uriEncodedName = UriUtils.encodePathSegment((String)this.name, (String)"UTF-8");
        links.add(new Link("", "self", "/applications/" + uriEncodedName));
        return links;
    }
}

