/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest.util;

import com.sas.commons.rest.links.Link;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RESTUtil {
    public static final String ACCESS_BY_UUID_PROPERTY = "_SAS_REF_BY_UUID_ONLY";
    protected static Locale DEFAULT_LOCALE = Locale.US;

    public static boolean containsHeader(HttpServletRequest request, String header, String headerToVerify) {
        Enumeration en = request.getHeaders(header);
        if (en == null || !en.hasMoreElements()) {
            return false;
        }
        while (en.hasMoreElements()) {
            String value = (String)en.nextElement();
            if (!headerToVerify.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static List<Link> createPaginationLinks(int start, int limit, int collectionSize, String baseUrl) {
        return RESTUtil.createPaginationLinks(start, limit, collectionSize, baseUrl, null);
    }

    public static List<Link> createPaginationLinks(int start, int limit, long collectionSize, String baseUrl, Map<String, ?> params) {
        long newStart;
        String paramsFilter = "";
        if (params != null && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String key : params.keySet()) {
                Object value = params.get(key);
                if (value == null) continue;
                if (value instanceof String) {
                    sb.append("&");
                    sb.append(key);
                    sb.append("=");
                    sb.append(value);
                    continue;
                }
                if (value instanceof List) {
                    for (Object o : (List)value) {
                        if (o == null) continue;
                        sb.append("&");
                        sb.append(key);
                        sb.append("=");
                        sb.append(o);
                    }
                    continue;
                }
                throw new RuntimeException("calling this method with an unsupported argument");
            }
            paramsFilter = sb.toString();
        }
        ArrayList<Link> paginationLinks = new ArrayList<Link>(5);
        if (start > 0) {
            paginationLinks.add(new Link("GET", "first", baseUrl + "?start=0&limit=" + limit + paramsFilter));
            int newStart2 = start - limit;
            if (newStart2 > 0) {
                paginationLinks.add(new Link("GET", "prev", baseUrl + "?start=" + newStart2 + "&limit=" + limit + paramsFilter));
            }
        }
        if (collectionSize > (long)(start + limit)) {
            int newStart3 = start + limit;
            paginationLinks.add(new Link("GET", "next", baseUrl + "?start=" + newStart3 + "&limit=" + limit + paramsFilter));
        }
        if ((newStart = collectionSize - (long)limit) < 0L) {
            newStart = 0L;
        }
        paginationLinks.add(new Link("GET", "last", baseUrl + "?start=" + newStart + "&limit=" + limit + paramsFilter));
        return paginationLinks;
    }

    public static List<Link> createCollectionLinks(HttpServletRequest request) {
        String baseUrl = request.getPathInfo();
        String queryString = request.getQueryString();
        ArrayList<Link> collectionLinks = new ArrayList<Link>(2);
        String selfURL = queryString == null || queryString.isEmpty() ? baseUrl : baseUrl + "?" + queryString;
        Link selfLink = new Link("GET", "self", selfURL);
        collectionLinks.add(selfLink);
        return collectionLinks;
    }
}

