/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest.relationships;

import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.relationship.client.RelationshipException;
import com.sas.svcs.content.relationship.client.RelationshipType;
import com.sas.svcs.content.relationship.client.RelationshipTypeService;
import com.sas.svcs.labeledentity.client.Label;
import com.sas.svcs.labeledentity.client.LabeledEntity;
import com.sas.svcs.labeledentity.client.LabeledEntityService;
import com.sas.svcs.web.data.relationships.RelationshipTypeData;
import com.sas.svcs.web.data.relationships.RelationshipTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RelationshipTypesController {
    RelationshipTypeService relationshipTypeService;
    LabeledEntityService leService;

    @Autowired
    public void setLabeledEntityService(LabeledEntityService leService) {
        this.leService = leService;
    }

    @Autowired
    public void setRelationshipTypeService(RelationshipTypeService relationshipTypeService) {
        this.relationshipTypeService = relationshipTypeService;
    }

    @RequestMapping(value={"/relsvc/types"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<RelationshipTypes> getRelationshipTypes(@RequestHeader(value="Accept-Language", required=false) Locale language) throws RelationshipException {
        List<RelationshipType> lrt = null == language ? this.relationshipTypeService.getRelationshipTypes() : this.getLocalizedRelationshipTypes(language);
        return new ResponseEntity((Object)new RelationshipTypes(lrt), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/relsvc/types/{relationshipType}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<RelationshipTypeData> getRelationshipType(@PathVariable String relationshipType, @RequestHeader(value="Accept-Language", required=false) Locale language) throws RelationshipException {
        RelationshipType rt = null == language ? this.relationshipTypeService.getRelationshipInfoByType(relationshipType) : this.getLocalizedRelationshipInfoByType(relationshipType, language);
        if (rt != null) {
            return new ResponseEntity((Object)new RelationshipTypeData(rt), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    private RelationshipType getLocalizedRelationshipInfoByType(String relationshipType, Locale locale) throws RelationshipException {
        long relTypeLEID = 4501L;
        String name = "_Label";
        String desc = "_Description";
        String partnerName = "_PartnerLabel";
        String partnerDesc = "_PartnerDescription";
        RelationshipType rt = this.relationshipTypeService.getRelationshipInfoByType(relationshipType);
        if (rt != null) {
            LabeledEntity le;
            Label label;
            Collection l = this.leService.getLabeledEntitiesByOwningObject(new ObjectIdentity(relTypeLEID, relationshipType + name));
            if (l.iterator().hasNext() && (label = (le = (LabeledEntity)l.iterator().next()).getLabel(locale)) != null) {
                rt.setName(label.getValue());
            }
            if ((l = this.leService.getLabeledEntitiesByOwningObject(new ObjectIdentity(relTypeLEID, relationshipType + desc))).iterator().hasNext() && (label = (le = (LabeledEntity)l.iterator().next()).getLabel(locale)) != null) {
                rt.setLabel(label.getValue());
            }
            if (rt.isDirectional()) {
                l = this.leService.getLabeledEntitiesByOwningObject(new ObjectIdentity(relTypeLEID, relationshipType + partnerName));
                if (l.iterator().hasNext() && (label = (le = (LabeledEntity)l.iterator().next()).getLabel(locale)) != null) {
                    rt.setPartnerName(label.getValue());
                }
                if ((l = this.leService.getLabeledEntitiesByOwningObject(new ObjectIdentity(relTypeLEID, relationshipType + partnerDesc))).iterator().hasNext() && (label = (le = (LabeledEntity)l.iterator().next()).getLabel(locale)) != null) {
                    rt.setPartnerLabel(label.getValue());
                }
            }
        }
        return rt;
    }

    private List<RelationshipType> getLocalizedRelationshipTypes(Locale locale) throws RelationshipException {
        ArrayList<RelationshipType> returnTypes = new ArrayList<RelationshipType>();
        List rts = this.relationshipTypeService.getRelationshipTypes();
        for (RelationshipType rt : rts) {
            RelationshipType r = this.getLocalizedRelationshipInfoByType(rt.getRelationshipType(), locale);
            returnTypes.add(r);
        }
        return returnTypes;
    }
}

