/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest.relationships;

import com.sas.commons.antlr.ParseException;
import com.sas.commons.expr.Expression;
import com.sas.commons.expr.ExpressionVisitor;
import com.sas.commons.rest.expr.QueryExpression;
import com.sas.svcs.common.client.ContentFilterCriteria;
import com.sas.svcs.common.client.Embeddable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ContentObjectDescriptor;
import com.sas.svcs.content.lookup.client.LookupService;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIService;
import com.sas.svcs.content.relationship.client.RelationshipDirection;
import com.sas.svcs.content.relationship.client.RelationshipException;
import com.sas.svcs.content.relationship.client.RelationshipType;
import com.sas.svcs.content.relationship.client.RelationshipTypeService;
import com.sas.svcs.content.relationship.client.report.RelationshipContentFilterCriteria;
import com.sas.svcs.content.relationship.client.report.RelationshipDescriptor;
import com.sas.svcs.content.relationship.client.report.RelationshipFilter;
import com.sas.svcs.content.relationship.client.report.RelationshipReport;
import com.sas.svcs.content.relationship.client.report.RelationshipReportUtil;
import com.sas.svcs.content.relationship.client.report.RelationshipReportingService;
import com.sas.svcs.content.relationship.client.report.ReportType;
import com.sas.svcs.content.relationship.client.report.ResourceDescriptor;
import com.sas.svcs.web.controllers.rest.relationships.ContentFilterExpressionVisitor;
import com.sas.svcs.web.controllers.rest.relationships.RESTRelationshipException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/relsvc/relationships/report"})
public class RelationshipReportController {
    private static final Logger log = LogManager.getLogger(RelationshipReportController.class);
    private static final int DEFAULT_DEPTH = 1;
    private static final RelationshipDirection DEFAULT_DIRECTION = RelationshipDirection.TO;
    private static final List<String> DEFAULT_RELATIONSHIP_TYPES = Arrays.asList("D", "A");
    private static final RelationshipFilter.FilterTraversal DEFAULT_FILTER_TRAVERSAL = RelationshipFilter.FilterTraversal.PRE_ORDER;
    private RelationshipReportingService relationshipReportingService;
    private RelationshipTypeService relationshipTypeService;
    private LookupService lookupService;
    private ObjectTypeUIService objectTypeUIService;

    @Autowired
    public void setRelationshipReportingService(RelationshipReportingService relationshipReportingService) {
        this.relationshipReportingService = relationshipReportingService;
    }

    @Autowired
    public void setRelationshipTypeService(RelationshipTypeService relationshipTypeService) {
        this.relationshipTypeService = relationshipTypeService;
    }

    @Autowired
    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    @Autowired
    public void setObjectTypeUIService(ObjectTypeUIService objectTypeUIService) {
        this.objectTypeUIService = objectTypeUIService;
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"text/plain", "text/csv"})
    @ResponseBody
    public void buildReport(HttpServletRequest request, HttpServletResponse response, Locale locale, @RequestParam(value="reportType", required=false) String reportType, @RequestParam(value="contentFilter", required=false) String contentFilter, @RequestParam(value="subjectLimit", required=false, defaultValue="10000") int subjectLimit) throws RelationshipException, IOException {
        RelationshipReport report = null;
        ReportType type = null;
        if (reportType != null) {
            type = ReportType.getReportType((String)reportType);
            if (type == null) {
                response.sendError(400, "Invalid report type specified: " + reportType);
                return;
            }
        } else {
            type = ReportType.DEFAULT;
        }
        try {
            List subjects;
            RelationshipFilter relationshipFilter = this.createRelationshipFilter(type);
            RelationshipContentFilterCriteria filterCriteria = this.createContentFilter(request, contentFilter, "contentFilter");
            if (filterCriteria != null && (subjectLimit > 0 || subjectLimit == -1)) {
                log.trace("Generating report based on content filter");
                filterCriteria.setSearchLimit(subjectLimit);
                report = this.relationshipReportingService.searchRelationships((ContentFilterCriteria)filterCriteria, relationshipFilter);
            }
            List list = subjects = report == null ? null : report.getSubjects();
            if (subjects == null || subjects.isEmpty()) {
                log.trace("No objects were found to generate the report.");
                response.sendError(204, "No objects were found to generate the report.");
            } else {
                log.trace("Retrieved relationship information for " + subjects.size() + " resources.  Writing report contents.");
                OutputWriter writer = this.getOutputWriter(request, response, locale);
                writer.printOutput(report);
                log.trace("Finished writing report");
            }
        }
        catch (RelationshipException e) {
            response.sendError(500, "A failure occurred generating the relationship report: " + e.getLocalizedMessage());
        }
        catch (RESTRelationshipException e) {
            response.sendError(400, e.getLocalizedMessage());
        }
    }

    private OutputWriter getOutputWriter(HttpServletRequest request, HttpServletResponse response, Locale locale) throws IOException {
        OutputWriter writer;
        if (RelationshipReportController.containsHeader(request, "Accept", "text/plain")) {
            response.setContentType(MediaType.TEXT_PLAIN.toString());
            writer = new ListOutputWriter(response.getWriter(), locale);
        } else if (RelationshipReportController.containsHeader(request, "Accept", "text/csv")) {
            response.setContentType(new MediaType("text", "csv", Charset.forName("UTF-8")).toString());
            writer = new CSVOutputWriter(response.getWriter(), locale);
        } else {
            writer = new ListOutputWriter(response.getWriter(), locale);
        }
        return writer;
    }

    RelationshipContentFilterCriteria createContentFilter(HttpServletRequest request, String filter, String filterName) {
        if (filter == null) {
            return null;
        }
        Expression expression = null;
        QueryExpression qe = new QueryExpression(new String[0]);
        try {
            expression = qe.build(request, "contentFilter");
        }
        catch (ParseException e) {
            throw new RESTRelationshipException(HttpStatus.BAD_REQUEST, "Invalid content filter syntax. " + e.getMessage());
        }
        ContentFilterExpressionVisitor expressionVisitor = new ContentFilterExpressionVisitor();
        expression.accept((ExpressionVisitor)expressionVisitor);
        return expressionVisitor.getContentFilter();
    }

    RelationshipFilter createRelationshipFilter(ReportType mode) {
        RelationshipFilter filter = new RelationshipFilter();
        switch (mode) {
            case LINEAGE: {
                filter = new RelationshipFilter();
                filter.setDepth(10);
                filter.setDirection(RelationshipDirection.TO);
                filter.setRelationshipTypes(Arrays.asList("D", "I"));
                break;
            }
            case IMPACT: {
                filter = new RelationshipFilter();
                filter.setDepth(10);
                filter.setDirection(RelationshipDirection.FROM);
                filter.setRelationshipTypes(Arrays.asList("D", "I", "A"));
                break;
            }
            case DIRECT_DEPENDENCIES: {
                filter.setDepth(1);
                filter.setDirection(RelationshipDirection.TO);
                filter.setRelationshipTypes(Arrays.asList("D"));
                break;
            }
            case INDIRECT_DEPENDENCIES: {
                filter.setDepth(10);
                filter.setDirection(RelationshipDirection.TO);
                filter.setRelationshipTypes(Arrays.asList("D"));
                filter.setFilterTraversal(RelationshipFilter.FilterTraversal.POST_ORDER);
                break;
            }
            default: {
                filter = this.createDefaultRelationshipFilter();
            }
        }
        return filter;
    }

    RelationshipFilter createDefaultRelationshipFilter() {
        RelationshipFilter filter = new RelationshipFilter();
        filter.setDepth(1);
        filter.setDirection(DEFAULT_DIRECTION);
        filter.setRelationshipTypes(DEFAULT_RELATIONSHIP_TYPES);
        filter.setFilterTraversal(DEFAULT_FILTER_TRAVERSAL);
        return filter;
    }

    private static boolean containsHeader(HttpServletRequest request, String header, String headerToVerify) {
        Enumeration en = request.getHeaders(header);
        if (en == null || !en.hasMoreElements()) {
            return false;
        }
        while (en.hasMoreElements()) {
            String value = (String)en.nextElement();
            if (!headerToVerify.equals(value)) continue;
            return true;
        }
        return false;
    }

    abstract class OutputWriter {
        final String NEW_LINE = System.getProperty("line.separator");
        private Writer writer;
        protected Locale locale;
        protected RelationshipReportUtil reportingUtil = new RelationshipReportUtil();
        private Map<String, RelationshipType> relationshipTypeCache;

        public OutputWriter(Writer writer, Locale locale) {
            this.writer = writer;
            this.locale = locale;
            this.reportingUtil = new RelationshipReportUtil();
            this.reportingUtil.setObjectTypeUIService(RelationshipReportController.this.objectTypeUIService);
        }

        protected abstract void printOutput(RelationshipReport var1, Writer var2) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void printOutput(RelationshipReport report) throws IOException, RelationshipException {
            this.relationshipTypeCache = new HashMap<String, RelationshipType>(10);
            List types = RelationshipReportController.this.relationshipTypeService.getRelationshipTypes();
            for (RelationshipType type : types) {
                this.relationshipTypeCache.put(type.getRelationshipType(), type);
            }
            try {
                this.printOutput(report, this.writer);
            }
            finally {
                this.writer.flush();
            }
        }

        protected String getRelationshipTypeLabel(String type) {
            RelationshipType relationshipType = this.relationshipTypeCache.get(type);
            return relationshipType == null ? "unknown type" : relationshipType.getName();
        }

        protected final boolean isRelationshipDirectional(String type) {
            RelationshipType relationshipType = this.relationshipTypeCache.get(type);
            return relationshipType == null ? false : relationshipType.isDirectional();
        }

        protected final ContentObjectDescriptor fetchObject(ObjectIdentity identity) {
            return RelationshipReportController.this.lookupService.getContentObjectById(identity);
        }
    }

    class ListOutputWriter
    extends OutputWriter {
        private static final String ARROW_FROM = "<-- ";
        private static final String ARROW_TO = "--> ";
        private static final String ARROW_NONE = "--- ";
        private Map<ObjectIdentity, ContentComponent> parentCache;

        public ListOutputWriter(Writer writer, Locale locale) {
            super(writer, locale);
        }

        @Override
        protected void printOutput(RelationshipReport report, Writer writer) throws IOException {
            List subjects = report.getSubjects();
            for (ResourceDescriptor subject : subjects) {
                HashSet<ResourceDescriptor> resourceCache = new HashSet<ResourceDescriptor>();
                writer.write(this.getObjectString(subject));
                writer.write(this.NEW_LINE);
                this.printRelationships(subject, writer, 0, resourceCache);
                writer.write(this.NEW_LINE);
                writer.flush();
            }
        }

        private void printRelationships(ResourceDescriptor resource, Writer writer, int level, Set<ResourceDescriptor> resourceCache) throws IOException {
            if (resourceCache.contains(resource)) {
                return;
            }
            resourceCache.add(resource);
            List relationships = resource.getRelationships();
            if (!relationships.isEmpty()) {
                for (RelationshipDescriptor relationship : relationships) {
                    ResourceDescriptor relatedResource = relationship.getRelatedResource();
                    if (relatedResource == null) continue;
                    writer.write(this.getObjectString(relatedResource, relationship, level));
                    writer.write(this.NEW_LINE);
                    this.printRelationships(relatedResource, writer, level + 1, resourceCache);
                }
            }
        }

        private String getDirectionArrow(RelationshipDescriptor relationship) {
            boolean directional = this.isRelationshipDirectional(relationship.getRelationshipType());
            RelationshipDirection direction = relationship.getDirection();
            if (directional && direction != null) {
                switch (direction) {
                    case TO: {
                        return ARROW_TO;
                    }
                    case FROM: {
                        return ARROW_FROM;
                    }
                }
                return ARROW_NONE;
            }
            return ARROW_NONE;
        }

        private String getIndentation(int level) {
            String tab = "  ";
            for (int i = 0; i < level; ++i) {
                tab = tab + "    ";
            }
            return tab;
        }

        private String getObjectString(ContentComponent content) {
            String path;
            String label = content.getName();
            if (content instanceof ContentNode && (path = ((ContentNode)content).getPath()) != null) {
                label = path;
            }
            String typeName = this.reportingUtil.getDisplayType(content, this.locale);
            return label + "(" + typeName + ")";
        }

        private String getObjectString(ResourceDescriptor resource) {
            return this.getObjectString(resource.getContentObject());
        }

        private String getObjectString(ResourceDescriptor resource, RelationshipDescriptor relationship, int level) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getIndentation(level));
            sb.append(this.getDirectionArrow(relationship));
            sb.append(this.getRelationshipTypeLabel(relationship.getRelationshipType()));
            sb.append(": ");
            sb.append(this.getObjectString(resource));
            if (resource.getContentObject() instanceof Embeddable && !"I".equalsIgnoreCase(relationship.getRelationshipType())) {
                ContentComponent parent = this.getParent(resource);
                sb.append(" - ").append("in").append(" ").append(this.getObjectString(parent));
            }
            return sb.toString();
        }

        private ContentComponent getParent(ResourceDescriptor resource) {
            ObjectIdentity parentIdentity = ((Embeddable)resource.getContentObject()).getParentId();
            if (parentIdentity == null) {
                return null;
            }
            if (this.parentCache == null) {
                this.parentCache = new HashMap<ObjectIdentity, ContentComponent>();
            } else if (this.parentCache.containsKey(parentIdentity)) {
                return this.parentCache.get(parentIdentity);
            }
            ContentComponent parent = null;
            ContentObjectDescriptor parentDescriptor = this.fetchObject(parentIdentity);
            if (parentDescriptor != null) {
                parent = parentDescriptor.getContentObject();
            }
            this.parentCache.put(parentIdentity, parent);
            return parent;
        }
    }

    class CSVOutputWriter
    extends OutputWriter {
        public CSVOutputWriter(Writer writer, Locale locale) {
            super(writer, locale);
        }

        @Override
        protected void printOutput(RelationshipReport report, Writer writer) throws IOException {
            writer.write("SubjectIndex,Depth,LeftName,LeftPath,LeftType,LeftTypeLabel,RelationshipType,Direction,RightName,RightPath,RightType,RightTypeLabel");
            writer.write(this.NEW_LINE);
            int index = 1;
            List subjects = report.getSubjects();
            for (ResourceDescriptor subject : subjects) {
                HashSet<ResourceDescriptor> resourceCache = new HashSet<ResourceDescriptor>();
                this.printRelationships(subject, writer, index++, 0, resourceCache);
                writer.flush();
            }
        }

        private void printRelationships(ResourceDescriptor resource, Writer writer, int subjectIndex, int level, Set<ResourceDescriptor> resourceCache) throws IOException {
            if (resourceCache.contains(resource)) {
                return;
            }
            resourceCache.add(resource);
            List relationships = resource.getRelationships();
            if (level == 0 && relationships.isEmpty()) {
                StringBuilder line = new StringBuilder(200);
                this.addCSVElement(line, String.valueOf(subjectIndex));
                this.addCSVElement(line, String.valueOf(level));
                this.addCSVElement(line, this.reportingUtil.getResourceName(resource));
                this.addCSVElement(line, this.reportingUtil.getResourcePath(resource));
                this.addCSVElement(line, resource.getContentObject().getObjectTypeName());
                this.addCSVElement(line, this.reportingUtil.getDisplayType(resource.getContentObject(), this.locale));
                writer.write(line.toString());
                writer.write(this.NEW_LINE);
            } else if (!relationships.isEmpty()) {
                for (RelationshipDescriptor relationship : relationships) {
                    ResourceDescriptor relatedResource = relationship.getRelatedResource();
                    if (relatedResource == null) continue;
                    StringBuilder line = new StringBuilder(200);
                    this.addCSVElement(line, String.valueOf(subjectIndex));
                    this.addCSVElement(line, String.valueOf(level));
                    this.addCSVElement(line, this.reportingUtil.getResourceName(resource));
                    this.addCSVElement(line, this.reportingUtil.getResourcePath(resource));
                    this.addCSVElement(line, resource.getContentObject().getObjectTypeName());
                    this.addCSVElement(line, this.reportingUtil.getDisplayType(resource.getContentObject(), this.locale));
                    this.addCSVElement(line, this.getRelationshipTypeLabel(relationship.getRelationshipType()));
                    this.addCSVElement(line, relationship.getDirection().getStringValue());
                    this.addCSVElement(line, this.reportingUtil.getResourceName(relatedResource));
                    this.addCSVElement(line, this.reportingUtil.getResourcePath(relatedResource));
                    this.addCSVElement(line, relatedResource.getContentObject().getObjectTypeName());
                    this.addCSVElement(line, this.reportingUtil.getDisplayType(relatedResource.getContentObject(), this.locale));
                    writer.write(line.toString());
                    writer.write(this.NEW_LINE);
                    this.printRelationships(relatedResource, writer, subjectIndex, level + 1, resourceCache);
                }
            }
        }

        private void addCSVElement(StringBuilder line, String element) {
            if (line.length() > 0) {
                line.append(",");
            }
            if (element == null) {
                return;
            }
            if (element.contains("\"")) {
                line.append("\"" + element.replaceAll("\"", "\"\"") + "\"");
            } else if (element.contains(",")) {
                line.append("\"" + element + "\"");
            } else {
                line.append(element);
            }
        }
    }
}

