/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest.content;

import com.sas.commons.rest.spring.ErrorResponseFactory;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.authorization.client.AuthorizationService;
import com.sas.svcs.content.authorization.client.EffectivePermissions;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ContainerNotEmptyException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.lifecycle.client.LifecycleService;
import com.sas.svcs.content.lifecycle.client.OperationName;
import com.sas.svcs.web.controllers.rest.content.RB;
import java.util.Locale;
import java.util.MissingResourceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public abstract class AbstractContentLifecycleController {
    protected LifecycleService lifecycleService;
    protected AuthorizationService authorizationService;

    @Autowired
    public void setLifecycleService(LifecycleService lifecycleService) {
        this.lifecycleService = lifecycleService;
    }

    @Autowired
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public ResponseEntity<?> deleteObject(long objectTypeId, String objectId, Locale locale) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity identity = new ObjectIdentity(objectTypeId, id);
        try {
            boolean isSupported = this.lifecycleService.isSupportedOperation(OperationName.DELETE, objectTypeId);
            if (!isSupported) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED);
            }
            EffectivePermissions permissions = this.authorizationService.getEffectivePermissions(identity);
            if (permissions == null || !permissions.isDeleteAllowed()) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
            }
            this.lifecycleService.deleteObject(identity);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (ContainerNotEmptyException e) {
            String msg = this.getStringResource("ContentLifecycleController.Error.Delete.ContainerNotEmpty.txt", locale);
            return ErrorResponseFactory.newResponseEntity((HttpStatus)HttpStatus.UNPROCESSABLE_ENTITY, (String)msg, null);
        }
    }

    final String getStringResource(String key, Locale locale) {
        if (locale != null) {
            try {
                return RB.getStringResource(key, locale);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return RB.getStringResource(key);
    }
}

