/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.common.client.ReferenceList;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.resource.platform.machine.client.Machine;
import com.sas.svcs.resource.platform.machine.client.MachineService;
import com.sas.svcs.resource.platform.serverdata.client.LogicalServer;
import com.sas.svcs.resource.platform.serverdata.client.ServerComponent;
import com.sas.svcs.resource.platform.serverdata.client.ServerContext;
import com.sas.svcs.resource.platform.serverdata.client.ServerDataService;
import com.sas.svcs.resource.platform.software.client.SoftwareResourceBase;
import com.sas.svcs.web.controllers.rest.util.AuthorizationUtil;
import com.sas.svcs.web.data.servers.LogicalServerData;
import com.sas.svcs.web.data.servers.LogicalServers;
import com.sas.svcs.web.data.servers.MachineData;
import com.sas.svcs.web.data.servers.Machines;
import com.sas.svcs.web.data.servers.ServerComponentData;
import com.sas.svcs.web.data.servers.ServerComponents;
import com.sas.svcs.web.data.servers.ServerContextData;
import com.sas.svcs.web.data.servers.ServerContexts;
import com.sas.svcs.web.data.servers.SoftwareResourceBaseData;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(method={RequestMethod.GET})
public class ServerDataController {
    ServerDataService serverDataService;
    MachineService machineService;

    @Autowired
    public void setServerDataService(ServerDataService serverDataService) {
        this.serverDataService = serverDataService;
    }

    @Autowired
    public void setMachineService(MachineService machineService) {
        this.machineService = machineService;
    }

    @RequestMapping(value={"/content/42"})
    @ResponseBody
    public ResponseEntity<ServerContexts> getServerContextsType(@RequestParam(value="full", defaultValue="false", required=false) boolean full) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        return this.getServerContexts(full);
    }

    @RequestMapping(value={"/content/serverContexts"})
    @ResponseBody
    public ResponseEntity<ServerContexts> getServerContexts(@RequestParam(value="full", defaultValue="false", required=false) boolean full) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        List serverContextList = null;
        serverContextList = full ? this.serverDataService.getServerContextsFull() : this.serverDataService.getServerContexts();
        ArrayList<ServerContextData> serverContextDataList = new ArrayList<ServerContextData>();
        for (ServerContext serverContext : serverContextList) {
            serverContextDataList.add(new ServerContextData(serverContext, full));
        }
        return new ResponseEntity((Object)new ServerContexts(serverContextDataList), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/42/{objectId}"})
    @ResponseBody
    public ResponseEntity<ServerContextData> getServerContextType(@PathVariable String objectId) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        return this.getServerContext(objectId);
    }

    @RequestMapping(value={"/content/serverContexts/{objectId}"})
    @ResponseBody
    public ResponseEntity<ServerContextData> getServerContext(@PathVariable String objectId) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        ServerContextData resultData = null;
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ServerContext theServer = (ServerContext)this.serverDataService.getServerById(new ObjectIdentity(42L, id));
        if (theServer == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (theServer instanceof ServerContext) {
            resultData = new ServerContextData(theServer);
        }
        return new ResponseEntity((Object)resultData, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/serverContexts/{objectId}/logicalServers"})
    @ResponseBody
    public ResponseEntity<LogicalServers> getServerContextLogicalServers(@PathVariable String objectId) {
        ServerContext serverContext;
        ReferenceList logicalServerRef;
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        ArrayList<LogicalServerData> serverDataList = new ArrayList<LogicalServerData>();
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ServerContext theServer = (ServerContext)this.serverDataService.getServerById(new ObjectIdentity(42L, id));
        if (theServer == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (theServer instanceof ServerContext && (logicalServerRef = (serverContext = theServer).getLogicalServers()) != null && logicalServerRef.getTargetList() != null) {
            for (LogicalServer nextLogicalServer : (ArrayList)logicalServerRef.getTargetList()) {
                serverDataList.add(new LogicalServerData(nextLogicalServer));
            }
        }
        return new ResponseEntity((Object)new LogicalServers(serverDataList), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/94"})
    @ResponseBody
    public ResponseEntity<LogicalServers> getLogicalServersType(@RequestParam(value="full", defaultValue="false", required=false) boolean full) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        return this.getLogicalServers(full);
    }

    @RequestMapping(value={"/content/logicalServers"})
    @ResponseBody
    public ResponseEntity<LogicalServers> getLogicalServers(@RequestParam(value="full", defaultValue="false", required=false) boolean full) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        List logicalServerList = null;
        logicalServerList = full ? this.serverDataService.getLogicalServersFull() : this.serverDataService.getLogicalServers();
        ArrayList<LogicalServerData> logicalServerDataList = new ArrayList<LogicalServerData>();
        for (LogicalServer logicalServer : logicalServerList) {
            logicalServerDataList.add(new LogicalServerData(logicalServer, full));
        }
        return new ResponseEntity((Object)new LogicalServers(logicalServerDataList), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/94/{objectId}"})
    @ResponseBody
    public ResponseEntity<LogicalServerData> getLogicalServerType(@PathVariable String objectId) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        return this.getLogicalServer(objectId);
    }

    @RequestMapping(value={"/content/logicalServers/{objectId}"})
    @ResponseBody
    public ResponseEntity<LogicalServerData> getLogicalServer(@PathVariable String objectId) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        LogicalServerData resultData = null;
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        LogicalServer theServer = (LogicalServer)this.serverDataService.getServerById(new ObjectIdentity(94L, id));
        if (theServer == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (theServer instanceof LogicalServer) {
            resultData = new LogicalServerData(theServer);
        }
        return new ResponseEntity((Object)resultData, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/94/{objectId}/serverComponents"})
    @ResponseBody
    public ResponseEntity<ServerComponents> getLogicalServerComponentsType(@PathVariable String objectId) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        return this.getLogicalServerComponents(objectId);
    }

    @RequestMapping(value={"/content/logicalServers/{objectId}/serverComponents"})
    @ResponseBody
    public ResponseEntity<ServerComponents> getLogicalServerComponents(@PathVariable String objectId) {
        LogicalServer logicalServer;
        ReferenceList componentRef;
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        ArrayList<ServerComponentData> componentList = new ArrayList<ServerComponentData>();
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        LogicalServer theServer = (LogicalServer)this.serverDataService.getServerById(new ObjectIdentity(94L, id));
        if (theServer == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (theServer instanceof LogicalServer && (componentRef = (logicalServer = theServer).getServerComponents()) != null && componentRef.getTargetList() != null) {
            for (ServerComponent nextComponent : (ArrayList)componentRef.getTargetList()) {
                componentList.add(new ServerComponentData(nextComponent));
            }
        }
        return new ResponseEntity((Object)new ServerComponents(componentList), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/93"})
    @ResponseBody
    public ResponseEntity<ServerComponents> getServerComponentsType() {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        return this.getServerComponents();
    }

    @RequestMapping(value={"/content/serverComponents"})
    @ResponseBody
    public ResponseEntity<ServerComponents> getServerComponents() {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        List serverComponentList = this.serverDataService.getServerComponents();
        ArrayList<ServerComponentData> serverComponentDataList = new ArrayList<ServerComponentData>();
        for (ServerComponent serverComponent : serverComponentList) {
            serverComponentDataList.add(new ServerComponentData(serverComponent));
        }
        return new ResponseEntity((Object)new ServerComponents(serverComponentDataList), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/93/{objectId}"})
    @ResponseBody
    public ResponseEntity<SoftwareResourceBaseData> getServerType(@PathVariable String objectId) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        return this.getServer(objectId);
    }

    @RequestMapping(value={"/content/serverComponents/{objectId}"})
    @ResponseBody
    public ResponseEntity<SoftwareResourceBaseData> getServer(@PathVariable String objectId) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        SoftwareResourceBaseData resultData = null;
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        SoftwareResourceBase theServer = this.serverDataService.getServerById(new ObjectIdentity(93L, id));
        if (theServer == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        resultData = theServer instanceof ServerContext ? new ServerContextData((ServerContext)theServer) : (theServer instanceof LogicalServer ? new LogicalServerData((LogicalServer)theServer) : (theServer instanceof ServerComponent ? new ServerComponentData((ServerComponent)theServer) : new SoftwareResourceBaseData(theServer)));
        return new ResponseEntity((Object)resultData, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/50/{objectId}"})
    @ResponseBody
    public ResponseEntity<MachineData> getMachineType(@PathVariable String objectId) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        return this.getMachine(objectId);
    }

    @RequestMapping(value={"/content/machines/{objectId}"})
    @ResponseBody
    public ResponseEntity<MachineData> getMachine(@PathVariable String objectId) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        MachineData resultData = null;
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        Machine machine = this.machineService.getMachineById(new ObjectIdentity(50L, id));
        if (machine == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        resultData = new MachineData(machine);
        return new ResponseEntity((Object)resultData, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/50"})
    @ResponseBody
    public ResponseEntity<Machines> getMachinesType() {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        return this.getMachines();
    }

    @RequestMapping(value={"/content/machines"})
    @ResponseBody
    public ResponseEntity<Machines> getMachines() {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("contentservers")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        Machines resultData = null;
        ArrayList<MachineData> machineDataList = new ArrayList<MachineData>();
        List machineList = this.machineService.getMachines();
        for (Machine machine : machineList) {
            machineDataList.add(new MachineData(machine));
        }
        resultData = new Machines(machineDataList);
        return new ResponseEntity((Object)resultData, (HttpStatusCode)HttpStatus.OK);
    }
}

