/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.authorization.client.Privilege;
import com.sas.svcs.authorization.client.Role;
import com.sas.svcs.authorization.client.RoleService;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.labeledentity.client.Label;
import com.sas.svcs.labeledentity.client.LabeledEntity;
import com.sas.svcs.labeledentity.client.LabeledEntityNotFoundException;
import com.sas.svcs.labeledentity.client.LabeledEntityService;
import com.sas.svcs.web.controllers.rest.PrivilegesController;
import com.sas.svcs.web.controllers.rest.util.AuthorizationUtil;
import com.sas.svcs.web.data.authorization.AuthorizationLabels;
import com.sas.svcs.web.data.authorization.PrivilegeData;
import com.sas.svcs.web.data.authorization.Privileges;
import com.sas.svcs.web.data.authorization.RoleData;
import com.sas.svcs.web.data.authorization.Roles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/authorities/roles"})
public class RolesController {
    private static final Logger logger = LogManager.getLogger(RolesController.class);
    private RoleService roleService;
    private PrivilegesController privilegesController;
    private LabeledEntityService labeledEntityService;

    @Autowired
    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    @Autowired
    public void setLabeledEntityService(LabeledEntityService leService) {
        this.labeledEntityService = leService;
    }

    @Autowired
    public void setPrivilegesController(PrivilegesController privilegesController) {
        this.privilegesController = privilegesController;
    }

    private PrivilegePartition privilegesThatDontExist(Privileges privs) {
        if (null == privs) {
            return new PrivilegePartition();
        }
        ArrayList<PrivilegeData> toBeCreated = new ArrayList<PrivilegeData>(privs.privileges.size());
        ArrayList<Privilege> existing = new ArrayList<Privilege>();
        for (PrivilegeData pd : privs.privileges) {
            Privilege p = this.privilegesController.getPrivilegeFromPrivilegeData(pd);
            if (null == p) {
                toBeCreated.add(pd);
                continue;
            }
            existing.add(p);
        }
        return new PrivilegePartition(toBeCreated, existing);
    }

    @RequestMapping(value={"/{roleName}/privileges"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<RoleData> assignPrivilegesToRole(@PathVariable String roleName, @RequestBody Privileges privileges) {
        Role role = this.roleService.getRoleByName(roleName);
        if (null == role) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ArrayList<Privilege> privList = new ArrayList<Privilege>(privileges.privileges.size());
        for (PrivilegeData pd : privileges.privileges) {
            Privilege p = this.privilegesController.getPrivilegeFromPrivilegeData(pd);
            if (null == p) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            privList.add(p);
        }
        role.getPrivileges().addAll(privList);
        this.roleService.updateRole(role);
        RoleData rd = this.roleDataFromRole(role, true, false);
        return new ResponseEntity((Object)rd, (HttpStatusCode)HttpStatus.CREATED);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Roles> createRoles(@RequestBody Roles roles) {
        for (RoleData rd : roles.roles) {
            Role role = new Role(rd.name);
            role = this.roleService.createRole(role);
            PrivilegePartition partition = this.privilegesThatDontExist(rd.privileges);
            Privileges privilegesToBeCreated = partition.toBeCreated;
            List<Privilege> createdPrivs = null;
            try {
                createdPrivs = this.privilegesController.createAuthorizationPrivileges(privilegesToBeCreated);
            }
            catch (PrivilegesController.MissingNameException e) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            HashSet<Privilege> privs = new HashSet<Privilege>(createdPrivs.size() + partition.existing.size());
            privs.addAll(partition.existing);
            privs.addAll(createdPrivs);
            Map<Locale, Label> nameLabels = AuthorizationUtil.labelsForRestLabel(rd.displayName);
            Map<Locale, Label> descLabels = AuthorizationUtil.labelsForRestLabel(rd.description);
            if (null == rd.displayName || rd.displayName.labels.size() == 0) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            LabeledEntity nameLe = new LabeledEntity();
            nameLe.setOwningObject(new ObjectIdentity((Identifiable)role));
            nameLe.setDefaultLocale(AuthorizationUtil.localeFromString(rd.displayName.defaultLocale));
            nameLe.setLabels(nameLabels);
            nameLe = this.labeledEntityService.createLabeledEntity(nameLe);
            role.setDisplayName(nameLe);
            if (descLabels.size() > 0) {
                LabeledEntity descLe = new LabeledEntity();
                descLe.setOwningObject(new ObjectIdentity((Identifiable)role));
                descLe.setDefaultLocale(AuthorizationUtil.localeFromString(rd.description.defaultLocale));
                descLe.setLabels(descLabels);
                descLe = this.labeledEntityService.createLabeledEntity(descLe);
                role.setDescription(descLe);
            }
            role.setPrivileges(privs);
            this.roleService.updateRole(role);
        }
        return new ResponseEntity((Object)roles, (HttpStatusCode)HttpStatus.CREATED);
    }

    private RoleData roleDataFromRole(Role role, boolean privsAsLinks, boolean selfLink) {
        AuthorizationLabels nameLabels = AuthorizationUtil.restLabelsForLabeledEntities(role.getDisplayName());
        AuthorizationLabels descLabels = AuthorizationUtil.restLabelsForLabeledEntities(role.getDescription());
        RoleData rd = new RoleData(role.getAuthority(), nameLabels, descLabels);
        if (privsAsLinks) {
            ArrayList<Link> links = new ArrayList<Link>(role.getPrivileges().size());
            for (Privilege p : role.getPrivileges()) {
                links.add(new Link("GET", "privilege", "/authorities/privileges/" + p.getAuthority()));
            }
            rd.links = links;
        } else {
            ArrayList<PrivilegeData> privileges = new ArrayList<PrivilegeData>(role.getPrivileges().size());
            for (Privilege p : role.getPrivileges()) {
                privileges.add(this.privilegesController.authorizationPrivilegeToPrivilegeData(p, true));
            }
            rd.privileges = new Privileges(privileges);
        }
        if (selfLink) {
            Link link = new Link("GET", "self", "/authorities/roles/" + rd.name);
            if (null == rd.links) {
                rd.links = Collections.singletonList(link);
            } else {
                rd.links.add(link);
            }
        }
        return rd;
    }

    @RequestMapping(value={"/{roleName}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<RoleData> getRole(@PathVariable String roleName) {
        Role role = this.roleService.getRoleByName(roleName);
        if (null == role) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        RoleData rd = this.roleDataFromRole(role, true, false);
        return new ResponseEntity((Object)rd, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{roleName}/displayName"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<AuthorizationLabels> getRoleDisplayname(@PathVariable String roleName) {
        Role role = this.roleService.getRoleByName(roleName);
        if (null == role) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        AuthorizationLabels labels = AuthorizationUtil.restLabelsForLabeledEntities(role.getDisplayName());
        if (null == labels || labels.labels.size() == 0) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)labels, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{roleName}/description"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<AuthorizationLabels> getRoleDescription(@PathVariable String roleName) {
        Role role = this.roleService.getRoleByName(roleName);
        if (null == role) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        AuthorizationLabels labels = AuthorizationUtil.restLabelsForLabeledEntities(role.getDescription());
        if (null == labels || labels.labels.size() == 0) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)labels, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{roleName}/displayName"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<AuthorizationLabels> updateRoleDisplayName(@PathVariable String roleName, @RequestBody AuthorizationLabels labels) {
        Role role = this.roleService.getRoleByName(roleName);
        if (null == role) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Map<Locale, Label> nameLabels = AuthorizationUtil.labelsForRestLabel(labels);
        Locale defaultLocale = AuthorizationUtil.localeFromString(labels.defaultLocale);
        ObjectIdentity owner = new ObjectIdentity((Identifiable)role);
        if (nameLabels.size() == 0) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        LabeledEntity displayName = role.getDisplayName();
        if (null == displayName) {
            displayName = new LabeledEntity(defaultLocale, new ArrayList<Label>(nameLabels.values()), owner);
            displayName = this.labeledEntityService.createLabeledEntity(displayName);
            role.setDisplayName(displayName);
            this.roleService.updateRole(role);
        } else {
            displayName.setLabels(nameLabels);
            displayName.setDefaultLocale(defaultLocale);
            try {
                this.labeledEntityService.updateLabeledEntity(displayName);
            }
            catch (LabeledEntityNotFoundException e) {
                logger.error("Unexpected error updating labeled entity for role '" + roleName + "'", (Throwable)e);
                return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity((Object)labels, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{roleName}/description"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<AuthorizationLabels> updateRoleDescription(@PathVariable String roleName, @RequestBody AuthorizationLabels labels) {
        Role role = this.roleService.getRoleByName(roleName);
        if (null == role) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Map<Locale, Label> descLabels = AuthorizationUtil.labelsForRestLabel(labels);
        Locale defaultLocale = AuthorizationUtil.localeFromString(labels.defaultLocale);
        ObjectIdentity owner = new ObjectIdentity((Identifiable)role);
        LabeledEntity description = role.getDescription();
        if (null == description && descLabels.size() > 0) {
            description = new LabeledEntity(defaultLocale, new ArrayList<Label>(descLabels.values()), owner);
            description = this.labeledEntityService.createLabeledEntity(description);
            role.setDescription(description);
            this.roleService.updateRole(role);
        } else if (descLabels.size() > 0) {
            description.setLabels(descLabels);
            description.setDefaultLocale(defaultLocale);
            try {
                this.labeledEntityService.updateLabeledEntity(description);
            }
            catch (LabeledEntityNotFoundException e) {
                logger.error("Unexpected error updating labeled entity for role '" + roleName + "'", (Throwable)e);
                return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        } else if (null != description && descLabels.size() == 0) {
            role.setDescription(null);
            this.roleService.updateRole(role);
        }
        return new ResponseEntity((Object)labels, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{roleName}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<RoleData> updateRole(@PathVariable String roleName, @RequestBody RoleData role) {
        Role serviceRole = this.roleService.getRoleByName(roleName);
        if (null == serviceRole) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        PrivilegePartition partition = this.privilegesThatDontExist(role.privileges);
        Privileges privilegesToBeCreated = partition.toBeCreated;
        List<Privilege> createdPrivs = null;
        try {
            createdPrivs = this.privilegesController.createAuthorizationPrivileges(privilegesToBeCreated);
        }
        catch (PrivilegesController.MissingNameException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        HashSet<Privilege> privs = new HashSet<Privilege>(createdPrivs.size() + partition.existing.size());
        privs.addAll(partition.existing);
        privs.addAll(createdPrivs);
        Map<Locale, Label> nameLabels = AuthorizationUtil.labelsForRestLabel(role.displayName);
        Map<Locale, Label> descLabels = AuthorizationUtil.labelsForRestLabel(role.description);
        if (null == role.displayName || role.displayName.labels.size() == 0) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (null == serviceRole.getDisplayName()) {
            LabeledEntity nameLe = new LabeledEntity(AuthorizationUtil.localeFromString(role.displayName.defaultLocale), new ArrayList<Label>(nameLabels.values()));
            nameLe.setOwningObject(new ObjectIdentity((Identifiable)serviceRole));
            this.labeledEntityService.createLabeledEntity(nameLe);
            serviceRole.setDisplayName(nameLe);
        } else {
            serviceRole.getDisplayName().setLabels(nameLabels);
            serviceRole.getDisplayName().setDefaultLocale(AuthorizationUtil.localeFromString(role.displayName.defaultLocale));
            try {
                this.labeledEntityService.updateLabeledEntity(serviceRole.getDisplayName());
            }
            catch (LabeledEntityNotFoundException e) {
                logger.error("Unexpectedly could not find labeled entity when updating role", (Throwable)e);
                return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (null == serviceRole.getDescription() && descLabels.size() > 0) {
            LabeledEntity descLe = new LabeledEntity(AuthorizationUtil.localeFromString(role.description.defaultLocale), new ArrayList<Label>(descLabels.values()));
            descLe.setOwningObject(new ObjectIdentity((Identifiable)serviceRole));
            descLe = this.labeledEntityService.createLabeledEntity(descLe);
            serviceRole.setDescription(descLe);
        } else if (null != serviceRole.getDescription()) {
            serviceRole.getDescription().setLabels(descLabels);
            serviceRole.getDescription().setDefaultLocale(AuthorizationUtil.localeFromString(role.description.defaultLocale));
            try {
                this.labeledEntityService.updateLabeledEntity(serviceRole.getDescription());
            }
            catch (LabeledEntityNotFoundException e) {
                logger.error("Unexpectedly could not find labeled entity when updating role", (Throwable)e);
                return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        serviceRole.setPrivileges(privs);
        this.roleService.updateRole(serviceRole);
        return new ResponseEntity((Object)role, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Roles getAllRoles() {
        Set serviceRoles = this.roleService.getAllRoles();
        ArrayList<RoleData> roles = new ArrayList<RoleData>(serviceRoles.size());
        for (Role serviceRole : serviceRoles) {
            roles.add(this.roleDataFromRole(serviceRole, true, true));
        }
        return new Roles(roles);
    }

    class PrivilegePartition {
        Privileges toBeCreated;
        List<Privilege> existing;

        public PrivilegePartition(List<PrivilegeData> toBeCreated, List<Privilege> existing) {
            this.toBeCreated = new Privileges(toBeCreated);
            this.existing = existing;
        }

        public PrivilegePartition() {
            this.existing = new ArrayList<Privilege>();
            this.toBeCreated = new Privileges();
        }
    }
}

