/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.commons.rest.links.Link;
import com.sas.framework.services.config.dao.ServiceURL;
import com.sas.framework.services.config.dao.ServiceURLDAO;
import com.sas.svcs.registry.client.RegisteredService;
import com.sas.svcs.registry.client.ServiceRegistryInterface;
import com.sas.svcs.registry.client.ServiceType;
import com.sas.svcs.web.data.registry.Registry;
import com.sas.svcs.web.data.registry.ServiceData;
import com.sas.svcs.web.data.registry.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RegistryController {
    ServiceRegistryInterface registry;
    private ServiceURLDAO _serviceURLDAO;

    @Autowired
    public void setServiceRegistry(ServiceRegistryInterface registry) {
        this.registry = registry;
    }

    @Autowired
    public void setServiceURLDAO(@Qualifier(value="serviceURLDAO") ServiceURLDAO serviceURLDAO) {
        this._serviceURLDAO = serviceURLDAO;
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public Registry getRestServices() {
        ArrayList<Link> links = new ArrayList<Link>();
        Map serviceMap = this.registry.getAllServices();
        Collection services = serviceMap.values();
        for (RegisteredService service : services) {
            String url;
            if (!ServiceType.REST.equals((Object)service.getServiceType()) || null == (url = service.getUrl())) continue;
            Link link = new Link("", service.getName());
            link.setHref(url);
            links.add(link);
        }
        return new Registry(links);
    }

    @RequestMapping(value={"/services"}, method={RequestMethod.GET})
    @ResponseBody
    public Services getServices(@RequestParam(required=false) String types) {
        List<String> typesList = this.parseTypes(types);
        ArrayList<ServiceData> values = new ArrayList<ServiceData>();
        Map serviceMap = this.registry.getAllServices();
        Collection services = serviceMap.values();
        for (RegisteredService registeredService : services) {
            if (!typesList.isEmpty() && !typesList.contains(registeredService.getServiceType().toString())) continue;
            values.add(new ServiceData(registeredService));
        }
        return new Services(values);
    }

    @RequestMapping(value={"/services"}, method={RequestMethod.POST})
    @ResponseBody
    public void reloadServices() {
        this.reloadAll();
    }

    private List<String> parseTypes(String types) {
        if (null == types) {
            return new ArrayList<String>();
        }
        String[] typesArray = types.toUpperCase().split(",");
        return Arrays.asList(typesArray);
    }

    private void reloadAll() {
        ArrayList<String> urls = new ArrayList<String>(5);
        if (null != this._serviceURLDAO) {
            List serviceURLs = this._serviceURLDAO.getAllServiceURLs();
            for (ServiceURL serviceURL : serviceURLs) {
                String url = serviceURL.getURL();
                if (null == url || !url.endsWith("ServiceRegistryInterface") || urls.contains(url)) continue;
                urls.add(url);
            }
        }
        for (String url : urls) {
            HttpInvokerProxyFactoryBean serviceRegistryProxyFactory = new HttpInvokerProxyFactoryBean();
            serviceRegistryProxyFactory.setServiceInterface(ServiceRegistryInterface.class);
            serviceRegistryProxyFactory.setServiceUrl(url);
            serviceRegistryProxyFactory.afterPropertiesSet();
            ServiceRegistryInterface serviceRegistry = (ServiceRegistryInterface)serviceRegistryProxyFactory.getObject();
            serviceRegistry.reload();
        }
    }
}

