/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.authorization.client.Privilege;
import com.sas.svcs.authorization.client.PrivilegeService;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.labeledentity.client.Label;
import com.sas.svcs.labeledentity.client.LabeledEntity;
import com.sas.svcs.labeledentity.client.LabeledEntityNotFoundException;
import com.sas.svcs.labeledentity.client.LabeledEntityService;
import com.sas.svcs.web.controllers.rest.util.AuthorizationUtil;
import com.sas.svcs.web.data.authorization.AuthorizationLabels;
import com.sas.svcs.web.data.authorization.PrivilegeData;
import com.sas.svcs.web.data.authorization.Privileges;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/authorities/privileges"})
public class PrivilegesController {
    private static Logger logger = LogManager.getLogger(PrivilegesController.class);
    private PrivilegeService privilegeService;
    private LabeledEntityService leService;

    @Autowired
    public void setPrivilegeService(PrivilegeService privilegeService) {
        this.privilegeService = privilegeService;
    }

    @Autowired
    public void setLabeledEntityService(LabeledEntityService leService) {
        this.leService = leService;
    }

    List<Privilege> createAuthorizationPrivileges(Privileges privileges) throws MissingNameException {
        ArrayList<Privilege> created = new ArrayList<Privilege>(privileges.privileges.size());
        for (PrivilegeData privilege : privileges.privileges) {
            Privilege p = new Privilege(privilege.name);
            p = this.privilegeService.createPrivilege(p);
            boolean needsUpdate = false;
            if (null == privilege.displayName || privilege.displayName.labels.size() == 0) {
                throw new MissingNameException();
            }
            LabeledEntity displayName = new LabeledEntity();
            displayName.setOwningObject(new ObjectIdentity((Identifiable)p));
            Map<Locale, Label> nameLabels = AuthorizationUtil.labelsForRestLabel(privilege.displayName);
            displayName.setLabels(nameLabels);
            displayName.setDefaultLocale(AuthorizationUtil.localeFromString(privilege.displayName.defaultLocale));
            displayName = this.leService.createLabeledEntity(displayName);
            p.setDisplayName(displayName);
            needsUpdate = true;
            if (null != privilege.description && privilege.description.labels.size() > 0) {
                LabeledEntity desc = new LabeledEntity();
                desc.setDefaultLocale(AuthorizationUtil.localeFromString(privilege.description.defaultLocale));
                desc.setOwningObject(new ObjectIdentity((Identifiable)p));
                Map<Locale, Label> descLabels = AuthorizationUtil.labelsForRestLabel(privilege.description);
                desc.setLabels(descLabels);
                desc = this.leService.createLabeledEntity(desc);
                p.setDescription(desc);
                needsUpdate = true;
            }
            if (needsUpdate) {
                this.privilegeService.updatePrivilege(p);
            }
            created.add(p);
        }
        return created;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Privileges> createPrivileges(@RequestBody Privileges privileges) {
        try {
            this.createAuthorizationPrivileges(privileges);
        }
        catch (MissingNameException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)privileges, (HttpStatusCode)HttpStatus.CREATED);
    }

    PrivilegeData authorizationPrivilegeToPrivilegeData(Privilege privilege, boolean selfLink) {
        AuthorizationLabels nameLabels = AuthorizationUtil.restLabelsForLabeledEntities(privilege.getDisplayName());
        AuthorizationLabels descLabels = AuthorizationUtil.restLabelsForLabeledEntities(privilege.getDescription());
        PrivilegeData pd = new PrivilegeData(privilege.getAuthority(), nameLabels, descLabels);
        if (selfLink) {
            pd.links = Collections.singletonList(new Link("GET", "self", "/authorities/privileges/" + pd.name));
        }
        return pd;
    }

    @RequestMapping(value={"/{privilegeName}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<PrivilegeData> getPrivilege(@PathVariable String privilegeName) {
        Privilege privilege = this.privilegeService.getPrivilegeByName(privilegeName);
        if (null == privilege) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)this.authorizationPrivilegeToPrivilegeData(privilege, false), (HttpStatusCode)HttpStatus.OK);
    }

    Privilege getPrivilegeFromPrivilegeData(PrivilegeData privilege) {
        return this.privilegeService.getPrivilegeByName(privilege.name);
    }

    @RequestMapping(value={"/{privilegeName}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<PrivilegeData> updatePrivilege(@PathVariable String privilegeName, @RequestBody PrivilegeData privilege) {
        Privilege p = this.getPrivilegeFromPrivilegeData(privilege);
        if (null == p) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Map<Locale, Label> nameLabels = AuthorizationUtil.labelsForRestLabel(privilege.displayName);
        if (null == privilege.displayName || nameLabels.size() == 0) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        LabeledEntity nameLe = p.getDisplayName();
        if (null == nameLe) {
            nameLe = new LabeledEntity();
            nameLe.setDefaultLocale(AuthorizationUtil.localeFromString(privilege.displayName.defaultLocale));
            nameLe.setOwningObject(new ObjectIdentity((Identifiable)p));
            nameLe.setLabels(nameLabels);
            nameLe = this.leService.createLabeledEntity(nameLe);
            p.setDisplayName(nameLe);
        } else {
            nameLe.setLabels(nameLabels);
            nameLe.setDefaultLocale(AuthorizationUtil.localeFromString(privilege.displayName.defaultLocale));
            try {
                this.leService.updateLabeledEntity(nameLe);
            }
            catch (LabeledEntityNotFoundException e) {
                logger.error("Could not find a labeled entity for privilege " + privilegeName, (Throwable)e);
                return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        Map<Locale, Label> descLabels = AuthorizationUtil.labelsForRestLabel(privilege.description);
        LabeledEntity descLe = p.getDescription();
        if (null == descLe && descLabels.size() > 0) {
            descLe = new LabeledEntity(AuthorizationUtil.localeFromString(privilege.description.defaultLocale), new ArrayList<Label>(descLabels.values()));
            descLe.setOwningObject(new ObjectIdentity((Identifiable)p));
            descLe = this.leService.createLabeledEntity(descLe);
            p.setDescription(descLe);
        } else if (null != descLe) {
            descLe.setLabels(descLabels);
            descLe.setDefaultLocale(AuthorizationUtil.localeFromString(privilege.description.defaultLocale));
            try {
                this.leService.updateLabeledEntity(descLe);
            }
            catch (LabeledEntityNotFoundException e) {
                logger.error("Could not find a labeled entity for privilege " + privilegeName, (Throwable)e);
                return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        this.privilegeService.updatePrivilege(p);
        return new ResponseEntity((Object)privilege, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{privilegeName}/displayName"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<AuthorizationLabels> getPrivilegeDisplayname(@PathVariable String privilegeName) {
        Privilege privilege = this.privilegeService.getPrivilegeByName(privilegeName);
        if (null == privilege) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        AuthorizationLabels labels = AuthorizationUtil.restLabelsForLabeledEntities(privilege.getDisplayName());
        if (null == labels || labels.labels.size() == 0) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)labels, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{privilegeName}/description"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<AuthorizationLabels> getPrivilegeDescription(@PathVariable String privilegeName) {
        Privilege privilege = this.privilegeService.getPrivilegeByName(privilegeName);
        if (null == privilege) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        AuthorizationLabels labels = AuthorizationUtil.restLabelsForLabeledEntities(privilege.getDescription());
        if (null == labels || labels.labels.size() == 0) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)labels, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{privilegeName}/displayName"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<AuthorizationLabels> updatePrivilegeDisplayName(@PathVariable String privilegeName, @RequestBody AuthorizationLabels labels) {
        Privilege priv = this.privilegeService.getPrivilegeByName(privilegeName);
        if (null == priv) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Map<Locale, Label> nameLabels = AuthorizationUtil.labelsForRestLabel(labels);
        Locale defaultLocale = AuthorizationUtil.localeFromString(labels.defaultLocale);
        ObjectIdentity owner = new ObjectIdentity((Identifiable)priv);
        if (nameLabels.size() == 0) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        LabeledEntity displayName = priv.getDisplayName();
        if (null == displayName) {
            displayName = new LabeledEntity(defaultLocale, new ArrayList<Label>(nameLabels.values()), owner);
            displayName = this.leService.createLabeledEntity(displayName);
            priv.setDisplayName(displayName);
            this.privilegeService.updatePrivilege(priv);
        } else {
            displayName.setLabels(nameLabels);
            displayName.setDefaultLocale(defaultLocale);
            try {
                this.leService.updateLabeledEntity(displayName);
            }
            catch (LabeledEntityNotFoundException e) {
                logger.error("Unexpected error updating labeled entity for privilege '" + privilegeName + "'", (Throwable)e);
                return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity((Object)labels, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{privilegeName}/description"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<AuthorizationLabels> updatePrivilegeDescription(@PathVariable String privilegeName, @RequestBody AuthorizationLabels labels) {
        Privilege priv = this.privilegeService.getPrivilegeByName(privilegeName);
        if (null == priv) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Map<Locale, Label> descLabels = AuthorizationUtil.labelsForRestLabel(labels);
        Locale defaultLocale = AuthorizationUtil.localeFromString(labels.defaultLocale);
        ObjectIdentity owner = new ObjectIdentity((Identifiable)priv);
        LabeledEntity description = priv.getDescription();
        if (null == description && descLabels.size() > 0) {
            description = new LabeledEntity(defaultLocale, new ArrayList<Label>(descLabels.values()), owner);
            description = this.leService.createLabeledEntity(description);
            priv.setDescription(description);
            this.privilegeService.updatePrivilege(priv);
        } else if (descLabels.size() > 0) {
            description.setLabels(descLabels);
            description.setDefaultLocale(defaultLocale);
            try {
                this.leService.updateLabeledEntity(description);
            }
            catch (LabeledEntityNotFoundException e) {
                logger.error("Unexpected error updating labeled entity for privilege '" + privilegeName + "'", (Throwable)e);
                return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        } else if (null != description && descLabels.size() == 0) {
            priv.setDescription(null);
            this.privilegeService.updatePrivilege(priv);
        }
        return new ResponseEntity((Object)labels, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Privileges getAllPrivileges() {
        Set servicePrivileges = this.privilegeService.getAllPrivileges();
        ArrayList<PrivilegeData> privs = new ArrayList<PrivilegeData>(servicePrivileges.size());
        for (Privilege servicePrivilege : servicePrivileges) {
            privs.add(this.authorizationPrivilegeToPrivilegeData(servicePrivilege, true));
        }
        return new Privileges(privs);
    }

    class MissingNameException
    extends Exception {
        private static final long serialVersionUID = 1L;

        MissingNameException() {
        }
    }
}

