/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeAdminService;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIDescriptor;
import com.sas.svcs.content.objecttype.client.ObjectTypeUIService;
import com.sas.svcs.web.data.types.LocalizedNames;
import com.sas.svcs.web.data.types.ObjectTypeData;
import com.sas.svcs.web.data.types.ObjectTypes;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ObjectTypesController {
    private static final Logger log = LogManager.getLogger(ObjectTypesController.class);
    ObjectTypeService objectTypeService;
    ObjectTypeUIService uiService;
    ObjectTypeAdminService objectTypeAdminService;

    @Autowired
    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    @Autowired
    public void setObjectTypeAdminService(ObjectTypeAdminService objectTypeAdminService) {
        this.objectTypeAdminService = objectTypeAdminService;
    }

    @Autowired
    public void setObjectTypeUIService(ObjectTypeUIService uiService) {
        this.uiService = uiService;
    }

    @RequestMapping(value={"/types/objects"}, method={RequestMethod.GET})
    @ResponseBody
    public ObjectTypes getObjectTypes() {
        List objectTypes = this.objectTypeService.getAllTypes();
        ArrayList<ObjectTypeData> objectTypeList = new ArrayList<ObjectTypeData>();
        for (ObjectType objectType : objectTypes) {
            objectTypeList.add(new ObjectTypeData(objectType));
        }
        return new ObjectTypes(objectTypeList);
    }

    @RequestMapping(value={"/types/objects/{objectTypeId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ObjectTypeData> getObjectTypeById(@PathVariable long objectTypeId) {
        ObjectType objectType = this.objectTypeService.getTypeById(objectTypeId);
        if (objectType == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new ObjectTypeData(objectType), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/types/objects"}, method={RequestMethod.POST})
    public void createObjectType(@RequestBody ObjectTypeData objectTypeData, HttpServletResponse response) throws IOException {
        ObjectType objectType = objectTypeData.toObjectType();
        try {
            this.objectTypeAdminService.createObjectType(objectType);
        }
        catch (ObjectExistsException e) {
            log.error("Object type already exists (" + objectTypeData.getId() + ") - can't be created: " + e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
            return;
        }
        response.setStatus(201);
    }

    @RequestMapping(value={"/types/objects/{objectTypeId}"}, method={RequestMethod.PUT})
    public void updateObjectType(@PathVariable long objectTypeId, @RequestBody ObjectTypeData objectTypeData, HttpServletResponse response) throws IOException {
        ObjectType objectType = objectTypeData.toObjectType();
        try {
            this.objectTypeAdminService.updateObjectType(objectType);
        }
        catch (ObjectNotFoundException e) {
            log.error("Object type doesn't exist (" + objectTypeData.getId() + ") - can't be updated: " + e.getMessage(), (Throwable)e);
            response.sendError(404, e.getMessage());
            return;
        }
        response.setStatus(204);
    }

    @RequestMapping(value={"/types/objects/{objectTypeId}/ui/localizedNames"}, method={RequestMethod.POST})
    public void setObjectTypeLocalizedNames(@PathVariable long objectTypeId, @RequestBody LocalizedNames localizedNames, HttpServletResponse response) throws IOException {
        try {
            this.objectTypeAdminService.setObjectTypeLocalizedNames(objectTypeId, localizedNames.toMap());
        }
        catch (ObjectNotFoundException e) {
            log.error("Object type doesn't exist (" + objectTypeId + ") - can't be updated: " + e.getMessage(), (Throwable)e);
            response.sendError(404, e.getMessage());
            return;
        }
        response.setStatus(201);
    }

    @RequestMapping(value={"/types/objects/{objectTypeId}/ui/icon"}, method={RequestMethod.POST}, headers={"Content-Type=image/*"})
    public void setObjectTypeIcon(@PathVariable long objectTypeId, InputStream input, @RequestHeader(value="Content-Type") String contentType, HttpServletResponse response) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)input, (OutputStream)baos);
        try {
            this.objectTypeAdminService.setObjectTypeIcon(objectTypeId, baos.toByteArray(), contentType);
        }
        catch (ObjectNotFoundException e) {
            log.error("Object type doesn't exist (" + objectTypeId + ") - can' t be updated: " + e.getMessage(), (Throwable)e);
            response.sendError(404, e.getMessage());
            return;
        }
        response.setStatus(201);
    }

    @RequestMapping(value={"/types/objects/{objectTypeId}/ui/localizedNames"}, method={RequestMethod.GET})
    public ResponseEntity<LocalizedNames> getLocalizedNames(@PathVariable long objectTypeId) {
        ObjectTypeUIDescriptor ui = this.uiService.getObjectTypeDescriptor(objectTypeId);
        if (ui == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new LocalizedNames(ui.getLocalizedNames()), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/types/objects/{objectTypeId}/ui/icon"}, method={RequestMethod.GET})
    public void getIcon(@PathVariable long objectTypeId, HttpServletResponse response) throws IOException {
        ObjectTypeUIDescriptor ui = this.uiService.getObjectTypeDescriptor(objectTypeId);
        if (ui == null) {
            response.sendError(404);
            return;
        }
        byte[] contents = ui.getIconContents();
        if (contents == null) {
            response.sendError(404);
            return;
        }
        response.setContentType(MediaType.IMAGE_GIF.toString());
        response.setContentLength(contents.length);
        response.getOutputStream().write(contents);
    }
}

