/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.framework.commons.util.LocaleUtil;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.template.client.NotificationContent;
import com.sas.svcs.template.client.NotificationLetterhead;
import com.sas.svcs.template.client.NotificationLetterheadService;
import com.sas.svcs.template.client.NotificationTemplate;
import com.sas.svcs.template.client.NotificationTemplateService;
import com.sas.svcs.web.data.templates.NotificationTemplateData;
import com.sas.svcs.web.data.templates.NotificationTemplates;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class NotificationTemplatesController {
    private static final Logger logger = LogManager.getLogger(NotificationTemplatesController.class);
    private NotificationTemplateService notificationTemplateService;
    private NotificationLetterheadService notificationLetterheadService;

    @Autowired
    public void setNotificationTemplateService(NotificationTemplateService notificationTemplateService) {
        this.notificationTemplateService = notificationTemplateService;
    }

    @Autowired
    public void setNotificationLetterheadService(NotificationLetterheadService notificationLetterheadService) {
        this.notificationLetterheadService = notificationLetterheadService;
    }

    @RequestMapping(value={"/content/notificationTemplates"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<NotificationTemplates> createTemplatesDefault(@RequestBody NotificationTemplates templates) {
        return this.createTemplateAndReturnDetails(templates);
    }

    @RequestMapping(value={"/content/notificationTemplates"}, method={RequestMethod.POST}, headers={"accept=application/vnd.sas.notification.templates.details+xml"})
    @ResponseBody
    public ResponseEntity<NotificationTemplates> createTemplateAndReturnDetails(@RequestBody NotificationTemplates templates) {
        logger.debug("Calling create templates in details method");
        List<NotificationTemplateData> templateDataList = templates.getNotificationTemplateList();
        ArrayList<NotificationTemplateData> newTemplateList = new ArrayList<NotificationTemplateData>();
        for (NotificationTemplateData templateData : templateDataList) {
            try {
                NotificationTemplate template = this.create(templateData);
                if (template == null) continue;
                newTemplateList.add(new NotificationTemplateData(template));
            }
            catch (Exception e) {
                logger.error("Error while trying to create " + templateData.getName() + " in locale " + templateData.getLocale() + e.getMessage());
                return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        NotificationTemplates t = new NotificationTemplates(newTemplateList);
        return new ResponseEntity((Object)t, (HttpStatusCode)HttpStatus.CREATED);
    }

    @RequestMapping(value={"/content/notificationTemplates"}, method={RequestMethod.POST}, headers={"accept=application/vnd.sas.notification.templates+xml"})
    @ResponseBody
    public ResponseEntity<NotificationTemplates> createTemplates(@RequestBody NotificationTemplates templates) {
        logger.debug("Calling create templates");
        List<NotificationTemplateData> templateDataList = templates.getNotificationTemplateList();
        ArrayList<NotificationTemplateData> newTemplateDataList = new ArrayList<NotificationTemplateData>();
        for (NotificationTemplateData templateData : templateDataList) {
            try {
                NotificationTemplate template = this.create(templateData);
                if (template == null) continue;
                newTemplateDataList.add(new NotificationTemplateData(template.getId()));
            }
            catch (Exception e) {
                logger.error("Error while trying to create " + templateData.getName() + " in locale " + templateData.getLocale() + e.getMessage());
                return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        NotificationTemplates t = new NotificationTemplates(newTemplateDataList);
        return new ResponseEntity((Object)t, (HttpStatusCode)HttpStatus.CREATED);
    }

    private NotificationTemplate create(NotificationTemplateData templateData) throws Exception {
        logger.debug("Loading " + templateData.getName() + templateData.getLocale());
        NotificationLetterhead htmlLetterhead = null;
        NotificationLetterhead txtLetterhead = null;
        if (StringUtils.isNotBlank((CharSequence)templateData.getHtmlLetterheadName())) {
            try {
                htmlLetterhead = (NotificationLetterhead)this.notificationLetterheadService.getTemplate(templateData.getHtmlLetterheadName(), LocaleUtil.getLocaleFromString((String)templateData.getLocale()));
            }
            catch (ObjectNotFoundException e1) {
                logger.warn("Unable to find html letterhead " + templateData.getHtmlLetterheadName() + " in locale " + templateData.getLocale() + " " + e1.getMessage());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)templateData.getTxtLetterheadName())) {
            try {
                txtLetterhead = (NotificationLetterhead)this.notificationLetterheadService.getTemplate(templateData.getTxtLetterheadName(), LocaleUtil.getLocaleFromString((String)templateData.getLocale()));
            }
            catch (ObjectNotFoundException e1) {
                logger.warn("Unable to find text letterhead " + templateData.getTxtLetterheadName() + " in locale " + templateData.getLocale() + " " + e1.getMessage());
            }
        }
        NotificationTemplate t = templateData.toNotificationTemplate();
        if (htmlLetterhead != null) {
            t.setHtmlLetterheadId(htmlLetterhead.getId());
        }
        if (txtLetterhead != null) {
            t.setTxtLetterheadId(txtLetterhead.getId());
        }
        NotificationTemplate template = null;
        try {
            template = (NotificationTemplate)this.notificationTemplateService.create((NotificationContent)t);
        }
        catch (ObjectExistsException ex) {
            template = this.updateTemplate(t);
        }
        return template;
    }

    private NotificationTemplate updateTemplate(NotificationTemplate t) {
        NotificationTemplate template = null;
        try {
            template = (NotificationTemplate)this.notificationTemplateService.getTemplate(t.getName(), t.getLocale());
            template.setDescription(t.getDescription());
            template.setContentStream(t.getContentStream());
            template.setHtmlLetterheadId(t.getHtmlLetterheadId());
            template.setTxtLetterheadId(t.getTxtLetterheadId());
            logger.info("update " + t.getName() + " in " + t.getLocale());
            template = (NotificationTemplate)this.notificationTemplateService.update((NotificationContent)template);
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            logger.error("Error while trying to update " + t.getName() + " in locale " + t.getLocale() + e.getMessage());
        }
        return template;
    }
}

