/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.commons.expr.SortKey;
import com.sas.commons.rest.expr.SortBy;
import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import com.sas.commons.rest.util.ResourceCollection;
import com.sas.svcs.common.client.ObjectIdentityUtils;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.lifecycle.client.LifecycleService;
import com.sas.svcs.content.lifecycle.client.OperationName;
import com.sas.svcs.content.navigation.client.ContainerNode;
import com.sas.svcs.content.navigation.client.NavigationNode;
import com.sas.svcs.content.navigation.client.NavigationService;
import com.sas.svcs.web.controllers.rest.util.RESTUtil;
import com.sas.svcs.web.controllers.rest.util.RegistryUtil;
import com.sas.svcs.web.data.navigation.NodeData;
import com.sas.svcs.web.data.navigation.Nodes;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class NavigationController {
    private static final String DEFAULT_PAGING_START = "0";
    private static final String DEFAULT_PAGING_LIMIT = "10";
    private NavigationService navigationService;
    private LifecycleService lifecycleService;
    private RegistryUtil registryUtil;

    @Autowired
    public void setNavigationService(NavigationService navigationService) {
        this.navigationService = navigationService;
    }

    @Autowired
    public void setRegistryUtil(RegistryUtil registryUtil) {
        this.registryUtil = registryUtil;
    }

    @Autowired
    public void setLifecycleService(LifecycleService lifecycleService) {
        this.lifecycleService = lifecycleService;
    }

    @RequestMapping(value={"/navigation"})
    @ResponseBody
    public ResponseEntity<NodeData> getNodeByPath(@RequestParam(value="path", required=true) String path, @RequestParam(value="type", required=true) long type) {
        NavigationNode node = this.navigationService.getObjectByPath(path, type);
        if (null == node) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        List<Link> links = this.getLinksForObject(node);
        return new ResponseEntity((Object)new NodeData(node, links), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/navigation/{objectTypeId}/{objectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<NodeData> getNode(@PathVariable long objectTypeId, @PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        NavigationNode node = this.navigationService.getObjectById(new ObjectIdentity(objectTypeId, id));
        if (null == node) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        List<Link> links = this.getLinksForObject(node);
        return new ResponseEntity((Object)new NodeData(node, links), (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<Nodes> getChildren(@PathVariable long objectTypeId, @PathVariable String objectId, @RequestParam(value="objectTypeNames", required=false) String[] typeNames) {
        List kids;
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        NavigationNode node = this.navigationService.getObjectById(new ObjectIdentity(objectTypeId, id));
        if (null == node || !(node instanceof ContainerNode)) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ArrayList types = new ArrayList();
        try {
            if (typeNames != null) {
                for (String tn : typeNames) {
                    Collections.addAll(types, tn.split(","));
                }
                kids = this.navigationService.getChildrenOfTypes((ContainerNode)node, types.toArray(new String[0]));
            } else {
                kids = this.navigationService.getChildren((ContainerNode)node);
            }
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ArrayList<NodeData> kidData = new ArrayList<NodeData>(kids.size());
        for (NavigationNode kid : kids) {
            kidData.add(new NodeData(kid, this.getLinksForObject(kid)));
        }
        return new ResponseEntity((Object)new Nodes(kidData), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/navigation/{objectTypeId}/{objectId}/children"}, method={RequestMethod.GET}, produces={"application/vnd.sas.collection+json", "application/vnd.sas.collection+xml"})
    @ResponseBody
    public ResponseEntity<?> getChildren2(HttpServletRequest request, @PathVariable long objectTypeId, @PathVariable String objectId, @RequestParam(value="objectTypeNames", required=false) String[] typeNames, @RequestParam(value="sortBy", required=false) String sortBy, @RequestParam(value="start", defaultValue="0", required=false) long start, @RequestParam(value="limit", defaultValue="10", required=false) int limit) {
        List kids;
        boolean useCollection = RESTUtil.containsHeader(request, "Accept", "application/vnd.sas.collection+json") || RESTUtil.containsHeader(request, "Accept", "application/vnd.sas.collection+xml");
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        NavigationNode node = this.navigationService.getObjectById(new ObjectIdentity(objectTypeId, id));
        if (null == node || !(node instanceof ContainerNode)) {
            return this.getEmptyCollectionResponse(useCollection, HttpStatus.NOT_FOUND);
        }
        ArrayList types = new ArrayList();
        try {
            if (typeNames != null) {
                for (String tn : typeNames) {
                    Collections.addAll(types, tn.split(","));
                }
                kids = this.navigationService.getChildrenOfTypes((ContainerNode)node, types.toArray(new String[0]));
            } else {
                kids = this.navigationService.getChildren((ContainerNode)node);
            }
        }
        catch (ObjectNotFoundException e) {
            return this.getEmptyCollectionResponse(useCollection, HttpStatus.NOT_FOUND);
        }
        if (useCollection && sortBy != null) {
            try {
                this.sortItems(kids, SortBy.parseSortKeys((String)sortBy));
            }
            catch (IllegalArgumentException e) {
                return this.getEmptyCollectionResponse(useCollection, HttpStatus.BAD_REQUEST);
            }
        }
        ArrayList<NodeData> kidData = new ArrayList<NodeData>(kids.size());
        if (useCollection) {
            start = Math.max(start, 0L);
            limit = Math.max(limit, 0);
            long count = kids.size();
            ArrayList<NodeData> dataList = new ArrayList<NodeData>(limit);
            int counter = (int)start;
            while ((long)counter < start + (long)limit && (long)counter < count) {
                NavigationNode nn = (NavigationNode)kids.get(counter);
                dataList.add(new NodeData(nn, this.getLinksForObject(nn)));
                ++counter;
            }
            String baseUrl = "/navigation/" + objectTypeId + "/" + objectId + "/children";
            List<Link> pagingLinks = RESTUtil.createPaginationLinks((int)start, limit, kids.size(), baseUrl);
            List<Link> collectionLinks = RESTUtil.createCollectionLinks(request);
            collectionLinks.addAll(pagingLinks);
            return new ResponseEntity((Object)new ResourceCollection(dataList, Long.valueOf(start), Integer.valueOf(limit), Long.valueOf(count), new Links(collectionLinks), null), (HttpStatusCode)HttpStatus.OK);
        }
        for (NavigationNode kid : kids) {
            kidData.add(new NodeData(kid, this.getLinksForObject(kid)));
        }
        return new ResponseEntity((Object)new Nodes(kidData), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/navigation/{objectTypeId}/{objectId}/ancestors"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Nodes> getAncestors(@PathVariable long objectTypeId, @PathVariable String objectId) {
        List ancestors;
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        NavigationNode node = this.navigationService.getObjectById(new ObjectIdentity(objectTypeId, id));
        if (null == node) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        try {
            ancestors = this.navigationService.getAncestors(node);
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ArrayList<NodeData> ancestorData = new ArrayList<NodeData>(ancestors.size());
        for (NavigationNode ancestor : ancestors) {
            ancestorData.add(new NodeData(ancestor, this.getLinksForObject(ancestor)));
        }
        return new ResponseEntity((Object)new Nodes(ancestorData), (HttpStatusCode)HttpStatus.OK);
    }

    private List<Link> getLinksForObject(NavigationNode node) {
        List<Link> lifecycleLinks;
        ObjectIdentity identity;
        String url;
        ArrayList<Link> links = new ArrayList<Link>();
        if (node instanceof ContainerNode) {
            links.add(new Link("GET", "children", "/navigation/" + node.getObjectType() + "/" + ContentRESTUtils.getIdForLink((String)node.getId()) + "/children"));
        }
        if (node.getParentId() != null) {
            links.add(new Link("GET", "parent", "/navigation/" + node.getParentId().getObjectType() + "/" + ContentRESTUtils.getIdForLink((String)node.getParentId().getId())));
            if (node.getContentObject() instanceof ContentNode) {
                ContentNode cnode = (ContentNode)node.getContentObject();
                String navPath = node.getNavigationPath();
                if (navPath != null && navPath.equals(cnode.getPath())) {
                    links.add(new Link("GET", "ancestors", "/navigation/" + node.getObjectType() + "/" + ContentRESTUtils.getIdForLink((String)node.getId()) + "/ancestors"));
                }
            }
        }
        if ((url = this.registryUtil.getRestUrl(identity = ObjectIdentityUtils.createObjectIdentity((Identifiable)node))) != null) {
            Link link = null;
            try {
                URI uri = new URI(url);
                String query = uri.getQuery();
                StringBuilder sb = new StringBuilder(1000);
                sb.append(uri.getPath());
                if (query != null) {
                    sb.append("?");
                    sb.append(query);
                }
                link = new Link("GET", "self", sb.toString(), url);
                links.add(link);
            }
            catch (URISyntaxException e) {
                link = new Link("GET", "self");
                link.setHref(url);
                links.add(link);
            }
        }
        if ((lifecycleLinks = this.generateLifecycleLinks(identity)) != null) {
            links.addAll(lifecycleLinks);
        }
        return links;
    }

    private List<Link> generateLifecycleLinks(ObjectIdentity identity) {
        ArrayList<Link> links = null;
        try {
            List operations = this.lifecycleService.getSupportedOperations(identity.getObjectType());
            if (operations != null && !operations.isEmpty()) {
                links = new ArrayList<Link>(3);
                if (operations.contains(OperationName.DELETE)) {
                    links.add(new Link("DELETE", "delete", "/content/" + ContentRESTUtils.createContentUri((ObjectIdentity)identity)));
                }
            }
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
        return links;
    }

    private ResponseEntity<?> getEmptyCollectionResponse(boolean useCollection, HttpStatus status) {
        if (useCollection) {
            return new ResponseEntity((HttpStatusCode)status);
        }
        return new ResponseEntity((HttpStatusCode)status);
    }

    private void sortItems(List<NavigationNode> list, final List<SortKey> sortKeys) {
        Collections.sort(list, new Comparator<NavigationNode>(){

            @Override
            public int compare(NavigationNode o1, NavigationNode o2) {
                int result = 0;
                for (SortKey key : sortKeys) {
                    if (o1 == null || o1.getContentObject() == null || o2 == null || o2.getContentObject() == null) {
                        return 0;
                    }
                    String str = key.getKeyName();
                    if (str.equalsIgnoreCase("description")) {
                        result = this.stringCompare(o1.getContentObject().getDescription(), o2.getContentObject().getDescription());
                    } else if (str.equalsIgnoreCase("objecttypename")) {
                        result = this.stringCompare(o1.getContentObject().getObjectTypeName(), o2.getContentObject().getObjectTypeName());
                    } else if (str.equalsIgnoreCase("modifieddate")) {
                        result = this.dateCompare(o1.getContentObject().getModifiedDate(), o2.getContentObject().getModifiedDate());
                    } else if (str.equalsIgnoreCase("name")) {
                        result = this.stringCompare(o1.getContentObject().getName(), o2.getContentObject().getName());
                    } else if (str.equalsIgnoreCase("objectid")) {
                        result = this.stringCompare(o1.getContentObject().getId(), o2.getContentObject().getId());
                    } else if (str.equalsIgnoreCase("createdby")) {
                        result = this.stringCompare(o1.getContentObject().getCreatedBy(), o2.getContentObject().getCreatedBy());
                    } else if (str.equalsIgnoreCase("objecttype")) {
                        long ot2;
                        long ot1 = o1.getContentObject().getObjectType();
                        result = ot1 == (ot2 = o2.getContentObject().getObjectType()) ? 0 : (ot1 < ot2 ? -1 : 1);
                    } else if (str.equalsIgnoreCase("modifiedby")) {
                        result = this.stringCompare(o1.getContentObject().getModifiedBy(), o2.getContentObject().getModifiedBy());
                    } else if (str.equalsIgnoreCase("creationdate")) {
                        result = this.dateCompare(o1.getContentObject().getCreationDate(), o2.getContentObject().getCreationDate());
                    }
                    if (result == 0) continue;
                    if (key.isAscending()) {
                        return result;
                    }
                    return -result;
                }
                return result;
            }

            private int stringCompare(String s1, String s2) {
                if (s1 == null || s2 == null) {
                    return 0;
                }
                return s1.compareTo(s2);
            }

            private int dateCompare(Date d1, Date d2) {
                if (d1 == null || d2 == null) {
                    return 0;
                }
                return d1.compareTo(d2);
            }
        });
    }
}

