/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.commons.rest.links.ApplicationBaseUrl;
import com.sas.svcs.config.client.ApplicationRegistration;
import com.sas.svcs.config.client.ConfigurationServiceInterface;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

public class LinkInterceptor
implements AsyncHandlerInterceptor {
    ConfigurationServiceInterface configService;

    @Autowired
    public void setConfigurationService(ConfigurationServiceInterface configService) {
        this.configService = configService;
    }

    public static String getClosestUrlForRequest(HttpServletRequest request, ApplicationRegistration registration) {
        String host = request.getServerName();
        if (host.equalsIgnoreCase(registration.getExternalHost())) {
            return registration.getExternalUrl();
        }
        return registration.getUrl();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String applicationName = request.getSession().getServletContext().getInitParameter("application-name");
        if (null != applicationName) {
            ApplicationRegistration registration = this.configService.getRegistration(applicationName);
            String url = LinkInterceptor.getClosestUrlForRequest(request, registration) + "/rest";
            ApplicationBaseUrl.setUrl((String)url);
        }
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ApplicationBaseUrl.clear();
        super.afterCompletion(request, response, handler, ex);
    }
}

