/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.common.client.ReferenceList;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.platform.di.client.Library;
import com.sas.svcs.content.platform.di.client.LibraryService;
import com.sas.svcs.content.platform.di.client.Table;
import com.sas.svcs.web.controllers.rest.content.AbstractContentLifecycleController;
import com.sas.svcs.web.controllers.rest.util.RegistryUtil;
import com.sas.svcs.web.data.dataintegration.LibraryData;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LibraryController
extends AbstractContentLifecycleController {
    private LibraryService libraryService;
    private RegistryUtil registryUtil;

    @Autowired
    public void setLibraryService(LibraryService libraryService) {
        this.libraryService = libraryService;
    }

    @Autowired
    public void setRegistryUtil(RegistryUtil registryUtil) {
        this.registryUtil = registryUtil;
    }

    @RequestMapping(value={"/content/31/{objectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<LibraryData> getLibrary(@PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        Library library = this.libraryService.getLibraryDescriptor(new ObjectIdentity(31L, id));
        if (library == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new LibraryData(library), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/31/{objectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteLibrary(@PathVariable String objectId, Locale locale) {
        return this.deleteObject(31L, objectId, locale);
    }

    @RequestMapping(value={"/content/31/{objectId}/tables"}, method={RequestMethod.GET})
    public void getTablesReference(@PathVariable String objectId, HttpServletResponse response) throws IOException {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        Library library = this.libraryService.getLibraryById(new ObjectIdentity(31L, id));
        if (library == null) {
            response.setStatus(404);
            return;
        }
        ReferenceList tablesRef = library.getTables();
        if (tablesRef.getTargetList() == null || ((ArrayList)tablesRef.getTargetList()).size() == 0) {
            response.sendError(404, "UnsetReference");
            return;
        }
        List tables = (List)tablesRef.getTargetList();
        String url = this.registryUtil.getUrlForObjectType(32L);
        if (url == null) {
            response.setStatus(404);
            return;
        }
        if (!url.endsWith("/{object-id}")) {
            response.setStatus(404);
            return;
        }
        url = url.substring(0, url.lastIndexOf("/{object-id}"));
        StringBuffer urlBuff = new StringBuffer(url + "?");
        boolean first = true;
        for (Table table : tables) {
            if (!first) {
                urlBuff.append("&id=");
            } else {
                urlBuff.append("id=");
                first = false;
            }
            urlBuff.append(ContentRESTUtils.getIdForLink((String)table.getId()));
        }
        String redirUrl = urlBuff.toString();
        response.setHeader("Location", redirUrl);
        response.setStatus(303);
    }
}

