/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.identity.client.Group;
import com.sas.svcs.identity.client.IdentityInformationService;
import com.sas.svcs.identity.client.User;
import com.sas.svcs.web.controllers.rest.util.AuthorizationUtil;
import com.sas.svcs.web.data.identity.info.GroupData;
import com.sas.svcs.web.data.identity.info.Groups;
import com.sas.svcs.web.data.identity.info.Identities;
import com.sas.svcs.web.data.identity.info.UserData;
import com.sas.svcs.web.data.identity.info.Users;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IdentityInformationController {
    private IdentityInformationService identityInfoService;

    @Autowired
    public void setIdentityInformationService(IdentityInformationService identityInfoService) {
        this.identityInfoService = identityInfoService;
    }

    @RequestMapping(value={"/users/{userId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<UserData> getUser(@PathVariable String userId) {
        if (!AuthorizationUtil.isUserIdCurrentUser(userId) && !AuthorizationUtil.isUserAuthorizedForEndpoint("identities")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        User user = this.identityInfoService.getUser(userId);
        if (null == user) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        UserData data = new UserData(user);
        return new ResponseEntity((Object)data, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/users/{userId}/groups"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Groups> getGroupsForUser(@PathVariable String userId) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("identities")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        Set results = this.identityInfoService.getGroupsForUser(userId);
        Groups groups = new Groups(results);
        return new ResponseEntity((Object)groups, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/groups/{groupId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<GroupData> getGroup(@PathVariable String groupId) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("identities")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        Group group = this.identityInfoService.getGroup(groupId);
        if (null == group) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        GroupData data = new GroupData(group);
        return new ResponseEntity((Object)data, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/groups"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Groups> getAllGroups() {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("identities")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        Set results = this.identityInfoService.getAllGroups();
        Groups groups = new Groups(results);
        return new ResponseEntity((Object)groups, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Users> getAllUsers() {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("identities")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        Set results = this.identityInfoService.getAllUsers();
        Users users = new Users(results);
        return new ResponseEntity((Object)users, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/groups"}, method={RequestMethod.GET}, params={"keyword"})
    @ResponseBody
    public ResponseEntity<Groups> searchGroups(@RequestParam(value="keyword") String keyword) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("identities")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        Set results = this.identityInfoService.searchGroups(keyword);
        Groups groups = new Groups(results);
        return new ResponseEntity((Object)groups, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.GET}, params={"keyword"})
    @ResponseBody
    public ResponseEntity<Users> searchUsers(@RequestParam(value="keyword") String keyword) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("identities")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        Set results = this.identityInfoService.searchUsers(keyword);
        Users users = new Users(results);
        return new ResponseEntity((Object)users, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/identities"}, method={RequestMethod.GET}, params={"keyword"})
    @ResponseBody
    public ResponseEntity<Identities> searchIdentities(@RequestParam(value="keyword") String keyword) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("identities")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        Set results = this.identityInfoService.searchIdentities(keyword);
        Identities identities = new Identities(results);
        return new ResponseEntity((Object)identities, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.GET}, params={"id"})
    @ResponseBody
    public ResponseEntity<Users> getUsers(@RequestParam(value="id") Set<String> userIds) {
        if (!AuthorizationUtil.isUserAuthorizedForEndpoint("identities")) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        Set results = this.identityInfoService.getUsers(userIds);
        Users users = new Users(results);
        return new ResponseEntity((Object)users, (HttpStatusCode)HttpStatus.OK);
    }
}

