/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.common.client.ObjectIdentityUtils;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.authorization.client.AuthorizationService;
import com.sas.svcs.content.authorization.client.EffectivePermissions;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectModifiedException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.resource.platform.identity.client.Identity;
import com.sas.svcs.resource.platform.identity.client.IdentityService;
import com.sas.svcs.resource.platform.identity.client.Role;
import com.sas.svcs.resource.platform.identity.client.User;
import com.sas.svcs.resource.platform.identity.client.UserGroup;
import com.sas.svcs.resource.platform.resourcebase.client.Login;
import com.sas.svcs.web.data.identity.IdentityData;
import com.sas.svcs.web.data.identity.LoginData;
import com.sas.svcs.web.data.identity.Logins;
import com.sas.svcs.web.data.identity.Members;
import com.sas.svcs.web.data.identity.Memberships;
import com.sas.svcs.web.data.identity.RoleData;
import com.sas.svcs.web.data.identity.Roles;
import com.sas.svcs.web.data.identity.UserData;
import com.sas.svcs.web.data.identity.UserGroupData;
import com.sas.svcs.web.data.identity.UserGroups;
import com.sas.svcs.web.data.identity.Users;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IdentityController {
    private IdentityService identityService;
    private AuthorizationService authorizationService;

    @Autowired
    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    @Autowired
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @RequestMapping(value={"/151"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Users> getUsers() {
        List userList = this.identityService.getAllUsers();
        ArrayList<UserData> userDataList = new ArrayList<UserData>();
        for (User user : userList) {
            userDataList.add(new UserData(user));
        }
        return new ResponseEntity((Object)new Users(userDataList), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/users/{objectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<UserData> getUserById(@PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity objId = new ObjectIdentity(151L, id);
        User user = this.identityService.getUserById(objId);
        if (user != null) {
            return new ResponseEntity((Object)new UserData(user), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<UserData> getUserByName(@RequestParam(value="name") String name) {
        User user = this.identityService.getUserByName(name);
        if (user != null) {
            return new ResponseEntity((Object)new UserData(user), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/152"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<UserGroups> getUserGroups() {
        List userGroupList = this.identityService.getAllUserGroups();
        ArrayList<UserGroupData> userGroupDataList = new ArrayList<UserGroupData>();
        for (UserGroup userGroup : userGroupList) {
            userGroupDataList.add(new UserGroupData(userGroup));
        }
        return new ResponseEntity((Object)new UserGroups(userGroupDataList), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/usergroups/{objectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<UserGroupData> getUserGroupById(@PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity objId = new ObjectIdentity(152L, id);
        UserGroup usergroup = this.identityService.getUserGroupById(objId);
        if (usergroup != null) {
            return new ResponseEntity((Object)new UserGroupData(usergroup), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/usergroups"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<UserGroupData> getUserGroupByName(@RequestParam(value="name") String name) {
        UserGroup userGroup = this.identityService.getUserGroupByName(name);
        if (userGroup != null) {
            return new ResponseEntity((Object)new UserGroupData(userGroup), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/148"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Roles> getRoles() {
        List userList = this.identityService.getAllRoles();
        ArrayList<RoleData> userDataList = new ArrayList<RoleData>();
        for (Role user : userList) {
            userDataList.add(new RoleData(user));
        }
        return new ResponseEntity((Object)new Roles(userDataList), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/roles/{objectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<RoleData> getRoleById(@PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity objId = new ObjectIdentity(148L, id);
        Role role = this.identityService.getRoleById(objId);
        if (role != null) {
            return new ResponseEntity((Object)new RoleData(role), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/roles"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<RoleData> getRoleByName(@RequestParam(value="name") String name) {
        Role role = this.identityService.getRoleByName(name);
        if (role != null) {
            return new ResponseEntity((Object)new RoleData(role), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/{objectTypeId}/{objectId}/logins"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Logins> getLoginss(@PathVariable long objectTypeId, @PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity objId = new ObjectIdentity(objectTypeId, id);
        List logins = null;
        switch ((int)objectTypeId) {
            case 152: {
                UserGroup userGroup = this.identityService.getUserGroupById(objId);
                if (userGroup == null) break;
                logins = userGroup.getLogins();
                break;
            }
            case 151: {
                User user = this.identityService.getUserById(objId);
                if (user == null) break;
                logins = user.getLogins();
                break;
            }
            default: {
                return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
        }
        ArrayList<LoginData> loginDataList = new ArrayList<LoginData>();
        if (logins == null) {
            return new ResponseEntity((Object)new Logins(loginDataList), (HttpStatusCode)HttpStatus.OK);
        }
        for (Login login : logins) {
            loginDataList.add(new LoginData(login));
        }
        return new ResponseEntity((Object)new Logins(loginDataList), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{objectTypeId}/{objectId}/members"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Members> getMembers(@PathVariable long objectTypeId, @PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity objId = new ObjectIdentity(objectTypeId, id);
        List memberIdentities = null;
        switch ((int)objectTypeId) {
            case 152: {
                UserGroup userGroup = this.identityService.getUserGroupById(objId);
                if (userGroup == null) break;
                memberIdentities = userGroup.getMembers();
                break;
            }
            case 148: {
                Role role = this.identityService.getRoleById(objId);
                if (role == null) break;
                memberIdentities = role.getMembers();
                break;
            }
            default: {
                return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
        }
        ArrayList<IdentityData> membersDataList = new ArrayList<IdentityData>();
        if (memberIdentities == null) {
            return new ResponseEntity((Object)new Members(membersDataList), (HttpStatusCode)HttpStatus.OK);
        }
        for (Identity member : memberIdentities) {
            membersDataList.add(new IdentityData(member));
        }
        return new ResponseEntity((Object)new Members(membersDataList), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{objectTypeId}/{objectId}/memberships"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Memberships> getMemberships(@PathVariable long objectTypeId, @PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity objId = new ObjectIdentity(objectTypeId, id);
        List parentIdentities = null;
        switch ((int)objectTypeId) {
            case 152: {
                UserGroup userGroup = this.identityService.getUserGroupById(objId);
                if (userGroup == null) break;
                parentIdentities = userGroup.getMemberships();
                break;
            }
            case 151: {
                User user = this.identityService.getUserById(objId);
                if (user == null) break;
                parentIdentities = user.getMemberships();
                break;
            }
            default: {
                return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
        }
        ArrayList<IdentityData> parentsDataList = new ArrayList<IdentityData>();
        if (parentIdentities == null) {
            return new ResponseEntity((Object)new Memberships(parentsDataList), (HttpStatusCode)HttpStatus.OK);
        }
        for (Identity parent : parentIdentities) {
            parentsDataList.add(new IdentityData(parent));
        }
        return new ResponseEntity((Object)new Memberships(parentsDataList), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/{objectTypeId}/{objectId}/contributing-roles"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Roles> getContributingRoles(@PathVariable long objectTypeId, @PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity objId = new ObjectIdentity(objectTypeId, id);
        List contributingRoles = null;
        switch ((int)objectTypeId) {
            case 148: {
                Role role = this.identityService.getRoleById(objId);
                if (role == null) break;
                contributingRoles = role.getContributingRoles();
                break;
            }
            default: {
                return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
        }
        ArrayList<RoleData> contributingRoleDataList = new ArrayList<RoleData>();
        if (contributingRoles == null) {
            return new ResponseEntity((Object)new Roles(contributingRoleDataList), (HttpStatusCode)HttpStatus.OK);
        }
        for (Role role : contributingRoles) {
            contributingRoleDataList.add(new RoleData(role));
        }
        return new ResponseEntity((Object)new Roles(contributingRoleDataList), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<UserData> createUser(@RequestBody UserData userData) throws ObjectExistsException {
        User newUser = this.identityService.createUser(userData.toUser());
        return new ResponseEntity((Object)new UserData(newUser), (HttpStatusCode)HttpStatus.CREATED);
    }

    @RequestMapping(value={"/usergroups"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<UserGroupData> createUserGroup(@RequestBody UserGroupData userGroupData) throws ObjectExistsException {
        UserGroup newUserGroup = this.identityService.createUserGroup(userGroupData.toUserGroup());
        return new ResponseEntity((Object)new UserGroupData(newUserGroup), (HttpStatusCode)HttpStatus.CREATED);
    }

    @RequestMapping(value={"/roles"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<RoleData> createRole(@RequestBody RoleData roleData) throws ObjectExistsException {
        Role newRole = this.identityService.createRole(roleData.toRole());
        return new ResponseEntity((Object)new RoleData(newRole), (HttpStatusCode)HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{objectTypeId}/{objectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<String> deleteIdentity(@PathVariable long objectTypeId, @PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        Identity identity = new Identity();
        identity.setObjectType(objectTypeId);
        identity.setId(id);
        try {
            EffectivePermissions permissions = this.authorizationService.getEffectivePermissions(ObjectIdentityUtils.createObjectIdentity((Identifiable)identity));
            if (permissions == null || !permissions.isDeleteAllowed()) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
            }
            this.identityService.deleteIdentity(identity);
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<UserData> updateUser(@RequestBody UserData userData) {
        User user = userData.toUser();
        try {
            user = this.identityService.updateUser(user);
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (ObjectModifiedException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_MODIFIED);
        }
        return new ResponseEntity((Object)new UserData(user), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/usergroups"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<UserGroupData> updateUserGroup(@RequestBody UserGroupData usergroupData) {
        UserGroup usergroup = usergroupData.toUserGroup();
        try {
            usergroup = this.identityService.updateUserGroup(usergroup);
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (ObjectModifiedException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_MODIFIED);
        }
        return new ResponseEntity((Object)new UserGroupData(usergroup), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/roles"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<RoleData> updateRole(@RequestBody RoleData roleData) {
        Role role = roleData.toRole();
        try {
            role = this.identityService.updateRole(role);
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (ObjectModifiedException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_MODIFIED);
        }
        return new ResponseEntity((Object)new RoleData(role), (HttpStatusCode)HttpStatus.OK);
    }
}

