/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.common.client.ObjectIdentityUtils;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.authorization.client.AuthorizationService;
import com.sas.svcs.content.authorization.client.EffectivePermissions;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.content.folder.client.Folder;
import com.sas.svcs.content.folder.client.FolderService;
import com.sas.svcs.content.framework.client.ContainerNotEmptyException;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.framework.client.ValidationException;
import com.sas.svcs.web.data.folder.FolderData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class FolderController {
    private static final String FOLDER_LIST = "28|79|29|75|105";
    private AuthorizationService authorizationService;
    private FolderService folderService;

    @Autowired
    public void setFolderService(FolderService folderService) {
        this.folderService = folderService;
    }

    @Autowired
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @RequestMapping(value={"/content/{objectTypeId:28|79|29|75|105}/{objectId}/{subfolderName}/{subfolderTypeId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<FolderData> createFolder(@PathVariable long objectTypeId, @PathVariable String objectId, @PathVariable String subfolderName, @PathVariable long subfolderTypeId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        Folder folder = this.folderService.getFolderById(new ObjectIdentity(objectTypeId, id));
        if (folder == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        try {
            folder = this.folderService.createFolder(folder, subfolderName, this.typeName(subfolderTypeId));
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (ObjectExistsException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.CONFLICT);
        }
        catch (ValidationException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)new FolderData(folder), (HttpStatusCode)HttpStatus.CREATED);
    }

    @RequestMapping(value={"/content/{objectTypeId:28|79|29|75|105}/{objectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<FolderData> getFolderById(@PathVariable long objectTypeId, @PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        Folder folder = this.folderService.getFolderById(new ObjectIdentity(objectTypeId, id));
        if (folder == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new FolderData(folder), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/{objectTypeId:28|79|29|75|105}/{objectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<FolderData> deleteFolder(@PathVariable long objectTypeId, @PathVariable String objectId) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        Folder folder = this.folderService.getFolderById(new ObjectIdentity(objectTypeId, id));
        if (folder == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        try {
            EffectivePermissions permissions = this.authorizationService.getEffectivePermissions(ObjectIdentityUtils.createObjectIdentity((Identifiable)folder));
            if (permissions == null || !permissions.isDeleteAllowed()) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
            }
            this.folderService.deleteFolder(folder);
        }
        catch (ObjectNotFoundException e) {
            return new ResponseEntity((Object)new FolderData(folder), (HttpStatusCode)HttpStatus.CONFLICT);
        }
        catch (ContainerNotEmptyException e) {
            return new ResponseEntity((Object)new FolderData(folder), (HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
        }
        return new ResponseEntity((Object)new FolderData(folder), (HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    private String typeName(long objectTypeId) {
        if (28L == objectTypeId) {
            return "Folder";
        }
        if (79L == objectTypeId) {
            return "JcrFolder";
        }
        if (29L == objectTypeId) {
            return "RootFolder";
        }
        if (75L == objectTypeId) {
            return "SystemFolder";
        }
        if (105L == objectTypeId) {
            return "RepositoryRootFolder";
        }
        return null;
    }
}

