/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.commons.rest.links.Link;
import com.sas.svcs.common.client.ReferenceList;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.client.util.ContentRESTUtils;
import com.sas.svcs.resource.platform.directory.client.DirectoryService;
import com.sas.svcs.resource.platform.file.client.FileService;
import com.sas.svcs.resource.platform.resourcebase.client.Directory;
import com.sas.svcs.resource.platform.resourcebase.client.File;
import com.sas.svcs.web.data.directory.Directories;
import com.sas.svcs.web.data.directory.DirectoryData;
import com.sas.svcs.web.data.directory.FileCollectionData;
import com.sas.svcs.web.data.directory.FileData;
import com.sas.svcs.web.data.directory.Files;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(method={RequestMethod.GET})
public class DirectoryController {
    private DirectoryService directoryService;
    private FileService fileService;

    @Autowired
    public void setDirectoryService(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    @Autowired
    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    @RequestMapping(value={"/content/51"})
    @ResponseBody
    public ResponseEntity<Directories> getDirectoriesType() {
        return this.getDirectories();
    }

    @RequestMapping(value={"/content/directories"})
    @ResponseBody
    public ResponseEntity<Directories> getDirectories() {
        List directoryList = this.directoryService.getDirectories();
        ArrayList<DirectoryData> directoryDataList = new ArrayList<DirectoryData>();
        for (Directory nextDirectory : directoryList) {
            directoryDataList.add(new DirectoryData(nextDirectory));
        }
        return new ResponseEntity((Object)new Directories(directoryDataList), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/51/{objectId}"})
    @ResponseBody
    public ResponseEntity<DirectoryData> getDirectoryType(@PathVariable String objectId) {
        return this.getDirectory(objectId);
    }

    @RequestMapping(value={"/content/directories/{objectId}"})
    @ResponseBody
    public ResponseEntity<DirectoryData> getDirectory(@PathVariable String objectId) {
        DirectoryData resultData = null;
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity identity = new ObjectIdentity(51L, id);
        Directory directory = this.directoryService.getDirectoryById(identity);
        if (directory == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        resultData = new DirectoryData(directory);
        return new ResponseEntity((Object)resultData, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/directories/{objectId}/files"})
    @ResponseBody
    public ResponseEntity<FileCollectionData> getDirectoryFiles(@PathVariable String objectId, @RequestParam(value="start", defaultValue="0", required=false) int start, @RequestParam(value="limit", defaultValue="5", required=false) int limit) {
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity identity = new ObjectIdentity(51L, id);
        Directory directory = this.directoryService.getDirectoryById(identity);
        if (directory == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        ReferenceList fileRef = directory.getFiles();
        ArrayList<FileData> dataList = new ArrayList<FileData>();
        if (fileRef == null || fileRef.getTargetList() == null || ((ArrayList)fileRef.getTargetList()).size() == 0 || start >= ((ArrayList)fileRef.getTargetList()).size()) {
            return new ResponseEntity((Object)new FileCollectionData(dataList), (HttpStatusCode)HttpStatus.OK);
        }
        ArrayList fileList = (ArrayList)fileRef.getTargetList();
        for (int index = start; index < start + limit && index < fileList.size(); ++index) {
            File nextFile = (File)fileList.get(index);
            dataList.add(new FileData(nextFile));
        }
        FileCollectionData result = new FileCollectionData(dataList);
        if (start > 0) {
            result.addLink(new Link("Get", "first", "/content/directories/" + objectId + "/files?start=0?limit=" + limit));
            int newStart = start - limit;
            if (newStart > 0) {
                result.addLink(new Link("GET", "prev", "/content/directories/" + objectId + "/files?start=" + newStart + "?limit=" + limit));
            }
        }
        if (fileList.size() > start + limit) {
            int newStart = start + limit;
            result.addLink(new Link("GET", "next", "/content/directories/" + objectId + "/files?start=" + newStart + "?limit=" + limit));
        }
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/83"})
    @ResponseBody
    public ResponseEntity<Files> getFilesType() {
        return this.getFiles();
    }

    @RequestMapping(value={"/content/files"})
    @ResponseBody
    public ResponseEntity<Files> getFiles() {
        ArrayList<FileData> fileDataList = new ArrayList<FileData>();
        List fileList = this.fileService.getFiles();
        for (File nextFile : fileList) {
            fileDataList.add(new FileData(nextFile));
        }
        return new ResponseEntity((Object)new Files(fileDataList), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/content/83/{objectId}"})
    @ResponseBody
    public ResponseEntity<FileData> getFileType(@PathVariable String objectId) {
        return this.getFile(objectId);
    }

    @RequestMapping(value={"/content/files/{objectId}"})
    @ResponseBody
    public ResponseEntity<FileData> getFile(@PathVariable String objectId) {
        FileData result = null;
        String id = ContentRESTUtils.getIdFromLink((String)objectId);
        ObjectIdentity identity = new ObjectIdentity(83L, id);
        File file = this.fileService.getFileById(identity);
        if (file == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        result = new FileData(file);
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }
}

