/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.logging.client.ContentLog;
import com.sas.svcs.content.logging.client.ContentLoggingService;
import com.sas.svcs.web.data.contentlogging.ContentLogData;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ContentLogController {
    ContentLoggingService contentLoggingService;

    @Autowired
    public void setContentLoggingService(ContentLoggingService contentLoggingService) {
        this.contentLoggingService = contentLoggingService;
    }

    @RequestMapping(value={"/content/172/{objectId}"}, method={RequestMethod.GET}, headers={"accept=application/vnd.sas.contentlog"})
    public void getContentLogContents(@PathVariable String objectId, HttpServletResponse response, @RequestParam(value="level", defaultValue="1000", required=false) int level) {
        ContentLog log = this.contentLoggingService.getContentLog(objectId);
        if (log == null) {
            response.setStatus(404);
        }
        String logContent = null;
        try {
            logContent = this.contentLoggingService.readContentLog(log, level);
        }
        catch (ObjectNotFoundException ex) {
            response.setStatus(404);
        }
        response.setContentType("application/vnd.sas.contentlog");
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(logContent.getBytes());
            outputStream.close();
        }
        catch (IOException ex) {
            response.setStatus(500);
        }
        response.setStatus(200);
    }

    @RequestMapping(value={"/content/172/{objectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ContentLogData> getContentLog(@PathVariable String objectId) {
        ContentLog log = this.contentLoggingService.getContentLog(objectId);
        if (log == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new ContentLogData(log), (HttpStatusCode)HttpStatus.OK);
    }
}

