/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.config.client.ApplicationRegistration;
import com.sas.svcs.config.client.ConfigurationServiceInterface;
import com.sas.svcs.web.data.config.ApplicationData;
import com.sas.svcs.web.data.config.Applications;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriUtils;

@Controller
public class ConfigurationController {
    ConfigurationServiceInterface configService;

    @Autowired
    public void setConfigurationService(ConfigurationServiceInterface configService) {
        this.configService = configService;
    }

    @RequestMapping(value={"/applications/{applicationName}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<ApplicationData> getApplication(@PathVariable String applicationName) throws UnsupportedEncodingException {
        applicationName = UriUtils.decode((String)applicationName, (String)"UTF-8");
        List applicationNames = this.configService.getApplicationNames();
        if (!applicationNames.contains(applicationName)) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        Properties settings = this.configService.getSettings(applicationName);
        ApplicationRegistration appRegistration = this.configService.getRegistration(applicationName);
        String appUrl = "";
        if (null != appRegistration) {
            appUrl = appRegistration.getExternalUrl();
        }
        return new ResponseEntity((Object)new ApplicationData(applicationName, settings, appUrl), (HttpStatusCode)HttpStatus.OK);
    }

    @RequestMapping(value={"/applications"}, method={RequestMethod.GET})
    @ResponseBody
    public Applications getApplications() {
        List applicationNames = this.configService.getApplicationNames();
        ArrayList<ApplicationData> applications = new ArrayList<ApplicationData>();
        for (String name : applicationNames) {
            applications.add(new ApplicationData(name));
        }
        return new Applications(applications);
    }
}

