/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.entities.GUID;
import com.sas.svcs.attachments.client.Attachment;
import com.sas.svcs.attachments.client.AttachmentServiceInterface;
import com.sas.svcs.web.data.attachments.AttachmentData;
import com.sas.svcs.web.data.attachments.Attachments;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AttachmentsController {
    private static final Logger logger = LogManager.getLogger(AttachmentsController.class);
    private boolean accessByNumericIdAllowed = !Boolean.getBoolean("_SAS_REF_BY_UUID_ONLY");
    AttachmentServiceInterface attachmentService;

    public void setAccessByNumericIdAllowed(boolean allowed) {
        this.accessByNumericIdAllowed = allowed;
    }

    @Autowired
    public void setAttachmentService(AttachmentServiceInterface attachments) {
        this.attachmentService = attachments;
    }

    private Long safeGetLongId(String id) throws ForbiddenException {
        try {
            long attachmentId = Long.parseLong(id);
            if (!this.accessByNumericIdAllowed) {
                logger.warn("The system is configured to disallow referencing attachments by numeric ID, but a caller specified a numeric ID: " + id);
                throw new ForbiddenException();
            }
            return attachmentId;
        }
        catch (NumberFormatException e) {
            logger.debug("id did not appear to be a number, assuming uuid: " + id);
            return null;
        }
    }

    private Attachment getAttachment(String id) throws ForbiddenException {
        Long attachmentId = this.safeGetLongId(id);
        return null == attachmentId ? this.attachmentService.getById(id) : this.attachmentService.getById(attachmentId.longValue());
    }

    private boolean attachmentExists(String id) throws ForbiddenException {
        Long attachmentId = this.safeGetLongId(id);
        return null == attachmentId ? this.attachmentService.exists(id) : this.attachmentService.exists(attachmentId.longValue());
    }

    private void deleteAttachment(String id) throws ForbiddenException {
        Long attachmentId = this.safeGetLongId(id);
        if (null == attachmentId) {
            this.attachmentService.delete(id);
        } else {
            this.attachmentService.delete(attachmentId.longValue());
        }
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/attachments"}, method={RequestMethod.GET})
    @ResponseBody
    public Attachments getAttachments(@PathVariable long objectTypeId, @PathVariable String objectId) {
        List attachments = this.attachmentService.find(objectTypeId, objectId);
        ArrayList<AttachmentData> results = new ArrayList<AttachmentData>();
        for (Attachment attachment : attachments) {
            results.add(new AttachmentData(attachment));
        }
        return new Attachments(results);
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/attachments/{attachmentId}/contents"}, method={RequestMethod.GET})
    public void getAttachmentContents(@PathVariable long objectTypeId, @PathVariable String objectId, @PathVariable String attachmentId, HttpServletResponse response) throws IOException {
        try {
            Attachment a = this.getAttachment(attachmentId);
            this.setContentType(a.getDocType(), response);
            this.setContentDisposition(a.getName(), response);
            IOUtils.copy((InputStream)a.getContentItem().getInputStream(), (OutputStream)response.getOutputStream());
        }
        catch (ForbiddenException e) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
        }
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/attachments"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Attachments> createAttachments(@PathVariable long objectTypeId, @PathVariable String objectId, @RequestBody Attachments attachments) {
        List<AttachmentData> attachmentDataList = attachments.getAttachmentList();
        for (AttachmentData attachmentData : attachmentDataList) {
            Attachment attachment = attachmentData.toAttachment();
            if (null == attachment.getUrl()) {
                attachment.setUrl("Attachments/" + objectTypeId + "/" + objectId + "/" + attachment.getName());
            }
            attachment.setUrl(this.getUniqueUrl(attachment));
            attachment.setObjectType(objectTypeId);
            attachment.setObjectId(objectId);
            String uuid = this.attachmentService.createAttachment(attachment);
            Attachment updatedAttachment = this.attachmentService.getById(uuid);
            attachmentData.setId(updatedAttachment.getId());
            attachmentData.setUuid(updatedAttachment.getUuid());
        }
        return new ResponseEntity((Object)new Attachments(attachmentDataList), (HttpStatusCode)HttpStatus.CREATED);
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/attachments/{attachmentId}/contents"}, method={RequestMethod.PUT})
    public ResponseEntity<?> updateAttachment(@PathVariable long objectTypeId, @PathVariable String objectId, @PathVariable String attachmentId, HttpServletRequest request) throws IOException {
        try {
            if (!this.attachmentExists(attachmentId)) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            Attachment a = this.getAttachment(attachmentId);
            ServletInputStream stream = request.getInputStream();
            a.setContents((Object)stream);
            this.attachmentService.uploadAttachment(a);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (ForbiddenException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @RequestMapping(value={"/content/{objectTypeId}/{objectId}/attachments/{attachmentId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteAttachment(@PathVariable long objectTypeId, @PathVariable String objectId, @PathVariable String attachmentId) {
        try {
            if (!this.attachmentExists(attachmentId)) {
                return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            this.deleteAttachment(attachmentId);
            return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
        }
        catch (ForbiddenException e) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    private void setContentDisposition(String name, HttpServletResponse response) {
        String contentDisposition = "inline; filename=\"" + name + "\"";
        boolean ascii = true;
        for (int idx = 0; idx < name.length(); ++idx) {
            if (CharUtils.isAscii((char)name.charAt(idx))) continue;
            ascii = false;
            break;
        }
        try {
            if (!ascii) {
                URLCodec codec = new URLCodec("utf-8");
                String encodedFileName = codec.encode(name).replace("+", "%20");
                contentDisposition = "inline; filename*=UTF-8''" + encodedFileName;
            }
        }
        catch (Exception e) {
            logger.error("Problem with trying in encode filename; using unencoded version and continuing; file name is '" + name + "'.");
        }
        response.setHeader("Content-Disposition", contentDisposition);
    }

    private void setContentType(String contentType, HttpServletResponse response) {
        if (null != contentType) {
            response.setContentType(contentType);
        } else {
            response.setContentType("application/octet-stream");
        }
    }

    private String getUniqueUrl(Attachment next) {
        String uniqueIdentifier = GUID.newGUID();
        String url = next.getUrl();
        int slashIndex = url.lastIndexOf(47);
        String filename = url.substring(slashIndex + 1);
        String path = url.substring(0, slashIndex);
        int dotIndex = filename.indexOf(46);
        if (dotIndex > 0) {
            String tempname = filename.substring(0, dotIndex);
            String extension = filename.substring(dotIndex + 1);
            filename = tempname + '_' + uniqueIdentifier + '.' + extension;
        } else {
            filename = filename + uniqueIdentifier;
        }
        return path + '/' + filename;
    }

    private static final class ForbiddenException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private ForbiddenException() {
        }
    }
}

