/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.web.controllers.rest;

import com.sas.svcs.authorization.client.Authority;
import com.sas.svcs.authorization.client.AuthorityAssignmentService;
import com.sas.svcs.authorization.client.AuthorizationPrincipal;
import com.sas.svcs.authorization.client.Role;
import com.sas.svcs.web.data.authorization.Authorities;
import com.sas.svcs.web.data.authorization.AuthorityData;
import com.sas.svcs.web.data.authorization.PrivilegeData;
import com.sas.svcs.web.data.authorization.RoleData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AssignedAuthoritiesController {
    private static final Logger logger = LogManager.getLogger(AssignedAuthoritiesController.class);
    private AuthorityAssignmentService authorityAssignmentService;

    @Autowired
    public void setAuthorityAssignmentService(AuthorityAssignmentService service) {
        this.authorityAssignmentService = service;
    }

    @RequestMapping(value={"/users/{userid}/authorities"}, method={RequestMethod.GET})
    @ResponseBody
    public Authorities getAuthorities(@PathVariable String userid) {
        AuthorizationPrincipal principal = new AuthorizationPrincipal(userid);
        Set assignedAuthorities = this.authorityAssignmentService.getAuthoritiesForPrincipal(principal);
        HashMap<String, AuthorityData> authorities = new HashMap<String, AuthorityData>(assignedAuthorities.size());
        for (Authority authority : assignedAuthorities) {
            if (authority instanceof Role) {
                authorities.put(authority.getId(), new RoleData(authority.getAuthority()));
                continue;
            }
            authorities.put(authority.getId(), new PrivilegeData(authority.getAuthority()));
        }
        return new Authorities(new ArrayList<AuthorityData>(authorities.values()));
    }

    @RequestMapping(value={"/users/{userid}/authorities"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Authorities> assignAuthorities(@PathVariable String userid, @RequestBody Authorities authorities) {
        for (AuthorityData authority : authorities.authorities) {
            if (authority instanceof RoleData) {
                this.authorityAssignmentService.assignRole(new AuthorizationPrincipal(userid), authority.name);
                continue;
            }
            logger.error("Only roles can be assigned to users. Attempted to assign privilege '" + authority.name + "' to user '" + userid + "'");
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)authorities, (HttpStatusCode)HttpStatus.CREATED);
    }
}

