/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.builder.rpm.payload;

import com.sas.tools.installs.builder.rpm.ChannelWrapper;
import com.sas.tools.installs.builder.rpm.ReadableChannelWrapper;
import com.sas.tools.installs.builder.rpm.Util;
import com.sas.tools.installs.builder.rpm.payload.CpioHeader;
import com.sas.tools.installs.builder.rpm.payload.Directive;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Contents {
    private static final Set<String> builtin = new HashSet<String>();
    private static final Set<String> docDirs = new HashSet<String>();
    private Logger logger = Logger.getLogger(Contents.class.getName());
    private int inode = 1;
    protected final Set<CpioHeader> headers = new TreeSet<CpioHeader>(new HeaderComparator());
    protected final Set<String> files = new HashSet<String>();
    protected final Map<CpioHeader, Object> sources = new HashMap<CpioHeader, Object>();

    public synchronized void addLink(String path, String target) {
        this.addLink(path, target, -1);
    }

    public synchronized void addLink(String path, String target, int permissions) {
        if (this.files.contains(path)) {
            return;
        }
        this.files.add(path);
        this.logger.log(Level.FINE, "Adding link ''{0}''.", path);
        CpioHeader header = new CpioHeader(path);
        header.setType(10);
        header.setFileSize(target.length());
        header.setMtime(System.currentTimeMillis());
        if (permissions != -1) {
            header.setPermissions(permissions);
        }
        this.headers.add(header);
        this.sources.put(header, target);
    }

    public synchronized void addDirectory(String path) {
        this.addDirectory(path, -1);
    }

    public synchronized void addDirectory(String path, Directive directive) {
        this.addDirectory(path, -1, directive, null, null);
    }

    public synchronized void addDirectory(String path, int permissions) {
        this.addDirectory(path, permissions, null, null, null);
    }

    public synchronized void addDirectory(String path, int permissions, Directive directive, String uname, String gname) {
        this.addDirectory(path, permissions, directive, uname, gname, true);
    }

    public synchronized void addDirectory(String path, int permissions, Directive directive, String uname, String gname, boolean addParents) {
        if (this.files.contains(path)) {
            return;
        }
        if (addParents) {
            this.addParents(new File(path), permissions, uname, gname);
        }
        this.files.add(path);
        this.logger.log(Level.FINE, "Adding directory ''{0}''.", path);
        CpioHeader header = new CpioHeader(path);
        header.setType(4);
        header.setInode(this.inode++);
        if (uname != null) {
            header.setUname(uname);
        }
        if (gname != null) {
            header.setGname(gname);
        }
        header.setMtime(System.currentTimeMillis());
        if (permissions != -1) {
            header.setPermissions(permissions);
        } else {
            header.setPermissions(493);
        }
        this.headers.add(header);
        this.sources.put(header, "");
        if (directive != null) {
            header.setFlags(directive.flag());
        }
    }

    public void addFile(String path, File source) throws FileNotFoundException {
        this.addFile(path, source, -1);
    }

    public void addFile(String path, File source, int permissions) throws FileNotFoundException {
        this.addFile(path, source, permissions, null, null, null);
    }

    public void addFile(String path, File source, int permissions, int dirmode) throws FileNotFoundException {
        this.addFile(path, source, permissions, null, null, null, dirmode);
    }

    public void addFile(String path, File source, int permissions, Directive directive) throws FileNotFoundException {
        this.addFile(path, source, permissions, null, null, null);
    }

    public void addFile(String path, File source, int permissions, Directive directive, String uname, String gname) throws FileNotFoundException {
        this.addFile(path, source, permissions, directive, uname, gname, -1);
    }

    public synchronized void addFile(String path, File source, int permissions, Directive directive, String uname, String gname, int dirmode) throws FileNotFoundException {
        if (this.files.contains(path)) {
            return;
        }
        this.addParents(new File(path), dirmode, uname, gname);
        this.files.add(path);
        this.logger.log(Level.FINE, "Adding file ''{0}''.", path);
        CpioHeader header = new CpioHeader(path, source);
        header.setType(8);
        header.setInode(this.inode++);
        if (uname != null) {
            header.setUname(uname);
        }
        if (gname != null) {
            header.setGname(gname);
        }
        if (permissions != -1) {
            header.setPermissions(permissions);
        }
        this.headers.add(header);
        this.sources.put(header, source);
        if (directive != null) {
            header.setFlags(directive.flag());
        }
    }

    public synchronized void addURL(String path, URL source, int permissions, Directive directive, String uname, String gname, int dirmode) throws FileNotFoundException {
        if (this.files.contains(path)) {
            return;
        }
        this.addParents(new File(path), dirmode, uname, gname);
        this.files.add(path);
        this.logger.log(Level.FINE, "Adding file ''{0}''.", path);
        CpioHeader header = new CpioHeader(path, source);
        header.setType(8);
        header.setInode(this.inode++);
        if (uname != null) {
            header.setUname(uname);
        }
        if (gname != null) {
            header.setGname(gname);
        }
        if (permissions != -1) {
            header.setPermissions(permissions);
        }
        this.headers.add(header);
        this.sources.put(header, source);
        if (directive != null) {
            header.setFlags(directive.flag());
        }
    }

    protected synchronized void addParents(File file, int permissions, String uname, String gname) {
        ArrayList<String> parents = new ArrayList<String>();
        Contents.listParents(parents, file);
        for (String parent : parents) {
            this.addDirectory(parent, permissions, null, uname, gname);
        }
    }

    public int size() {
        return this.headers.size();
    }

    public Iterable<CpioHeader> headers() {
        return this.headers;
    }

    public Object getSource(CpioHeader header) {
        return this.sources.get(header);
    }

    public int getTotalSize() {
        int total = 0;
        try {
            for (Object object : this.sources.values()) {
                if (object instanceof File) {
                    total = (int)((long)total + ((File)object).length());
                    continue;
                }
                if (!(object instanceof URL)) continue;
                total += ((URL)object).openConnection().getContentLength();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return total;
    }

    public String[] getDirNames() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (CpioHeader header : this.headers) {
            String path = new File(header.getName()).getParent();
            if (path == null) continue;
            String parent = Util.normalizePath(path);
            if (!parent.endsWith("/")) {
                parent = parent + "/";
            }
            set.add(parent);
        }
        return set.toArray(new String[set.size()]);
    }

    public int[] getDirIndexes() {
        List<String> dirs = Arrays.asList(this.getDirNames());
        int[] array = new int[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            String path = new File(header.getName()).getParent();
            if (path == null) continue;
            String parent = Util.normalizePath(path);
            if (!parent.endsWith("/")) {
                parent = parent + "/";
            }
            array[x++] = dirs.indexOf(parent);
        }
        return array;
    }

    public String[] getBaseNames() {
        String[] array = new String[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = Util.normalizePath(new File(header.getName()).getName());
        }
        return array;
    }

    public int[] getSizes() {
        int[] array = new int[this.headers.size()];
        int x = 0;
        try {
            for (CpioHeader header : this.headers) {
                Object object = this.sources.get(header);
                if (object instanceof File) {
                    array[x] = (int)((File)object).length();
                } else if (object instanceof URL) {
                    array[x] = ((URL)object).openConnection().getContentLength();
                } else if (header.getType() == 4) {
                    array[x] = 4096;
                }
                ++x;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return array;
    }

    public short[] getModes() {
        short[] array = new short[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = (short)header.getMode();
        }
        return array;
    }

    public short[] getRdevs() {
        short[] array = new short[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = (short)((header.getRdevMajor() << 8) + header.getRdevMinor());
        }
        return array;
    }

    public int[] getMtimes() {
        int[] array = new int[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = header.getMtime();
        }
        return array;
    }

    public String[] getMD5s() throws FileNotFoundException, NoSuchAlgorithmException, IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        String[] array = new String[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            ChannelWrapper.Key<byte[]> key;
            ReadableChannelWrapper input;
            Object object = this.sources.get(header);
            String value = "";
            if (object instanceof File) {
                input = new ReadableChannelWrapper(new FileInputStream((File)object).getChannel());
                key = input.start("MD5");
                while (input.read(buffer) != -1) {
                    buffer.rewind();
                }
                value = new String(Util.hex(input.finish(key)));
                input.close();
            } else if (object instanceof URL) {
                input = new ReadableChannelWrapper(Channels.newChannel(((URL)object).openConnection().getInputStream()));
                key = input.start("MD5");
                while (input.read(buffer) != -1) {
                    buffer.rewind();
                }
                value = new String(Util.hex(input.finish(key)));
                input.close();
            }
            array[x++] = value;
        }
        return array;
    }

    public String[] getLinkTos() {
        String[] array = new String[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            Object object = this.sources.get(header);
            String value = "";
            if (object instanceof String) {
                value = String.valueOf(object);
            }
            array[x++] = value;
        }
        return array;
    }

    public int[] getFlags() {
        int[] array = new int[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = header.getFlags();
        }
        return array;
    }

    public String[] getUsers() {
        String[] array = new String[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = header.getUname() == null ? "root" : header.getUname();
        }
        return array;
    }

    public String[] getGroups() {
        String[] array = new String[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = header.getGname() == null ? "root" : header.getGname();
        }
        return array;
    }

    public int[] getColors() {
        return new int[this.headers.size()];
    }

    public int[] getVerifyFlags() {
        int[] array = new int[this.headers.size()];
        Arrays.fill(array, -1);
        return array;
    }

    public int[] getClasses() {
        int[] array = new int[this.headers.size()];
        Arrays.fill(array, 1);
        return array;
    }

    public int[] getDevices() {
        int[] array = new int[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = (header.getDevMajor() << 8) + header.getDevMinor();
        }
        return array;
    }

    public int[] getInodes() {
        int[] array = new int[this.headers.size()];
        int x = 0;
        for (CpioHeader header : this.headers) {
            array[x++] = header.getInode();
        }
        return array;
    }

    public String[] getLangs() {
        Object[] array = new String[this.headers.size()];
        Arrays.fill(array, "");
        return array;
    }

    public int[] getDependsX() {
        return new int[this.headers.size()];
    }

    public int[] getDependsN() {
        return new int[this.headers.size()];
    }

    public String[] getContexts() {
        Object[] array = new String[this.headers.size()];
        Arrays.fill(array, "<<none>>");
        return array;
    }

    protected static void listParents(List<String> parents, File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return;
        }
        String path = Util.normalizePath(parent.getPath());
        if (builtin.contains(path)) {
            return;
        }
        parents.add(path);
        Contents.listParents(parents, parent);
    }

    static {
        builtin.add("/");
        builtin.add("/bin");
        builtin.add("/dev");
        builtin.add("/etc");
        builtin.add("/etc/cron.d");
        builtin.add("/etc/cron.daily");
        builtin.add("/etc/cron.hourly");
        builtin.add("/etc/cron.monthly");
        builtin.add("/etc/cron.weekly");
        builtin.add("/etc/default");
        builtin.add("/etc/init.d");
        builtin.add("/etc/logrotate.d");
        builtin.add("/lib");
        builtin.add("/usr");
        builtin.add("/usr/bin");
        builtin.add("/usr/lib");
        builtin.add("/usr/local");
        builtin.add("/usr/local/bin");
        builtin.add("/usr/local/lib");
        builtin.add("/usr/sbin");
        builtin.add("/usr/share");
        builtin.add("/usr/share/applications");
        builtin.add("/sbin");
        builtin.add("/opt");
        builtin.add("/tmp");
        builtin.add("/var");
        builtin.add("/var/log");
        docDirs.add("/usr/doc");
        docDirs.add("/usr/man");
        docDirs.add("/usr/X11R6/man");
        docDirs.add("/usr/share/doc");
        docDirs.add("/usr/share/man");
        docDirs.add("/usr/share/info");
    }

    private static class HeaderComparator
    implements Comparator<CpioHeader> {
        private HeaderComparator() {
        }

        @Override
        public int compare(CpioHeader one, CpioHeader two) {
            return one.getName().compareTo(two.getName());
        }

        public boolean equals(CpioHeader one, CpioHeader two) {
            return one.getName().equals(two.getName());
        }
    }
}

