/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.builder.rpm;

import com.sas.tools.installs.builder.rpm.ChannelWrapper;
import com.sas.tools.installs.builder.rpm.ReadableChannelWrapper;
import com.sas.tools.installs.builder.rpm.header.Format;
import com.sas.tools.installs.builder.rpm.header.Header;
import com.sas.tools.installs.builder.rpm.header.Signature;
import com.sas.tools.installs.builder.rpm.payload.CpioHeader;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.zip.GZIPInputStream;

public class Scanner {
    public static void main(String[] args) throws Exception {
        CpioHeader header;
        ReadableChannelWrapper in = new ReadableChannelWrapper(Channels.newChannel(System.in));
        Format format = new Scanner().run(in);
        System.out.println(format);
        GZIPInputStream uncompressed = new GZIPInputStream(System.in);
        in = new ReadableChannelWrapper(Channels.newChannel(uncompressed));
        int total = 0;
        do {
            header = new CpioHeader();
            total = header.read(in, total);
            System.out.println(header);
            int skip = header.getFileSize();
            if (((InputStream)uncompressed).skip(skip) != (long)skip) {
                throw new RuntimeException("Skip failed.");
            }
            total += header.getFileSize();
        } while (!header.isLast());
    }

    public Format run(ReadableChannelWrapper in) throws Exception {
        Format format = new Format();
        ChannelWrapper.Key<Integer> lead = in.start();
        format.getLead().read(in);
        System.out.println("Lead ended at '" + in.finish(lead) + "'.");
        ChannelWrapper.Key<Integer> signature = in.start();
        int count = format.getSignature().read(in);
        int expected = ByteBuffer.wrap((byte[])format.getSignature().getEntry(Signature.SignatureTag.SIGNATURES).getValues(), 8, 4).getInt() / -16;
        System.out.println("Signature ended at '" + in.finish(signature) + "' and contained '" + count + "' headers (expected '" + expected + "').");
        ChannelWrapper.Key<Integer> header = in.start();
        count = format.getHeader().read(in);
        expected = ByteBuffer.wrap((byte[])format.getHeader().getEntry(Header.HeaderTag.HEADERIMMUTABLE).getValues(), 8, 4).getInt() / -16;
        System.out.println("Header ended at '" + in.finish(header) + " and contained '" + count + "' headers (expected '" + expected + "').");
        return format;
    }
}

