/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.builder.rpm;

import com.sas.tools.installs.builder.rpm.Builder;
import com.sas.tools.installs.builder.rpm.XmlEditor;
import com.sas.tools.installs.builder.rpm.header.Architecture;
import com.sas.tools.installs.builder.rpm.header.Os;
import com.sas.tools.installs.builder.rpm.header.RpmType;
import com.sas.tools.installs.builder.rpm.payload.Contents;
import com.sas.tools.installs.builder.rpm.payload.Directive;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Main {
    public static void main(String[] args) throws SAXException, NoSuchAlgorithmException, IOException {
        if (args.length != 6) {
            System.out.println("Usage: java Main <config> <[destination preinstall-script postinstall-script preuninstall-script postuninstall-script]>");
        } else {
            new Main().run(new File(args[0]), args[1], args[2], args[3], args[4], args[5]);
        }
    }

    public void run(File file, String destination) throws SAXException, NoSuchAlgorithmException, IOException {
        XmlEditor editor = new XmlEditor();
        editor.read(file);
        this.run(editor, new File(destination), null, null, null, null);
    }

    public void run(File file, String destination, String prein, String postin, String preun, String postun) throws SAXException, NoSuchAlgorithmException, IOException {
        XmlEditor editor = new XmlEditor();
        editor.read(file);
        this.run(editor, new File(destination), prein, postin, preun, postun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(XmlEditor editor, File destination, String prein, String postin, String preun, String postun) throws NoSuchAlgorithmException, IOException {
        editor.startPrefixMapping("http://www.freecompany.org/namespace/redline", "rpm");
        Contents include = new Contents();
        for (Node files : editor.findNodes("rpm:files")) {
            try {
                editor.pushContext(files);
                int permission = editor.getInteger("@permission", 420);
                String parent = editor.getValue("@parent");
                if (!parent.endsWith("/")) {
                    parent = parent + "/";
                }
                for (Node file : editor.findNodes("rpm:file")) {
                    try {
                        editor.pushContext(file);
                        File source = new File(editor.getValue("text()"));
                        include.addFile(new File(parent, source.getName()).getPath(), source, editor.getInteger("@permission", permission), Directive.NONE, editor.getValue("@owner"), editor.getValue("@group"));
                    }
                    finally {
                        editor.popContext();
                    }
                }
            }
            finally {
                editor.popContext();
            }
        }
        this.run(editor, editor.getValue("rpm:name/text()"), editor.getValue("rpm:version/text()"), editor.getValue("rpm:release/text()", "1"), include, destination, prein, postin, preun, postun);
    }

    public void run(XmlEditor editor, String name, String version, String release, Contents include, File destination, String prein, String postin, String preun, String postun) throws NoSuchAlgorithmException, IOException {
        Builder builder = new Builder();
        builder.setPackage(name, version, release);
        RpmType type = RpmType.valueOf(editor.getValue("rpm:type", RpmType.BINARY.toString()));
        builder.setType(type);
        Architecture arch = Architecture.valueOf(editor.getValue("rpm:architecture/text()", Architecture.NOARCH.toString()));
        Os os = Os.valueOf(editor.getValue("rpm:os", Os.LINUX.toString()));
        builder.setPlatform(arch, os);
        String prefixi = editor.getValue("rpm:prefix/text()", null);
        if (prefixi != null) {
            builder.setPrefixes(prefixi);
        }
        builder.setSummary(editor.getValue("rpm:summary/text()"));
        builder.setDescription(editor.getValue("rpm:description/text()"));
        builder.setBuildHost(editor.getValue("rpm:host/text()", InetAddress.getLocalHost().getHostName()));
        builder.setLicense(editor.getValue("rpm:license/text()"));
        builder.setGroup(editor.getValue("rpm:group/text()"));
        builder.setPackager(editor.getValue("rpm:packager/text()", System.getProperty("user.name")));
        builder.setVendor(editor.getValue("rpm:vendor/text()", null));
        builder.setUrl(editor.getValue("rpm:url/text()", null));
        builder.setProvides(editor.getValue("rpm:provides/text()", name));
        builder.setFiles(include);
        builder.setPreInstallScript(new File(prein));
        builder.setPostInstallScript(new File(postin));
        builder.setPreUninstallScript(new File(preun));
        builder.setPostUninstallScript(new File(postun));
        builder.build(destination);
    }
}

