/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.builder.rpm;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.HashMap;
import java.util.Map;

public abstract class ChannelWrapper {
    protected Map<Key<?>, Consumer<?>> consumers = new HashMap();

    public Key<Integer> start(final WritableByteChannel output) {
        Key<Integer> object = new Key<Integer>();
        this.consumers.put(object, new Consumer<Integer>(){
            int count;

            @Override
            public void consume(ByteBuffer buffer) {
                try {
                    this.count += output.write(buffer);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Integer finish() {
                return this.count;
            }
        });
        return object;
    }

    public Key<Integer> start() {
        Key<Integer> object = new Key<Integer>();
        this.consumers.put(object, new Consumer<Integer>(){
            int count;

            @Override
            public void consume(ByteBuffer buffer) {
                this.count += buffer.remaining();
            }

            @Override
            public Integer finish() {
                return this.count;
            }
        });
        return object;
    }

    public Key<byte[]> start(PrivateKey key) throws NoSuchAlgorithmException, InvalidKeyException {
        final Signature signature = Signature.getInstance(key.getAlgorithm());
        signature.initSign(key);
        Key<byte[]> object = new Key<byte[]>();
        this.consumers.put(object, new Consumer<byte[]>(){

            @Override
            public void consume(ByteBuffer buffer) {
                try {
                    signature.update(buffer);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public byte[] finish() {
                try {
                    return signature.sign();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return object;
    }

    public Key<byte[]> start(String algorithm) throws NoSuchAlgorithmException {
        final MessageDigest digest = MessageDigest.getInstance(algorithm);
        Key<byte[]> object = new Key<byte[]>();
        this.consumers.put(object, new Consumer(){

            @Override
            public void consume(ByteBuffer buffer) {
                try {
                    digest.update(buffer);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public byte[] finish() {
                try {
                    return digest.digest();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return object;
    }

    public <T> T finish(Key<T> object) {
        return (T)this.consumers.remove(object).finish();
    }

    public void close() throws IOException {
        if (!this.consumers.isEmpty()) {
            throw new IOException("There are '" + this.consumers.size() + "' unfinished operations.");
        }
    }

    public static class Key<T> {
    }

    protected static interface Consumer<T> {
        public void consume(ByteBuffer var1);

        public T finish();
    }
}

