/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.resultsetviewing.util;

import com.sas.svcs.resultsetviewing.types.ColumnMetadataHeaderType;
import java.math.BigInteger;

public class CellInfo {
    private ColumnMetadataHeaderType _columnMetadata;
    private Object _rawContent;
    private String _formattedContent;
    private String _missing;

    public void setColumnMetadata(ColumnMetadataHeaderType columnMetadata) {
        this._columnMetadata = columnMetadata;
    }

    public ColumnMetadataHeaderType getColumnMetadata() {
        return this._columnMetadata;
    }

    public void setRawContent(Object rawContent) {
        this._rawContent = rawContent;
    }

    public Object getRawContent() {
        return this._rawContent;
    }

    public void setFormattedContent(String formattedContent) {
        this._formattedContent = formattedContent;
    }

    public String getFormattedContent() {
        return this._formattedContent;
    }

    public void setMissing(String missing) {
        this._missing = missing;
    }

    public String getMissing() {
        return this._missing;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!this.getClass().equals(that.getClass())) {
            return false;
        }
        CellInfo thatCell = (CellInfo)that;
        ColumnMetadataHeaderType thatColumnMetadata = thatCell.getColumnMetadata();
        if (!CellInfo.columnMetadataEquals(this._columnMetadata, thatColumnMetadata)) {
            return false;
        }
        Object thatRawContent = thatCell.getRawContent();
        if (!CellInfo.nullAwareEquals(this._rawContent, thatRawContent)) {
            return false;
        }
        String thatFormattedContent = thatCell.getFormattedContent();
        if (!CellInfo.nullAwareEquals(this._formattedContent, thatFormattedContent)) {
            return false;
        }
        String thatMissing = thatCell.getMissing();
        return CellInfo.nullAwareEquals(this._missing, thatMissing);
    }

    public int hashCode() {
        int hc = this.getClass().hashCode() + 1;
        hc ^= CellInfo.columnMetadataHashCode(this._columnMetadata);
        hc ^= CellInfo.nullAwareHashCode(this._rawContent);
        hc ^= CellInfo.nullAwareHashCode(this._formattedContent);
        return hc ^= CellInfo.nullAwareHashCode(this._missing);
    }

    private static boolean columnMetadataEquals(ColumnMetadataHeaderType columnMetadata1, ColumnMetadataHeaderType columnMetadata2) {
        String columnName2;
        BigInteger columnType2;
        BigInteger columnNumber2;
        BigInteger ccv2;
        if (columnMetadata1 == columnMetadata2) {
            return true;
        }
        if (columnMetadata1 == null || columnMetadata2 == null) {
            return false;
        }
        BigInteger ccv1 = columnMetadata1.getCellContentVersion();
        if (!CellInfo.nullAwareEquals(ccv1, ccv2 = columnMetadata2.getCellContentVersion())) {
            return false;
        }
        BigInteger columnNumber1 = columnMetadata1.getColumnNumber();
        if (!CellInfo.nullAwareEquals(columnNumber1, columnNumber2 = columnMetadata2.getColumnNumber())) {
            return false;
        }
        BigInteger columnType1 = columnMetadata1.getColumnType();
        if (!CellInfo.nullAwareEquals(columnType1, columnType2 = columnMetadata2.getColumnType())) {
            return false;
        }
        String columnName1 = columnMetadata1.getColumnName();
        return CellInfo.nullAwareEquals(columnName1, columnName2 = columnMetadata2.getColumnName());
    }

    private static int columnMetadataHashCode(ColumnMetadataHeaderType columnMetadata) {
        if (columnMetadata == null) {
            return 0;
        }
        int hc = columnMetadata.getClass().hashCode() + 1;
        BigInteger ccv = columnMetadata.getCellContentVersion();
        hc ^= CellInfo.nullAwareHashCode(ccv);
        BigInteger columnNumber = columnMetadata.getColumnNumber();
        hc ^= CellInfo.nullAwareHashCode(columnNumber);
        BigInteger columnType = columnMetadata.getColumnType();
        hc ^= CellInfo.nullAwareHashCode(columnType);
        String columnName = columnMetadata.getColumnName();
        return hc ^= CellInfo.nullAwareHashCode(columnName);
    }

    private static boolean nullAwareEquals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    private static int nullAwareHashCode(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

