/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.resultsetviewing.client;

import com.sas.framework.annotation.services.DeletesStateful;
import com.sas.framework.annotation.services.Publishable;
import com.sas.framework.annotation.services.Stateful;
import com.sas.svcs.resultsetviewing.client.IllegalArgumentExceptionHolder;
import com.sas.svcs.resultsetviewing.client.ResultSetViewingServiceExceptionHolder;
import com.sas.svcs.resultsetviewing.types.DataSourceType;
import com.sas.svcs.resultsetviewing.types.DatabaseMetadataType;
import com.sas.svcs.resultsetviewing.types.DoubleAnnotationType;
import com.sas.svcs.resultsetviewing.types.ResultSetMetadataType;
import com.sas.svcs.resultsetviewing.types.ResultSetViewType;
import com.sas.svcs.resultsetviewing.types.SortByColumnType;
import com.sas.svcs.resultsetviewing.types.WarningListType;
import java.math.BigInteger;

@Publishable
@Stateful
public interface ResultSetViewerInterface {
    public DataSourceType getDataSource();

    public DatabaseMetadataType getDatabaseMetadata() throws ResultSetViewingServiceExceptionHolder;

    public String getQuery();

    public ResultSetMetadataType getResultSetMetadata() throws ResultSetViewingServiceExceptionHolder;

    public String getStringAnnotation(BigInteger var1, String var2) throws ResultSetViewingServiceExceptionHolder;

    public DoubleAnnotationType getDoubleAnnotation(BigInteger var1, String var2) throws ResultSetViewingServiceExceptionHolder;

    public ResultSetViewType getAnnotations(BigInteger var1) throws ResultSetViewingServiceExceptionHolder;

    public BigInteger getAnnotationType(BigInteger var1, String var2) throws ResultSetViewingServiceExceptionHolder;

    public boolean hasAnnotation(BigInteger var1, String var2) throws ResultSetViewingServiceExceptionHolder;

    public boolean hasAnnotations(BigInteger var1) throws ResultSetViewingServiceExceptionHolder;

    public void setCellContentVersion(BigInteger var1);

    public BigInteger getCellContentVersion();

    public void setViewSize(BigInteger var1) throws IllegalArgumentExceptionHolder;

    public BigInteger getViewSize();

    public void setViewByRow(boolean var1);

    public boolean isViewByRow();

    public void setViewByColumn(boolean var1);

    public boolean isViewByColumn();

    public BigInteger getResultSetRowCount() throws ResultSetViewingServiceExceptionHolder;

    public ResultSetViewType viewAbsolute(BigInteger var1) throws ResultSetViewingServiceExceptionHolder, IllegalArgumentExceptionHolder;

    public ResultSetViewType viewNext() throws ResultSetViewingServiceExceptionHolder;

    public ResultSetViewType viewPrevious() throws ResultSetViewingServiceExceptionHolder;

    public ResultSetViewType getCurrentView();

    public ResultSetViewType sortView(ResultSetViewType var1, SortByColumnType var2) throws IllegalArgumentExceptionHolder;

    public void beforeFirst() throws ResultSetViewingServiceExceptionHolder;

    public void afterLast() throws ResultSetViewingServiceExceptionHolder;

    public boolean isBeforeFirst();

    public boolean isAfterLast();

    public WarningListType getWarnings() throws ResultSetViewingServiceExceptionHolder;

    public void clearWarnings() throws ResultSetViewingServiceExceptionHolder;

    @DeletesStateful
    public String store(BigInteger var1) throws ResultSetViewingServiceExceptionHolder;

    @DeletesStateful
    public void close() throws ResultSetViewingServiceExceptionHolder;
}

