/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.store;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.log.LogAccessor;
import org.springframework.core.log.LogMessage;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.integration.jdbc.store.channel.ChannelMessageStorePreparedStatementSetter;
import org.springframework.integration.jdbc.store.channel.ChannelMessageStoreQueryProvider;
import org.springframework.integration.jdbc.store.channel.MessageRowMapper;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupFactory;
import org.springframework.integration.store.PriorityCapableChannelMessageStore;
import org.springframework.integration.store.SimpleMessageGroupFactory;
import org.springframework.integration.support.converter.AllowListDeserializingConverter;
import org.springframework.integration.util.UUIDConverter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ManagedResource
public class JdbcChannelMessageStore
implements PriorityCapableChannelMessageStore,
InitializingBean,
SmartLifecycle {
    private static final LogAccessor LOGGER = new LogAccessor(JdbcChannelMessageStore.class);
    public static final String DEFAULT_REGION = "DEFAULT";
    public static final String DEFAULT_TABLE_PREFIX = "INT_";
    private final Map<Query, String> queryCache = new ConcurrentHashMap<Query, String>();
    private final Set<String> idCache = new HashSet<String>();
    private final ReadWriteLock idCacheLock = new ReentrantReadWriteLock();
    private final Lock idCacheReadLock = this.idCacheLock.readLock();
    private final Lock idCacheWriteLock = this.idCacheLock.writeLock();
    private final AtomicBoolean started = new AtomicBoolean();
    private ChannelMessageStoreQueryProvider channelMessageStoreQueryProvider;
    private String region = "DEFAULT";
    private String tablePrefix = "INT_";
    private JdbcTemplate jdbcTemplate;
    private AllowListDeserializingConverter deserializer;
    private SerializingConverter serializer;
    private LobHandler lobHandler = new DefaultLobHandler();
    private MessageRowMapper messageRowMapper;
    private ChannelMessageStorePreparedStatementSetter preparedStatementSetter;
    private MessageGroupFactory messageGroupFactory = new SimpleMessageGroupFactory();
    private boolean usingIdCache = false;
    private boolean priorityEnabled;
    private boolean checkDatabaseOnStart = true;

    public JdbcChannelMessageStore() {
        this.deserializer = new AllowListDeserializingConverter();
        this.serializer = new SerializingConverter();
    }

    public JdbcChannelMessageStore(DataSource dataSource) {
        this();
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.jdbcTemplate.setFetchSize(1);
        this.jdbcTemplate.setMaxRows(1);
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.jdbcTemplate.setFetchSize(1);
        this.jdbcTemplate.setMaxRows(1);
    }

    public void setDeserializer(Deserializer<? extends Message<?>> deserializer) {
        this.deserializer = new AllowListDeserializingConverter(deserializer);
    }

    public void addAllowedPatterns(String ... patterns) {
        this.deserializer.addAllowedPatterns(patterns);
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        Assert.notNull((Object)jdbcTemplate, (String)"The provided jdbcTemplate must not be null.");
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setLobHandler(LobHandler lobHandler) {
        Assert.notNull((Object)lobHandler, (String)"The provided LobHandler must not be null.");
        this.lobHandler = lobHandler;
    }

    public void setMessageRowMapper(MessageRowMapper messageRowMapper) {
        Assert.notNull((Object)messageRowMapper, (String)"The provided MessageRowMapper must not be null.");
        this.messageRowMapper = messageRowMapper;
    }

    public void setPreparedStatementSetter(ChannelMessageStorePreparedStatementSetter preparedStatementSetter) {
        Assert.notNull((Object)preparedStatementSetter, (String)"The provided ChannelMessageStorePreparedStatementSetter must not be null.");
        this.preparedStatementSetter = preparedStatementSetter;
    }

    public void setChannelMessageStoreQueryProvider(ChannelMessageStoreQueryProvider channelMessageStoreQueryProvider) {
        Assert.notNull((Object)channelMessageStoreQueryProvider, (String)"The provided channelMessageStoreQueryProvider must not be null.");
        this.channelMessageStoreQueryProvider = channelMessageStoreQueryProvider;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public void setSerializer(Serializer<? super Message<?>> serializer) {
        Assert.notNull(serializer, (String)"The provided serializer must not be null.");
        this.serializer = new SerializingConverter(serializer);
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setUsingIdCache(boolean usingIdCache) {
        this.usingIdCache = usingIdCache;
    }

    public void setPriorityEnabled(boolean priorityEnabled) {
        this.priorityEnabled = priorityEnabled;
    }

    public boolean isPriorityEnabled() {
        return this.priorityEnabled;
    }

    public void setMessageGroupFactory(MessageGroupFactory messageGroupFactory) {
        Assert.notNull((Object)messageGroupFactory, (String)"'messageGroupFactory' must not be null");
        this.messageGroupFactory = messageGroupFactory;
    }

    protected MessageGroupFactory getMessageGroupFactory() {
        return this.messageGroupFactory;
    }

    public void afterPropertiesSet() {
        Assert.state((this.jdbcTemplate != null ? 1 : 0) != 0, (String)"A DataSource or JdbcTemplate must be provided");
        Assert.notNull((Object)this.channelMessageStoreQueryProvider, (String)"A channelMessageStoreQueryProvider must be provided.");
        if (this.messageRowMapper == null) {
            this.messageRowMapper = new MessageRowMapper(this.deserializer, this.lobHandler);
        }
        if (this.jdbcTemplate.getFetchSize() != 1) {
            LOGGER.warn((CharSequence)"The jdbcTemplate's fetch size is not 1. This may cause FIFO issues with Oracle databases.");
        }
        if (this.preparedStatementSetter == null) {
            this.preparedStatementSetter = new ChannelMessageStorePreparedStatementSetter(this.serializer, this.lobHandler);
        }
        this.jdbcTemplate.afterPropertiesSet();
    }

    public void setCheckDatabaseOnStart(boolean checkDatabaseOnStart) {
        this.checkDatabaseOnStart = checkDatabaseOnStart;
        if (!checkDatabaseOnStart) {
            LOGGER.info((CharSequence)"The 'DefaultLockRepository' won't be started automatically and required table is not going be checked.");
        }
    }

    public boolean isAutoStartup() {
        return this.checkDatabaseOnStart;
    }

    public void start() {
        if (this.started.compareAndSet(false, true) && this.checkDatabaseOnStart) {
            this.getMessageGroupCount();
        }
    }

    public void stop() {
        this.started.set(false);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public MessageGroup addMessageToGroup(Object groupId, Message<?> message) {
        try {
            this.jdbcTemplate.update(this.getQuery(Query.CREATE_MESSAGE, () -> this.channelMessageStoreQueryProvider.getCreateMessageQuery()), ps -> this.preparedStatementSetter.setValues(ps, message, groupId, this.region, this.priorityEnabled));
        }
        catch (DataIntegrityViolationException ex) {
            LOGGER.debug(() -> "The Message with id [" + this.getKey(message.getHeaders().getId()) + "] already exists.\nIgnoring INSERT...");
        }
        return this.getMessageGroup(groupId);
    }

    private String getKey(Object input) {
        return input == null ? null : UUIDConverter.getUUID((Object)input).toString();
    }

    public MessageGroup getMessageGroup(Object groupId) {
        return this.getMessageGroupFactory().create(groupId);
    }

    @ManagedAttribute
    public int getMessageGroupCount() {
        return (Integer)this.jdbcTemplate.queryForObject(this.getQuery(Query.COUNT_GROUPS, () -> "SELECT COUNT(DISTINCT GROUP_KEY) from %PREFIX%CHANNEL_MESSAGE where REGION = ?"), Integer.class, new Object[]{this.region});
    }

    protected String getQuery(Query queryName, Supplier<String> queryProvider) {
        return this.queryCache.computeIfAbsent(queryName, k -> StringUtils.replace((String)((String)queryProvider.get()), (String)"%PREFIX%", (String)this.tablePrefix));
    }

    @ManagedAttribute
    public int messageGroupSize(Object groupId) {
        String key = this.getKey(groupId);
        return (Integer)this.jdbcTemplate.queryForObject(this.getQuery(Query.GROUP_SIZE, () -> this.channelMessageStoreQueryProvider.getCountAllMessagesInGroupQuery()), Integer.class, new Object[]{key, this.region});
    }

    public void removeMessageGroup(Object groupId) {
        this.jdbcTemplate.update(this.getQuery(Query.DELETE_GROUP, () -> this.channelMessageStoreQueryProvider.getDeleteMessageGroupQuery()), new Object[]{this.getKey(groupId), this.region});
    }

    public Message<?> pollMessageFromGroup(Object groupId) {
        String key = this.getKey(groupId);
        Message<?> polledMessage = this.doPollForMessage(key);
        if (polledMessage != null && !this.isSingleStatementForPoll() && !this.doRemoveMessageFromGroup(groupId, polledMessage)) {
            return null;
        }
        return polledMessage;
    }

    private boolean isSingleStatementForPoll() {
        return this.channelMessageStoreQueryProvider.isSingleStatementForPoll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message<?> doPollForMessage(String groupIdKey) {
        List messages;
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("region", (Object)this.region);
        parameters.addValue("group_key", (Object)groupIdKey);
        this.idCacheReadLock.lock();
        try {
            String query;
            if (this.usingIdCache && !this.idCache.isEmpty()) {
                query = this.priorityEnabled ? this.getQuery(Query.PRIORITY_WITH_EXCLUSIONS, () -> this.channelMessageStoreQueryProvider.getPriorityPollFromGroupExcludeIdsQuery()) : this.getQuery(Query.POLL_WITH_EXCLUSIONS, () -> this.channelMessageStoreQueryProvider.getPollFromGroupExcludeIdsQuery());
                parameters.addValue("message_ids", this.idCache);
            } else {
                query = this.priorityEnabled ? this.getQuery(Query.PRIORITY, () -> this.channelMessageStoreQueryProvider.getPriorityPollFromGroupQuery()) : this.getQuery(Query.POLL, () -> this.channelMessageStoreQueryProvider.getPollFromGroupQuery());
            }
            messages = namedParameterJdbcTemplate.query(query, (SqlParameterSource)parameters, (RowMapper)this.messageRowMapper);
        }
        finally {
            this.idCacheReadLock.unlock();
        }
        Assert.state((messages.size() < 2 ? 1 : 0) != 0, () -> "The query must return zero or 1 row; got " + messages.size() + " rows");
        if (messages.size() > 0) {
            Message message = (Message)messages.get(0);
            UUID id = message.getHeaders().getId();
            Assert.state((id != null ? 1 : 0) != 0, (String)"Messages must have an id header to be stored");
            String messageId = id.toString();
            if (this.usingIdCache) {
                this.idCacheWriteLock.lock();
                try {
                    boolean added = this.idCache.add(messageId);
                    LOGGER.debug((CharSequence)LogMessage.format((String)"Polled message with id '%s' added: '%s'.", (Object)messageId, (Object)added));
                }
                finally {
                    this.idCacheWriteLock.unlock();
                }
            }
            return message;
        }
        return null;
    }

    private boolean doRemoveMessageFromGroup(Object groupId, Message<?> messageToRemove) {
        boolean result;
        UUID id = messageToRemove.getHeaders().getId();
        int updated = this.jdbcTemplate.update(this.getQuery(Query.DELETE_MESSAGE, () -> this.channelMessageStoreQueryProvider.getDeleteMessageQuery()), new Object[]{this.getKey(id), this.getKey(groupId), this.region}, new int[]{12, 12, 12});
        boolean bl = result = updated != 0;
        if (result) {
            LOGGER.debug(() -> "Message with id '" + String.valueOf(id) + "' was deleted.");
        } else {
            LOGGER.warn(() -> "Message with id '" + String.valueOf(id) + "' was not deleted.");
        }
        return result;
    }

    public void removeFromIdCache(String messageId) {
        LOGGER.debug(() -> "Removing Message Id: " + messageId);
        this.idCacheWriteLock.lock();
        try {
            this.idCache.remove(messageId);
        }
        finally {
            this.idCacheWriteLock.unlock();
        }
    }

    @ManagedMetric
    public int getSizeOfIdCache() {
        return this.idCache.size();
    }

    private static enum Query {
        CREATE_MESSAGE,
        COUNT_GROUPS,
        GROUP_SIZE,
        DELETE_GROUP,
        POLL,
        POLL_WITH_EXCLUSIONS,
        PRIORITY,
        PRIORITY_WITH_EXCLUSIONS,
        DELETE_MESSAGE;

    }
}

