/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.deployment.internal.legacy;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.internal.execute.FunctionToFileTracker;
import org.apache.geode.deployment.internal.DeployedJar;
import org.apache.geode.deployment.internal.JarDeployer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.deployment.JarDeploymentService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.internal.utils.JarFileUtils;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.geode.services.result.ServiceResult;
import org.apache.geode.services.result.impl.Failure;
import org.apache.geode.services.result.impl.Success;
import org.apache.logging.log4j.Logger;

@Experimental
public class LegacyJarDeploymentService
implements JarDeploymentService {
    private static final Logger logger = LogService.getLogger();
    private final Map<String, Deployment> deployments = new ConcurrentHashMap<String, Deployment>();
    private final FunctionToFileTracker functionToFileTracker = new FunctionToFileTracker();
    private JarDeployer jarDeployer = new JarDeployer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ServiceResult<Deployment> deploy(Deployment deployment) {
        try {
            DeployedJar deployedJar = this.jarDeployer.deploy(deployment.getFile());
            if (deployedJar == null) {
                logger.info("Jar already been deployed: {}", (Object)deployment);
                Success<Object> success = Success.of(null);
                return success;
            }
            logger.debug("Adding Deployment: {} with DeployedJar: {}", (Object)deployment, (Object)deployedJar);
            Deployment deploymentCopy = new Deployment(deployment, deployedJar.getFile());
            deploymentCopy.setDeployedTime(Instant.now().toString());
            this.deployments.put(JarFileUtils.getArtifactId(deploymentCopy.getFileName()), deploymentCopy);
            logger.debug("Deployments List size after add: {}", (Object)this.deployments.size());
            logger.debug("Deployment copy to return: {}", (Object)deploymentCopy);
            try {
                this.functionToFileTracker.registerFunctionsFromFile(deploymentCopy.getFile());
            }
            catch (IOException | ClassNotFoundException e) {
                this.jarDeployer.undeploy(JarFileUtils.getArtifactId(deployment.getFileName()));
                Failure<Deployment> failure = Failure.of(e);
                this.flushCaches();
                return failure;
            }
            Success<Deployment> success = Success.of(deploymentCopy);
            return success;
        }
        catch (IOException | ClassNotFoundException e) {
            Failure<Deployment> failure = Failure.of(e);
            return failure;
        }
        finally {
            this.flushCaches();
        }
    }

    @Override
    public ServiceResult<Deployment> deploy(File file) {
        return this.deploy(this.createDeployment(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ServiceResult<Deployment> undeployByFileName(String fileName) {
        try {
            logger.debug("Deployments List size before undeploy: {}", (Object)this.deployments.size());
            logger.debug("File being undeployed: {}", (Object)fileName);
            this.jarDeployer.deleteAllVersionsOfJar(fileName);
            String artifactId = JarFileUtils.getArtifactId(fileName);
            Deployment deployment = this.deployments.get(artifactId);
            if (deployment == null || !deployment.getFileName().equals(fileName)) {
                Failure<Deployment> failure = Failure.of(fileName + " not deployed");
                return failure;
            }
            Deployment removedDeployment = this.deployments.remove(artifactId);
            logger.debug("Removed Deployment: {}", (Object)removedDeployment);
            logger.debug("Deployments List size after remove: {}", (Object)this.deployments.size());
            String undeployedPath = this.jarDeployer.undeploy(JarFileUtils.getArtifactId(removedDeployment.getFileName()));
            logger.debug("Jar at path: {} removed by JarDeployer", (Object)undeployedPath);
            this.functionToFileTracker.unregisterFunctionsForDeployment(removedDeployment.getFileName());
            Success<Deployment> success = Success.of(removedDeployment);
            return success;
        }
        catch (IOException e) {
            Failure<Deployment> failure = Failure.of(e);
            return failure;
        }
        finally {
            this.flushCaches();
        }
    }

    @Override
    public List<Deployment> listDeployed() {
        return Collections.unmodifiableList(new LinkedList<Deployment>(this.deployments.values()));
    }

    @Override
    public ServiceResult<Deployment> getDeployed(String fileName) {
        logger.debug("Looking up Deployment for name: {}", (Object)fileName);
        logger.debug("Deployments keySet: {}", (Object)Arrays.toString(this.deployments.keySet().toArray()));
        String artifactId = JarFileUtils.getArtifactId(fileName);
        if (this.deployments.containsKey(artifactId)) {
            return Success.of(this.deployments.get(artifactId));
        }
        return Failure.of(fileName + " is not deployed.");
    }

    @Override
    public void reinitializeWithWorkingDirectory(File workingDirectory) {
        logger.info("Reinitializing JarDeploymentService with new working directory: {}", (Object)workingDirectory);
        if (!this.deployments.isEmpty()) {
            throw new RuntimeException("Cannot reinitialize working directory with existing deployments. Please undeploy first.");
        }
        this.jarDeployer = new JarDeployer(workingDirectory);
    }

    @Override
    public void loadJarsFromWorkingDirectory() {
        logger.debug("Loading jars from Working Directory");
        Map<String, DeployedJar> latestVersionOfJarsOnDisk = this.jarDeployer.getLatestVersionOfJarsOnDisk();
        try {
            LinkedList<Deployment> deploymentList = new LinkedList<Deployment>();
            for (Map.Entry<String, DeployedJar> entry : latestVersionOfJarsOnDisk.entrySet()) {
                DeployedJar deployedJar = entry.getValue();
                this.jarDeployer.registerNewVersions(entry.getKey(), deployedJar);
                logger.debug("Deploying DeployedJar: {} from working directory", (Object)deployedJar);
                Deployment deployment = this.createDeployment(deployedJar);
                deploymentList.add(deployment);
                this.deployments.put(JarFileUtils.toArtifactId(deployment.getFileName()), deployment);
            }
            for (Deployment deployment : deploymentList) {
                this.functionToFileTracker.registerFunctionsFromFile(deployment.getFile());
            }
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            this.flushCaches();
        }
    }

    @Override
    public void close() {
        Object[] jarNames = this.deployments.keySet().toArray(new String[0]);
        logger.debug("Closing LegacyJarDeploymentService. The following Deployments will be removed: {}", (Object)Arrays.toString(jarNames));
        for (Object jarName : jarNames) {
            this.undeployByFileName((String)jarName);
        }
    }

    private Deployment createDeployment(DeployedJar deployedJar) {
        Deployment deployment = new Deployment(deployedJar.getArtifactId(), "", Instant.ofEpochMilli(deployedJar.getFile().lastModified()).toString());
        deployment.setFile(deployedJar.getFile());
        return deployment;
    }

    private Deployment createDeployment(File deployedJar) {
        Deployment deployment = new Deployment(deployedJar.getName(), "", Instant.ofEpochMilli(deployedJar.lastModified()).toString());
        deployment.setFile(deployedJar);
        return deployment;
    }

    private synchronized void flushCaches() {
        try {
            TypeRegistry typeRegistry = ((InternalCache)CacheFactory.getAnyInstance()).getPdxRegistry();
            if (typeRegistry != null) {
                typeRegistry.flushCache();
            }
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
    }
}

