/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

import com.sas.dplycmn.planning.Component;
import com.sas.dplycmn.planning.ComponentRelationship;
import com.sas.dplycmn.planning.Container;
import com.sas.dplycmn.planning.Machine;
import com.sas.dplycmn.planning.MultiValueProps;
import com.sas.dplycmn.planning.Offering;
import com.sas.dplycmn.planning.Placement;
import com.sas.dplycmn.planning.Plan;
import com.sas.dplycmn.planning.PlanFactory;
import com.sas.dplycmn.planning.PlanXml;
import com.sas.dplycmn.planning.PlanXmlLoader;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class StaxPlanXmlLoader
implements PlanXmlLoader {
    private static final String TAGNAME_KEY = "tagname";
    private static final int MIN_PROPERTY_COUNT = 4;
    private Plan plan = null;
    private Stack<Container<Placement>> containerStack;
    private XMLStreamReader reader = null;
    private Map<String, Machine> machineMap = new HashMap<String, Machine>();
    private Map<String, Offering> offeringMap = new HashMap<String, Offering>();
    private Map<String, Placement> placementMap = new HashMap<String, Placement>();
    private Map<Container<Placement>, Map<String, Set<String>>> containerCodesToIds = new HashMap<Container<Placement>, Map<String, Set<String>>>();
    private Map<String, List<Properties>> implementedObjects = new HashMap<String, List<Properties>>();
    private Map<Container<Placement>, Integer> installSequences = new HashMap<Container<Placement>, Integer>();
    private Map<Container<Placement>, Integer> configSequences = new HashMap<Container<Placement>, Integer>();

    StaxPlanXmlLoader() {
    }

    @Override
    public Plan process(InputStream planStream) throws ParseException {
        this.plan = new Plan();
        boolean seenPlanName = false;
        int planPropsSeen = 0;
        this.offeringMap = new HashMap<String, Offering>();
        this.placementMap = new HashMap<String, Placement>();
        this.machineMap = new HashMap<String, Machine>();
        this.containerStack = new Stack();
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            this.reader = inputFactory.createXMLStreamReader(planStream);
            while (this.reader.hasNext()) {
                int event = this.reader.next();
                switch (event) {
                    case 1: {
                        String elementName = this.reader.getLocalName();
                        if (PlanXml.Element.PLAN.getName().equals(elementName)) {
                            this.plan.setName(this.reader.getAttributeValue(null, PlanXml.Attribute.PLAN_NAME.getName()));
                            seenPlanName = true;
                            break;
                        }
                        if (PlanXml.Element.PROPERTIES.getName().equals(elementName) || PlanXml.Element.NOTES.getName().equals(elementName)) {
                            MultiValueProps planXmlProps = this.getProperties(elementName);
                            planPropsSeen += PlanFactory.setPlanProperties(this.plan, planXmlProps);
                            break;
                        }
                        if (PlanXml.Element.CONTAINER_ONLY_COMPONENT.getName().equals(elementName)) {
                            this.processComponent(elementName);
                            break;
                        }
                        if (!PlanXml.Element.MACHINE.getName().equals(elementName)) break;
                        this.processMachine(elementName);
                    }
                }
            }
            this.reader.close();
        }
        catch (XMLStreamException e) {
            throw new ParseException(e.toString(), e.getLocation().getCharacterOffset());
        }
        if (!seenPlanName) {
            throw new ParseException("No plan element (" + PlanXml.Element.PLAN.getName() + ") found", 0);
        }
        if (planPropsSeen < 4) {
            throw new ParseException("Insufficient plan properties found", 0);
        }
        this.manageImplementedObjects();
        return this.plan;
    }

    private MultiValueProps getProperties(String housingElementName) throws XMLStreamException, ParseException {
        return this.getProperties(housingElementName, null);
    }

    private MultiValueProps getProperties(String housingElementName, MultiValueProps properties) throws XMLStreamException, ParseException {
        String valueAttribute;
        String keyAttribute;
        String keyElementName;
        if (PlanXml.Element.NOTES.getName().equals(housingElementName)) {
            keyElementName = PlanXml.Element.NOTES_ITEM.getName();
            keyAttribute = PlanXml.Attribute.NOTES_ITEM_KEY.getName();
            valueAttribute = PlanXml.Attribute.NOTES_ITEM_VALUE.getName();
        } else {
            keyElementName = PlanXml.Element.PROPERTIES_ITEM.getName();
            keyAttribute = PlanXml.Attribute.PROPERTIES_ITEM_KEY.getName();
            valueAttribute = PlanXml.Attribute.PROPERTIES_ITEM_VALUE.getName();
        }
        if (null == properties) {
            properties = new MultiValueProps();
        }
        boolean completed = false;
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            switch (event) {
                case 1: {
                    String housedElementName = this.reader.getLocalName();
                    if (keyElementName.equals(housedElementName)) {
                        properties.addValue(this.reader.getAttributeValue(null, keyAttribute), this.reader.getAttributeValue(null, valueAttribute));
                        break;
                    }
                    this.ignoreElement(housedElementName);
                    break;
                }
                case 2: {
                    if (!housingElementName.equals(this.reader.getLocalName())) break;
                    completed = true;
                }
            }
            if (!completed) continue;
            break;
        }
        return properties;
    }

    private void ignoreElement(String housingElementName) throws XMLStreamException {
        boolean completed = false;
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            switch (event) {
                case 1: {
                    if (!housingElementName.equals(this.reader.getLocalName())) break;
                    this.ignoreElement(housingElementName);
                    break;
                }
                case 2: {
                    if (!housingElementName.equals(this.reader.getLocalName())) break;
                    completed = true;
                }
            }
            if (!completed) continue;
            break;
        }
    }

    private void processComponent(String housingElementName) throws XMLStreamException, ParseException {
        MultiValueProps componentProps = new MultiValueProps();
        this.processAttributes(componentProps);
        Placement placement = new Placement();
        List<Properties> implObjs = null;
        boolean completed = false;
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            switch (event) {
                case 1: {
                    String housedElementName = this.reader.getLocalName();
                    if (PlanXml.Element.PROPERTIES.getName().equals(housedElementName) || PlanXml.Element.NOTES.getName().equals(housedElementName)) {
                        this.getProperties(housedElementName, componentProps);
                        break;
                    }
                    if (PlanXml.Element.IMPLEMENTED_OBJECTS.getName().equals(housedElementName)) {
                        implObjs = this.getImplementedObjects(housedElementName);
                        break;
                    }
                    if (PlanXml.Element.DEPLOYED_COMPONENTS.getName().equals(housedElementName)) {
                        this.containerStack.push(placement);
                        this.processDeployedComponents(housedElementName);
                        this.containerStack.pop();
                        break;
                    }
                    this.ignoreElement(housedElementName);
                    break;
                }
                case 2: {
                    if (!housingElementName.equals(this.reader.getLocalName())) break;
                    completed = true;
                }
            }
            if (!completed) continue;
            break;
        }
        String identifier = componentProps.getValue(PlanXml.Attribute.COMPONENT_ID.getName());
        if (PlanXml.Element.CONTAINER_ONLY_COMPONENT.getName().equals(housingElementName) && componentProps.containsKey(PlanXml.Attribute.COMPONENT_ASOFDATE.getName())) {
            Offering offering = new Offering();
            PlanFactory.setOfferingProperties(offering, componentProps);
            this.plan.addOffering(offering);
            if (this.offeringMap.containsKey(identifier)) {
                throw new ParseException("Component identifier " + identifier + " is not unique", 0);
            }
            this.offeringMap.put(identifier, offering);
        } else {
            if (PlanXml.Element.INSTALLED_COMPONENT.getName().equals(housingElementName)) {
                placement.setInstalled(true);
            }
            if (PlanXml.Element.CONFIGURED_COMPONENT.getName().equals(housingElementName)) {
                placement.setConfigured(true);
            }
            PlanFactory.setPlacementProperties(placement, componentProps);
            Placement updatedEntry = this.containerStack.isEmpty() ? placement : this.updateContainerWithPlacement(this.containerStack.peek(), placement, identifier);
            if (this.placementMap.containsKey(identifier) && !PlanXml.Element.CONTAINER_ONLY_COMPONENT.getName().equals(housingElementName)) {
                throw new ParseException("Component identifier " + identifier + " is not unique", 0);
            }
            this.placementMap.put(identifier, updatedEntry);
            if (null != implObjs && updatedEntry == placement) {
                this.implementedObjects.put(identifier, implObjs);
            }
        }
    }

    private void processAttributes(MultiValueProps properties) {
        int attrCount = this.reader.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            String key = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            if (null == key || null == value) continue;
            properties.addValue(key, value);
        }
    }

    private void processAttributes(Properties properties) {
        int attrCount = this.reader.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            String key = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            if (null == key || null == value) continue;
            properties.setProperty(key, value);
        }
    }

    private List<Properties> getImplementedObjects(String housingElementName) throws XMLStreamException, ParseException {
        ArrayList<Properties> implObjs = new ArrayList<Properties>();
        boolean completed = false;
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            switch (event) {
                case 1: {
                    String housedElementName = this.reader.getLocalName();
                    if (PlanXml.Element.INSTALLED_COMPONENT.getName().equals(housedElementName) || PlanXml.Element.CONFIGURED_COMPONENT.getName().equals(housedElementName) || PlanXml.Element.CONTAINER_ONLY_COMPONENT.getName().equals(housedElementName) || PlanXml.Element.MACHINE.getName().equals(housedElementName)) {
                        Properties implObj = new Properties();
                        implObj.setProperty(TAGNAME_KEY, housedElementName);
                        this.processAttributes(implObj);
                        implObjs.add(implObj);
                        break;
                    }
                    this.ignoreElement(housedElementName);
                    break;
                }
                case 2: {
                    if (!housingElementName.equals(this.reader.getLocalName())) break;
                    completed = true;
                }
            }
            if (!completed) continue;
            break;
        }
        return implObjs;
    }

    private void processDeployedComponents(String housingElementName) throws XMLStreamException, ParseException {
        boolean completed = false;
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            switch (event) {
                case 1: {
                    String housedElementName = this.reader.getLocalName();
                    if (PlanXml.Element.INSTALLED_COMPONENT.getName().equals(housedElementName) || PlanXml.Element.CONFIGURED_COMPONENT.getName().equals(housedElementName) || PlanXml.Element.CONTAINER_ONLY_COMPONENT.getName().equals(housedElementName)) {
                        this.processComponent(housedElementName);
                        break;
                    }
                    this.ignoreElement(housedElementName);
                    break;
                }
                case 2: {
                    if (!housingElementName.equals(this.reader.getLocalName())) break;
                    completed = true;
                }
            }
            if (!completed) continue;
            break;
        }
    }

    private Placement updateContainerWithPlacement(Container<Placement> container, Placement placement, String identifier) {
        Placement existingEntry;
        Set<String> idsForThisCode;
        Map<String, Set<String>> codesToIds = this.containerCodesToIds.get(container);
        if (null == codesToIds) {
            codesToIds = new HashMap<String, Set<String>>();
            this.containerCodesToIds.put(container, codesToIds);
        }
        if (null == (idsForThisCode = codesToIds.get(placement.getCode()))) {
            idsForThisCode = new HashSet<String>();
            codesToIds.put(placement.getCode(), idsForThisCode);
        }
        if (null == (existingEntry = this.getMatchingPlacement(placement, idsForThisCode))) {
            if (placement.isInstalled()) {
                placement.setInstallSequence(this.incrementSequence(container, this.installSequences));
            }
            if (placement.isConfigured()) {
                placement.setConfigSequence(this.incrementSequence(container, this.configSequences));
            }
            container.addContainedItem(placement);
            idsForThisCode.add(identifier);
            return placement;
        }
        if (placement.isInstalled() && !existingEntry.isInstalled()) {
            existingEntry.setInstalled(true);
            existingEntry.setInstallSequence(this.incrementSequence(container, this.installSequences));
        }
        if (placement.isConfigured() && !existingEntry.isConfigured()) {
            existingEntry.setConfigured(true);
            existingEntry.setConfigSequence(this.incrementSequence(container, this.configSequences));
            for (Integer stepNumber : placement.getStepNumbers()) {
                existingEntry.addStepNumber(stepNumber);
            }
        }
        return existingEntry;
    }

    private Placement getMatchingPlacement(Placement placement, Collection<String> tryIds) {
        for (String id : tryIds) {
            Placement checkAgainst = this.placementMap.get(id);
            if (null == checkAgainst || !placement.getCode().equals(checkAgainst.getCode()) || !placement.getExternalVersion().equals(checkAgainst.getExternalVersion()) || !placement.getInternalVersion().equals(checkAgainst.getInternalVersion()) || !placement.getName().equals(checkAgainst.getName()) || !placement.getProductionStatus().equals(checkAgainst.getProductionStatus()) || (null != placement.getPlatform() || null != checkAgainst.getPlatform()) && !placement.getPlatform().equals(checkAgainst.getPlatform()) || placement.isFoundation() != checkAgainst.isFoundation() || placement.isHidden() != checkAgainst.isHidden() || placement.isPrerequisite() != checkAgainst.isPrerequisite()) continue;
            return checkAgainst;
        }
        return null;
    }

    private int incrementSequence(Container<Placement> container, Map<Container<Placement>, Integer> sequences) {
        Integer currSequence = sequences.get(container);
        if (null == currSequence) {
            currSequence = 1;
        } else {
            Integer n = currSequence;
            currSequence = currSequence + 1;
        }
        sequences.put(container, currSequence);
        return currSequence;
    }

    private void processMachine(String housingElementName) throws XMLStreamException, ParseException {
        MultiValueProps machineProps = new MultiValueProps();
        this.processAttributes(machineProps);
        Machine machine = new Machine();
        boolean completed = false;
        while (this.reader.hasNext()) {
            int event = this.reader.next();
            switch (event) {
                case 1: {
                    String housedElementName = this.reader.getLocalName();
                    if (PlanXml.Element.PROPERTIES.getName().equals(housedElementName) || PlanXml.Element.NOTES.getName().equals(housedElementName)) {
                        this.getProperties(housedElementName, machineProps);
                        break;
                    }
                    if (PlanXml.Element.DEPLOYED_COMPONENTS.getName().equals(housedElementName)) {
                        this.containerStack.push(machine);
                        this.processDeployedComponents(housedElementName);
                        this.containerStack.pop();
                        break;
                    }
                    this.ignoreElement(housedElementName);
                    break;
                }
                case 2: {
                    if (!housingElementName.equals(this.reader.getLocalName())) break;
                    completed = true;
                }
            }
            if (!completed) continue;
            break;
        }
        PlanFactory.setMachineProperties(machine, machineProps);
        String identifier = machineProps.getValue(PlanXml.Attribute.MACHINE_ID.getName());
        if (this.machineMap.containsKey(identifier)) {
            throw new ParseException("Machine identifier " + identifier + " is not unique", 0);
        }
        this.machineMap.put(identifier, machine);
        this.plan.addMachine(machine);
    }

    private void manageImplementedObjects() throws ParseException {
        for (Map.Entry<String, List<Properties>> entry : this.implementedObjects.entrySet()) {
            String identifier = entry.getKey();
            Placement placement = this.placementMap.get(identifier);
            if (null == placement) {
                throw new ParseException("Component " + identifier + " not found", 0);
            }
            boolean isSasinstall = "SASINSTALL".equals(placement.getCode());
            for (Properties implObj : entry.getValue()) {
                String refId = implObj.getProperty(PlanXml.Attribute.IMPLEMENTED_OBJECT_REFERENCE.getName());
                if (PlanXml.Element.MACHINE.getName().equals(implObj.getProperty(TAGNAME_KEY))) {
                    Machine machine = this.machineMap.get(refId);
                    if (null == machine) {
                        throw new ParseException("Reference to machine " + refId + " (from " + identifier + ") not found", 0);
                    }
                    this.updateContainerWithPlacement(machine, placement, identifier);
                    continue;
                }
                Component subject = this.placementMap.get(refId);
                if (null == subject && null == (subject = (Component)this.offeringMap.get(refId))) {
                    throw new ParseException("Reference to component " + refId + " (from " + identifier + ") not found", 0);
                }
                boolean delivers = true;
                String propName = PlanXml.Attribute.IMPLEMENTED_OBJECT_DELIVERS.getName();
                String propVal = implObj.getProperty(propName);
                if (null != propVal) {
                    delivers = PlanFactory.getBooleanProp(implObj, propName);
                }
                ComponentRelationship relationship = new ComponentRelationship(subject, implObj.getProperty(PlanXml.Attribute.IMPLEMENTED_OBJECT_VERBS.getName()), placement, delivers);
                subject.addRelationship(relationship);
                placement.addRelationship(relationship);
                if (!isSasinstall || !relationship.getVerbs().contains("deploys under")) continue;
                ((Placement)subject).setFoundation(true);
            }
        }
    }
}

