/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

import com.sas.dplycmn.planning.Component;
import com.sas.dplycmn.planning.ComponentRelationship;
import com.sas.dplycmn.planning.Container;
import com.sas.dplycmn.planning.Machine;
import com.sas.dplycmn.planning.Offering;
import com.sas.dplycmn.planning.Placement;
import com.sas.dplycmn.planning.Plan;
import com.sas.dplycmn.planning.PlanDictionary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlanWalker {
    public static final PlanDictionary.Entry PLACEMENT_PREREQ = PlanDictionary.Entry.PREREQUISITE_COMPONENT;
    public static final PlanDictionary.Entry PLACEMENT_INSTALL = PlanDictionary.Entry.INSTALLED_COMPONENT;
    public static final PlanDictionary.Entry PLACEMENT_CONFIGURED = PlanDictionary.Entry.CONFIGURED_COMPONENT;
    public static final PlanDictionary.Entry PLACEMENT_CONTAINER = PlanDictionary.Entry.CONTAINER_ONLY_COMPONENT;
    public static final PlanDictionary.Entry PLACEMENT_ALL = PlanDictionary.Entry.PLACEMENT;
    private static final Map<PlanDictionary.Entry, Comparator<Placement>> placementComparators = new HashMap<PlanDictionary.Entry, Comparator<Placement>>();
    private static final Map<PlanDictionary.Entry, PlacementIncluder> placementIncluders = new HashMap<PlanDictionary.Entry, PlacementIncluder>();

    private PlanWalker() {
    }

    public static void walk(Plan plan, Handler handler) throws Exception {
        handler.startPlan(plan);
        for (Offering offering : plan.getOfferings()) {
            handler.startOffering(offering);
            PlanWalker.walkRelationships(offering, PLACEMENT_CONTAINER, handler);
            handler.finishOffering(offering);
        }
        for (Machine machine : plan.getMachines()) {
            handler.startMachine(machine);
            PlanWalker.walkPlacementContainer(machine, handler);
            handler.finishMachine(machine);
        }
        handler.finishPlan(plan);
    }

    private static void walkRelationships(Component component, PlanDictionary.Entry placementType, Handler handler) throws Exception {
        ArrayList<ComponentRelationship> relationships = new ArrayList<ComponentRelationship>(component.getRelationships());
        Collections.sort(relationships, handler);
        for (ComponentRelationship relationship : relationships) {
            if (!handler.includeRelationship(component, placementType, relationship)) continue;
            handler.startRelationship(relationship);
            handler.finishRelationship(relationship);
        }
    }

    private static void walkPlacementContainer(Container<Placement> container, Handler handler) throws Exception {
        List<PlanDictionary.Entry> requestedTypes = handler.getChildPlacementTypes();
        if (null == requestedTypes || requestedTypes.isEmpty()) {
            return;
        }
        HashMap placementLists = new HashMap();
        ArrayList<PlanDictionary.Entry> placementTypes = new ArrayList<PlanDictionary.Entry>();
        for (PlanDictionary.Entry entry : requestedTypes) {
            if (placementLists.containsKey((Object)entry) || !placementComparators.containsKey((Object)entry)) continue;
            placementTypes.add(entry);
            ArrayList placementList = new ArrayList();
            placementLists.put(entry, placementList);
        }
        for (PlanDictionary.Entry entry : placementTypes) {
            PlacementIncluder checker = placementIncluders.get((Object)entry);
            List placementList = (List)placementLists.get((Object)entry);
            if (null == checker || null == placementList) continue;
            for (Placement placement : container.getContainedItems()) {
                if (!checker.isIncluded(placement)) continue;
                placementList.add(placement);
            }
        }
        for (Map.Entry entry : placementLists.entrySet()) {
            Comparator<Placement> comparator = placementComparators.get(entry.getKey());
            if (null == comparator) continue;
            Collections.sort((List)entry.getValue(), comparator);
        }
        for (PlanDictionary.Entry entry : placementTypes) {
            List list = (List)placementLists.get((Object)entry);
            if (null == list) continue;
            for (Placement placement : list) {
                if (!handler.includeChildPlacement(container, placement, entry)) continue;
                handler.startPlacement(placement, entry);
                PlanWalker.walkRelationships(placement, entry, handler);
                PlanWalker.walkPlacementContainer(placement, handler);
                handler.finishPlacement(placement, entry);
            }
        }
    }

    static {
        placementComparators.put(PLACEMENT_PREREQ, Placement.INSTALL_COMPARATOR);
        placementIncluders.put(PLACEMENT_PREREQ, new PlacementIncluder(){

            @Override
            public boolean isIncluded(Placement placement) {
                return placement.isPrerequisite();
            }
        });
        placementComparators.put(PLACEMENT_INSTALL, Placement.INSTALL_COMPARATOR);
        placementIncluders.put(PLACEMENT_INSTALL, new PlacementIncluder(){

            @Override
            public boolean isIncluded(Placement placement) {
                return placement.isInstalled();
            }
        });
        placementComparators.put(PLACEMENT_CONFIGURED, Placement.CONFIG_COMPARATOR);
        placementIncluders.put(PLACEMENT_CONFIGURED, new PlacementIncluder(){

            @Override
            public boolean isIncluded(Placement placement) {
                return placement.isConfigured();
            }
        });
        placementComparators.put(PLACEMENT_CONTAINER, Placement.SIMPLE_COMPARATOR);
        placementIncluders.put(PLACEMENT_CONTAINER, new PlacementIncluder(){

            @Override
            public boolean isIncluded(Placement placement) {
                return placement.isContainerOnly();
            }
        });
        placementComparators.put(PLACEMENT_ALL, Placement.SIMPLE_COMPARATOR);
        placementIncluders.put(PLACEMENT_ALL, new PlacementIncluder(){

            @Override
            public boolean isIncluded(Placement placement) {
                return true;
            }
        });
    }

    public static abstract class Handler
    implements Comparator<ComponentRelationship> {
        public void startPlan(Plan plan) throws Exception {
        }

        public void finishPlan(Plan plan) throws Exception {
        }

        public void startOffering(Offering offering) throws Exception {
        }

        public void finishOffering(Offering offering) throws Exception {
        }

        public void startMachine(Machine machine) throws Exception {
        }

        public void finishMachine(Machine machine) throws Exception {
        }

        public List<PlanDictionary.Entry> getChildPlacementTypes() throws Exception {
            ArrayList<PlanDictionary.Entry> list = new ArrayList<PlanDictionary.Entry>();
            list.add(PLACEMENT_ALL);
            return list;
        }

        public void startPlacement(Placement placement, PlanDictionary.Entry placementType) throws Exception {
        }

        public void finishPlacement(Placement placement, PlanDictionary.Entry placementType) throws Exception {
        }

        public boolean includeChildPlacement(Container<Placement> container, Placement placement, PlanDictionary.Entry placementType) throws Exception {
            return true;
        }

        public boolean includeRelationship(Component component, PlanDictionary.Entry placementType, ComponentRelationship relationship) throws Exception {
            return true;
        }

        public void startRelationship(ComponentRelationship relationship) throws Exception {
        }

        public void finishRelationship(ComponentRelationship relationship) throws Exception {
        }

        @Override
        public int compare(ComponentRelationship a, ComponentRelationship b) {
            int answer = a.getSubject().getCode().compareTo(b.getSubject().getCode());
            if (0 != answer) {
                return answer;
            }
            answer = a.getPredicate().getCode().compareTo(b.getPredicate().getCode());
            if (0 != answer) {
                return answer;
            }
            return a.getVerbs().hashCode() - b.getVerbs().hashCode();
        }
    }

    private static interface PlacementIncluder {
        public boolean isIncluded(Placement var1);
    }
}

