/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

public enum MachineTopologyTarget {
    METADATA("Metadata", DedType.NOT_DEDICATED, TierType.FOUNDATION_SERVER),
    METADATA_NODE("MetadataNode", DedType.USUALLY_OPTIONAL, TierType.FOUNDATION_SERVER),
    SAS_APP("SASApp", DedType.NOT_DEDICATED, TierType.FOUNDATION_SERVER),
    MIDTIER("MidTier", DedType.NOT_DEDICATED, TierType.MIDTIER),
    CCPO_DATASYNC("CCPODataSync", DedType.USUALLY_REQUIRED),
    RETAIL_IMDS("RetailIMDS", DedType.USUALLY_REQUIRED),
    RT_OLAP_SERVER("RTOLAPServer", DedType.USUALLY_REQUIRED),
    GRID_MANAGER_CONTROL_SERVER("GridMgrCtrlServer", DedType.USUALLY_REQUIRED),
    GRID_MANAGER_NODE("GridMgrNode", DedType.USUALLY_OPTIONAL),
    BESS_MIDTIER("BessMidtier", DedType.USUALLY_OPTIONAL),
    MIDTIER_CLUSTER("MidClustMem", DedType.USUALLY_OPTIONAL, TierType.MIDTIER),
    CLIENTS("Clients", DedType.NOT_DEDICATED, TierType.CLIENT);

    private final String name;
    private final boolean requiresDedicatedMachine;
    private final boolean isNormallyOptional;
    private final TierType tierType;

    private MachineTopologyTarget(String name, DedType dedicatedType, TierType tierType) {
        this.name = name;
        this.requiresDedicatedMachine = !dedicatedType.equals((Object)DedType.NOT_DEDICATED);
        this.isNormallyOptional = dedicatedType.equals((Object)DedType.USUALLY_OPTIONAL);
        this.tierType = tierType;
    }

    private MachineTopologyTarget(String name, DedType dedicatedType) {
        this(name, dedicatedType, TierType.DEFAULT);
    }

    public String getName() {
        return this.name;
    }

    public TierType getTierType() {
        return this.tierType;
    }

    public boolean requiresDedicatedMachine() {
        return this.requiresDedicatedMachine;
    }

    public boolean isNormallyOptional() {
        return this.isNormallyOptional;
    }

    private static enum DedType {
        NOT_DEDICATED,
        USUALLY_OPTIONAL,
        USUALLY_REQUIRED;

    }

    public static enum TierType {
        FOUNDATION_SERVER,
        MIDTIER,
        CLIENT,
        DEFAULT;

    }
}

