/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

import com.sas.dplycmn.planning.MachineTopologyMachDef;
import com.sas.dplycmn.planning.MachineTopologyTarget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum MachineTopology {
    ONE_MACHINE("One Machine", new MachineTopologyMachDef("Server, Middle Tier, and Clients", MachineTopologyTarget.METADATA, MachineTopologyTarget.SAS_APP, MachineTopologyTarget.MIDTIER, MachineTopologyTarget.CLIENTS).addAliases("One Machine")),
    TWO_MACHINES("Two Machines", new MachineTopologyMachDef("Server and Middle Tier", MachineTopologyTarget.METADATA, MachineTopologyTarget.SAS_APP, MachineTopologyTarget.MIDTIER), new MachineTopologyMachDef("Clients", MachineTopologyTarget.CLIENTS)),
    THREE_MACHINES("Three Machines", true, new MachineTopologyMachDef("Server", MachineTopologyTarget.METADATA, MachineTopologyTarget.SAS_APP), new MachineTopologyMachDef("Middle Tier", MachineTopologyTarget.MIDTIER), new MachineTopologyMachDef("Clients", MachineTopologyTarget.CLIENTS)),
    FOUR_MACHINES("Four Machines", new MachineTopologyMachDef("Metadata Server", MachineTopologyTarget.METADATA), new MachineTopologyMachDef("SAS Application Server", MachineTopologyTarget.SAS_APP), new MachineTopologyMachDef("Middle Tier", MachineTopologyTarget.MIDTIER), new MachineTopologyMachDef("Clients", MachineTopologyTarget.CLIENTS));

    private final String topologyName;
    private final boolean isDefault;
    private final List<MachineTopologyMachDef> machineDefs;

    private MachineTopology(String topologyName, boolean isDefault, MachineTopologyMachDef ... machines) {
        this.topologyName = topologyName;
        this.isDefault = isDefault;
        this.machineDefs = new ArrayList<MachineTopologyMachDef>(Arrays.asList(machines));
    }

    private MachineTopology(String topologyName, MachineTopologyMachDef ... machineDefs) {
        this(topologyName, false, machineDefs);
    }

    public String getName() {
        return this.topologyName;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public List<MachineTopologyMachDef> getMachineDefs() {
        return new ArrayList<MachineTopologyMachDef>(this.machineDefs);
    }

    public Map<String, String> getCurrentMachineNameMap() {
        HashMap<String, String> machNameMap = new HashMap<String, String>();
        for (MachineTopologyMachDef topoMachDef : this.machineDefs) {
            String machineName = topoMachDef.getMachineName();
            machNameMap.put(machineName, machineName);
            for (String alias : topoMachDef.getAliases()) {
                machNameMap.put(alias, machineName);
            }
        }
        return machNameMap;
    }

    public Map<String, MachineTopologyMachDef> getMatchingMachDefs(Set<String> machNames) {
        HashMap<String, MachineTopologyMachDef> topoMachDefs = new HashMap<String, MachineTopologyMachDef>();
        for (MachineTopologyMachDef topoMachDef : this.machineDefs) {
            for (String machName : machNames) {
                if (!topoMachDef.getMachineName().equals(machName)) continue;
                topoMachDefs.put(machName, topoMachDef);
            }
        }
        for (MachineTopologyMachDef topoMachDef : this.machineDefs) {
            for (String machName : machNames) {
                if (!topoMachDef.getAliases().contains(machName)) continue;
                topoMachDefs.put(machName, topoMachDef);
            }
        }
        return topoMachDefs;
    }
}

