/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

import com.sas.dplycmn.planning.MachineDescriptionItem;
import com.sas.dplycmn.planning.MachineTopologyTarget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public enum MachinePurpose {
    METADATA("SrvMetadata", "Metadata Server", Arrays.asList(MachineTopologyTarget.METADATA), true, "The SAS Metadata Server controls access to a central repository of metadata that is shared by all of the applications in the system. The SAS Metadata Server enables centralized control so that all users access consistent and accurate data. The metadata repository stores information about the following: </P><UL><LI>the enterprise data sources and data structures that are accessed by SAS intelligence applications</LI><LI>the products that are created and used by SAS applications (including information maps, OLAP cubes, report definitions, stored process definitions, and portal content definitions)</LI><LI>the SAS and third-party servers that participate in the system</LI><LI>the users and groups of users that use the system</LI><LI>the levels of access that users and groups have to resources</LI></UL><P>SAS Management Console is the central management tool that you use to manage the metadata server and the metadata repository.</P><P>The SAS Metadata Server is an in-memory process. That is, all queried and updated metadata will be held in memory by the server.  In order to avoid any processing conflicts, SAS recommends the SAS Metadata Server be a standalone machine for optimal processing and stability. However, it is possible to run the SAS Metadata Server on the same machine as the SAS Application Server. There is no additional SAS software licensing for the placement of the SAS Metadata server on a separate box, as your existing license allows for this; however, platform specific software may need to be shipped.</P>", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK, MachineDescriptionItem.IO_PATHS), Arrays.asList("METADATASRV"), new ArrayList<String>(), Arrays.asList("MDS")),
    METADATA_NODE("SrvMetadataNode", "Metadata Server Node", Arrays.asList(MachineTopologyTarget.METADATA_NODE), false, "The Metadata Server Node adds a cluster node to the metadata server in order to support high availability and load balancing. Each cluster node will maintain a complete, up-to-date copy of the metadata for this deployment. A metadata server cluster requires at least three nodes, including the original metadata server deployment.  See the <span style=\"font-style: italic\">Intelligence Platform: System Administrative Guide</span> for more information on metadata server clusters.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK, MachineDescriptionItem.IO_PATHS), Arrays.asList("METADATASRVN"), new ArrayList<String>(), Arrays.asList("MDN")),
    DATA_MANAGEMENT("DataMgt", "Data Management Server", Arrays.asList(MachineTopologyTarget.SAS_APP), false, "The Data Management Server machine contains a collection of the Data Management servers that do not require Base SAS and do not run on z/OS. This server runs DataFlux Data Management Platform jobs and supports federated data access. For customer orders from before November 2014, the products that run on this server have their own SAS Installation Data file (SID file) that is prefixed with \"DMP\". Customer orders from November 2014 and later will use SID files prefixed with \"SAS\". For all orders, regardless of date, these SID files are not managed by the SAS Deployment Wizard and must be managed by the user. See the product READMEs that come with a deployment or the product administration guides for further help.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK, MachineDescriptionItem.IO_PATHS), Arrays.asList("DMSVR", "DFAUTHSVR", "DFFEDSVR"), new ArrayList<String>(), Arrays.asList("Data Management", "DMG")),
    RT_OLAP_SERVER("RTOLAPServer", "Real-Time OLAP Scalable Performance Data Server", Arrays.asList(MachineTopologyTarget.RT_OLAP_SERVER), false, "Grid-enabled Real-Time OLAP Server with SPD Server.", new ArrayList<MachineDescriptionItem>(), new ArrayList<String>(), new ArrayList<String>(), Arrays.asList("RTO")),
    INFO_RET_STUDIO("InfoRetStudio", "Information Retrieval Studio Server", Arrays.asList(MachineTopologyTarget.SAS_APP), false, "Information Retrieval Studio Server may be placed on a separate machine from SAS Application Server.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK, MachineDescriptionItem.IO_PATHS), new ArrayList<String>(), new ArrayList<String>(), Arrays.asList("IRS")),
    INFRASTRUCTURE_DATA_STORE("InfraDataStore", "Infrastructure Data Store", Arrays.asList(MachineTopologyTarget.SAS_APP), false, "Embedded data store used by SAS products.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK, MachineDescriptionItem.IO_PATHS), Arrays.asList("WEBINFDSVR"), new ArrayList<String>(), Arrays.asList("IDS")),
    VA_SAS_APP("VASrvSasApp", "SAS Visual Analytics Application Server", Arrays.asList(MachineTopologyTarget.SAS_APP), false, "The SAS Application Server specific to SAS Visual Analytics.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK, MachineDescriptionItem.IO_PATHS), Arrays.asList("BIHPGRDC"), new ArrayList<String>(), Arrays.asList("VA SAS Application Server", "VSA")),
    SOLN_LASR("SolnLASR", "Solution LASR Analytic Server", Arrays.asList(MachineTopologyTarget.SAS_APP), false, "Solution LASR Analytic Server is used by offerings other than SAS Visual Analytics that have their own LASR Analytic Server in non-distributed mode.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK, MachineDescriptionItem.IO_PATHS), Arrays.asList("SOLNLASRSRV"), new ArrayList<String>(), Arrays.asList("Solution LASR Server", "SLR")),
    SAS_APP("SrvSasApp", "SAS Application Server", Arrays.asList(MachineTopologyTarget.SAS_APP), true, "The SAS Server, also known as the Data-Tier, is where the bulk of the SAS processing occurs.  The SAS Workspace, Stored Process, and OLAP Servers typically run on this machine, although the OLAP Server can be installed on a separate machine if desired.  A SAS license file (SID) is required for this server.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK, MachineDescriptionItem.IO_PATHS), new ArrayList<String>(), new ArrayList<String>(), Arrays.asList("Application Server", "APP")),
    WEB_SERVER("WebServer", "Web Server", Arrays.asList(MachineTopologyTarget.MIDTIER), false, "The Web Server machine provides the configuration of the web server for the SAS Intelligence Platform and is the entry point for most SAS web applications. Using the Web Server purpose gives you the flexibility to put the web server on a separate machine from all other SAS products, facilitating the deployment of SAS products into a secure environment. For example, you could put a web server on a machine by itself in a DMZ and put the other SAS applications behind the DMZ area.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK), Arrays.asList("ERSSVR"), new ArrayList<String>(), Arrays.asList("WEB")),
    ENVIRONMENT_MANAGER("EnvMgr", "Environment Manager", Arrays.asList(MachineTopologyTarget.MIDTIER), false, "SAS Environment Manager consists of SAS Environment Manager Framework, SAS Environment Manager Agent, and various plug-ins such as SAS Hyperic Plug-ins for Foundation Servers. SAS Environment Manager Framework also provides the entry point to SAS Environment Manager Module Framework and SAS Environment Manager Modules.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK), Arrays.asList("HYPERICSVR"), new ArrayList<String>(), Arrays.asList("EMG")),
    REMOTE_SERVICES("RemSvcs", "Remote Services", Arrays.asList(MachineTopologyTarget.MIDTIER), false, "Remote Services is a server within the SAS Platform.  Its role is to coordinate among SAS Java applications in support of their communication with the SAS Metadata Server.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK), Arrays.asList("JPS"), new ArrayList<String>(), Arrays.asList("RMS")),
    GRID_MANAGER_CONTROL_SERVER("GridMgrCtrlServer", "Grid Manager Control Server", Arrays.asList(MachineTopologyTarget.SAS_APP), false, "The SAS Grid Manager Control Server controls distribution of jobs to the grid. Any machine in the environment that contains Base SAS, SAS/CONNECT, and Platform LSF can be designated as the control server.<br/> <br/>Like grid nodes, the control server is also capable of acting as a grid resource capable of receiving grid work. For example, it can be configured to host SAS Workspace Servers on the grid in support of SAS applications such as SAS Data Integration Studio, SAS Enterprise Miner, SAS Enterprise Guide, and the SAS Add-In for Microsoft Office.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK), Arrays.asList("GRIDCTLSVR", "GRIDCTLSVRH", "GRIDCTLSVRS"), new ArrayList<String>(), Arrays.asList("GMS")),
    GRID_MANAGER_NODE("GridMgrNode", "Grid Manager Node", Arrays.asList(MachineTopologyTarget.GRID_MANAGER_NODE), false, "The SAS Grid Manager Node machines are grid resources capable of receiving work. They run jobs submitted to the grid. Each grid node machine must contain Base SAS, SAS/CONNECT, and Platform LSF at a minimum.<br/> <br/>All of the grid nodes are not required to have identical software deployments. Additional SAS software products may also be deployed on some or all of the grid nodes, depending on the solution requirements and licensing. Grid nodes may also host non-grid workloads, such as the SAS Services (SAS Stored Process Server, SAS Pooled Workspace Server, SAS OLAP Server, etc.) or other third-party software as deemed necessary.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK), Arrays.asList("GRIDNODE", "GRIDNODEH", "GRIDNODES"), new ArrayList<String>(), Arrays.asList("GMN")),
    HELP_DOC_SERVER("HelpDocSvr", "Help Document Server", Arrays.asList(MachineTopologyTarget.MIDTIER), false, "Help Document Server is a server on the middle tier that hosts the SAS Help Viewer for the Web. It supports documentation delivery for several middle tier products.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK), Arrays.asList("WEBDOCMD"), new ArrayList<String>(), Arrays.asList("HDS")),
    MID_TIER("MidTier", "Middle Tier", Arrays.asList(MachineTopologyTarget.MIDTIER), false, "The Mid-Tier (middle tier or Web tier) of the SAS Intelligence Platform provides an environment where the business intelligence Web applications, such as SAS Web Report Studio and SAS Information Delivery Portal, can execute. These products run in a servlet container or Java 2 Enterprise Edition (J2EE) application server on the middle tier. They communicate with the user by sending data to and receiving data from the Web browser.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK), new ArrayList<String>(), Arrays.asList("WEBINFPLTFM"), Arrays.asList("MID")),
    VA_MID_TIER("VAMidTier", "SAS Visual Analytics Middle Tier", Arrays.asList(MachineTopologyTarget.MIDTIER), false, "The middle tier specific to SAS Visual Analytics.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK), Arrays.asList("BIDESIGNMID"), new ArrayList<String>(), Arrays.asList("VA Middle Tier", "VMD")),
    BESS_MID_TIER("BessMidTier", "SAS Digital Marketing Internal Tracking Server", Arrays.asList(MachineTopologyTarget.BESS_MIDTIER), false, "This separately managed SAS Web Application Server is provided to allow the deployment of the SAS Digital Marketing web tracking application (bess.war) inside the corporate firewall on an internal server. This application is used to process requests coming in from your SAS Digital Marketing External BESS tracking tier or reverse proxy server.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK), Arrays.asList("EMAILbessmid"), new ArrayList<String>(), Arrays.asList("Bess Middle Tier", "BMD", "SAS Digital Marketing External Tracking Server")),
    MIDTIER_CLUSTER("MidClustMem", "Middle Tier Node", Arrays.asList(MachineTopologyTarget.MIDTIER_CLUSTER), false, "The Middle Tier Node provides a replica configuration of the primary middle tier machine in order to support load-balancing and high availability. All of the middle tier applications configured in the primary middle tier environment are copied to this machine during configuration and deployed into additional servers. The Middle Tier Node machine can be configured multiple times on as many additional machines as needed in order to support higher levels of service.", Arrays.asList(MachineDescriptionItem.TYPE, MachineDescriptionItem.MODEL, MachineDescriptionItem.NETWORK), Arrays.asList("TCSCLUSTERC"), new ArrayList<String>(), Arrays.asList("Midtier Cluster Member", "MTN")),
    CCPO_DATASYNC("CCPODataSync", "CCPO DataSync tier", Arrays.asList(MachineTopologyTarget.CCPO_DATASYNC), false, "CCPO DataSync engine will get installed on this machine. Data Sync engine is used to send Source System (for example, ACD) data in near real time (NRT) to CCPO server and Agent Desktop clients.", new ArrayList<MachineDescriptionItem>(), new ArrayList<String>(), new ArrayList<String>(), Arrays.asList("CDS")),
    RETAIL_IMDS("RetailIMDS", "Retail IMDS Server", Arrays.asList(MachineTopologyTarget.RETAIL_IMDS), false, "An in-memory data store that is recommended on a separate machine for optimum performance.", new ArrayList<MachineDescriptionItem>(), new ArrayList<String>(), new ArrayList<String>(), Arrays.asList("RIM")),
    ADMIN_CLIENT("ClAdmin", "Clients - Administrative", Arrays.asList(MachineTopologyTarget.CLIENTS, MachineTopologyTarget.METADATA, MachineTopologyTarget.METADATA_NODE, MachineTopologyTarget.SAS_APP, MachineTopologyTarget.MIDTIER, MachineTopologyTarget.BESS_MIDTIER), true, "The Administrator clients are the applications that are typically used by system administrators. This includes SAS Management Console and its various plug-ins, which are Java applications that are supported on Windows and many UNIX systems.", Arrays.asList(MachineDescriptionItem.DEPLOYMENT), new ArrayList<String>(), new ArrayList<String>(), Arrays.asList("Clients - Admin", "CAD")),
    ANALYTICS_CLIENT("ClAnalytic", "Clients - Analytics", Arrays.asList(MachineTopologyTarget.CLIENTS), false, "The Analytics clients are the applications that are typically used by statisticians and data analysts.", Arrays.asList(MachineDescriptionItem.DEPLOYMENT), new ArrayList<String>(), new ArrayList<String>(), Arrays.asList("CAN")),
    END_USER_CLIENT("ClEndUser", "Clients - End User", Arrays.asList(MachineTopologyTarget.CLIENTS), true, "The End User clients are the applications that are typically used by the business users and report creators. The End User clients are Windows applications and Java applications that are supported only on Microsoft Windows systems.", Arrays.asList(MachineDescriptionItem.DEPLOYMENT), new ArrayList<String>(), new ArrayList<String>(), Arrays.asList("CEU"));

    private final String canonicalName;
    private final String displayName;
    private final boolean alwaysShown;
    private final String explanation;
    private final Set<String> aliases;
    private final MachineTopologyTarget primaryTopologyTarget;
    private final SortedSet<MachineTopologyTarget> topologyTargets;
    private final SortedSet<MachineDescriptionItem> descriptionItems;
    private final Set<String> critical12Bytes;
    private final List<String> stepAnterior12Bytes;

    private MachinePurpose(String canonicalName, String displayName, List<MachineTopologyTarget> topologyTargets, boolean alwaysShown, String explanation, Collection<MachineDescriptionItem> descriptionItems, Collection<String> critical12Bytes, List<String> stepAnterior12Bytes, Collection<String> aliases) {
        this.canonicalName = canonicalName;
        this.displayName = displayName;
        this.alwaysShown = alwaysShown;
        this.explanation = explanation;
        this.primaryTopologyTarget = topologyTargets.isEmpty() ? null : topologyTargets.get(0);
        this.topologyTargets = new TreeSet<MachineTopologyTarget>(topologyTargets);
        this.descriptionItems = new TreeSet<MachineDescriptionItem>(descriptionItems);
        this.aliases = new HashSet<String>(aliases);
        this.aliases.add(canonicalName);
        this.critical12Bytes = new TreeSet<String>(critical12Bytes);
        this.stepAnterior12Bytes = new ArrayList<String>(stepAnterior12Bytes);
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isAlwaysShown() {
        return this.alwaysShown;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public Set<String> getAliases() {
        return new HashSet<String>(this.aliases);
    }

    public SortedSet<MachineTopologyTarget> getTopologyTargets() {
        return new TreeSet<MachineTopologyTarget>(this.topologyTargets);
    }

    public List<String> getTopologyTargetNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (MachineTopologyTarget topologyTarget : this.topologyTargets) {
            names.add(topologyTarget.getName());
        }
        return names;
    }

    public MachineTopologyTarget getPrimaryTopologyTarget() {
        return this.primaryTopologyTarget;
    }

    public SortedSet<MachineDescriptionItem> getDescriptionItems() {
        return new TreeSet<MachineDescriptionItem>(this.descriptionItems);
    }

    public List<String> getDescItemsDisplayNames() {
        ArrayList<String> asStrings = new ArrayList<String>();
        for (MachineDescriptionItem descItem : this.descriptionItems) {
            asStrings.add(descItem.getDisplayName());
        }
        return asStrings;
    }

    public List<String> getStepAnterior12Bytes() {
        return new ArrayList<String>(this.stepAnterior12Bytes);
    }

    public Set<String> getCritical12Bytes() {
        return new TreeSet<String>(this.critical12Bytes);
    }

    public static final MachinePurpose getPurpose(String lookup) {
        String trimmedLookup = lookup.trim();
        for (MachinePurpose machPurpose : MachinePurpose.values()) {
            if (trimmedLookup.equals(machPurpose.getDisplayName())) {
                return machPurpose;
            }
            for (String alias : machPurpose.getAliases()) {
                if (!trimmedLookup.equals(alias)) continue;
                return machPurpose;
            }
        }
        return null;
    }

    public static final MachineTopologyTarget getPrimaryTopologyTarget(String lookup) {
        MachinePurpose foundPurpose = MachinePurpose.getPurpose(lookup);
        if (null == foundPurpose) {
            return null;
        }
        return foundPurpose.getPrimaryTopologyTarget();
    }

    public static final SortedSet<MachineDescriptionItem> getDescriptionItems(String lookup) {
        MachinePurpose foundPurpose = MachinePurpose.getPurpose(lookup);
        if (null == foundPurpose) {
            return null;
        }
        return foundPurpose.getDescriptionItems();
    }

    public static final String getCurrentPurpose(String lookup) {
        MachinePurpose foundPurpose = MachinePurpose.getPurpose(lookup);
        if (null == foundPurpose) {
            return lookup;
        }
        return foundPurpose.getDisplayName();
    }

    public static final Map<String, String> getDedicatedPurposeNames() {
        HashMap<String, String> dedicatedNameMap = new HashMap<String, String>();
        for (MachinePurpose purpose : MachinePurpose.values()) {
            MachineTopologyTarget topoTarget = purpose.getPrimaryTopologyTarget();
            if (!topoTarget.requiresDedicatedMachine()) continue;
            String displayName = purpose.getDisplayName();
            dedicatedNameMap.put(displayName, displayName);
            for (String alias : purpose.getAliases()) {
                if (dedicatedNameMap.containsKey(alias)) continue;
                dedicatedNameMap.put(alias, displayName);
            }
        }
        return dedicatedNameMap;
    }
}

