/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

import com.sas.dplycmn.planning.Container;
import com.sas.dplycmn.planning.Placement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Machine
implements Container<Placement> {
    private String name = "";
    private String platform = "";
    private String platformName = "";
    private String fullName = "";
    private String standardTopologyMachineName = null;
    private String type = "";
    private String model = "";
    private String osVersion = "";
    private String cpus = "";
    private String ram = "";
    private String diskDescription = "";
    private String networkDescription = "";
    private String ioPathDescription = "";
    private String deploymentDescription = "";
    private String details = "";
    private boolean isOptAllowed = false;
    private boolean isOptional = false;
    private boolean supportsVaDistributed = false;
    private SortedMap<Integer, String> steps = new TreeMap<Integer, String>();
    private Set<Integer> forcedSteps = new HashSet<Integer>();
    private List<String> purposes = new ArrayList<String>();
    private List<String> derivedPurposes = new ArrayList<String>();
    private SortedSet<Placement> placements = new TreeSet<Placement>();

    @Override
    public boolean addContainedItem(Placement placement) {
        placement.setContainer(this);
        return this.placements.add(placement);
    }

    @Override
    public boolean removeContainedItem(Placement placement) {
        placement.setContainer(null);
        return this.placements.remove(placement);
    }

    @Override
    public SortedSet<Placement> getContainedItems() {
        return new TreeSet<Placement>(this.placements);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getStdTopoMachName() {
        return this.standardTopologyMachineName;
    }

    public void setStdTopoMachName(String standardTopologyMachineName) {
        this.standardTopologyMachineName = standardTopologyMachineName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getCpus() {
        return this.cpus;
    }

    public void setCpus(String cpus) {
        this.cpus = cpus;
    }

    public String getRam() {
        return this.ram;
    }

    public void setRam(String ram) {
        this.ram = ram;
    }

    public String getDiskDescription() {
        return this.diskDescription;
    }

    public void setDiskDescription(String diskDescription) {
        this.diskDescription = diskDescription;
    }

    public String getNetworkDescription() {
        return this.networkDescription;
    }

    public void setNetworkDescription(String networkDescription) {
        this.networkDescription = networkDescription;
    }

    public String getIoPathDescription() {
        return this.ioPathDescription;
    }

    public void setIoPathDescription(String ioPathDescription) {
        this.ioPathDescription = ioPathDescription;
    }

    public String getDeploymentDescription() {
        return this.deploymentDescription;
    }

    public void setDeploymentDescription(String deploymentDescription) {
        this.deploymentDescription = deploymentDescription;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public boolean isOptionalAllowed() {
        return this.isOptAllowed;
    }

    public void setOptionalAllowed(boolean isOptAllowed) {
        this.isOptAllowed = isOptAllowed;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    public boolean supportsVaDistributed() {
        return this.supportsVaDistributed;
    }

    public void setSupportsVaDistributed(boolean supportsVaDistributed) {
        this.supportsVaDistributed = supportsVaDistributed;
    }

    public void addStep(Integer number, String label) {
        this.steps.put(number, label);
    }

    public void markStepAsForced(Integer number) {
        if (!this.steps.keySet().contains(number)) {
            throw new IllegalArgumentException("Requested step is not present");
        }
        this.forcedSteps.add(number);
    }

    public SortedMap<Integer, String> getSteps() {
        return this.steps;
    }

    public String getStepLabel(Integer stepNum) {
        return (String)this.steps.get(stepNum);
    }

    public void addPurpose(String purpose) {
        this.purposes.add(purpose);
    }

    public boolean isStepForced(Integer number) {
        return this.forcedSteps.contains(number);
    }

    public List<String> getPurposes() {
        return this.purposes;
    }

    public void addDerivedPurpose(String derivedPurpose) {
        this.derivedPurposes.add(derivedPurpose);
    }

    public List<String> getDerivedPurposes() {
        return this.derivedPurposes;
    }

    public List<Placement> getInstalledPlacements() {
        return Machine.getInstalledPlacements(this);
    }

    static List<Placement> getInstalledPlacements(Container<Placement> ctr) {
        ArrayList<Placement> instPlacements = new ArrayList<Placement>();
        for (Placement placement : ctr.getContainedItems()) {
            if (!placement.isInstalled()) continue;
            instPlacements.add(placement);
        }
        Collections.sort(instPlacements, Placement.INSTALL_COMPARATOR);
        return instPlacements;
    }

    public List<Placement> getAllConfiguredPlacements() {
        return Machine.getAllConfiguredPlacements(this);
    }

    static List<Placement> getAllConfiguredPlacements(Container<Placement> ctr) {
        ArrayList<Placement> confPlacements = new ArrayList<Placement>();
        for (Placement placement : ctr.getContainedItems()) {
            if (!placement.isConfigured()) continue;
            confPlacements.add(placement);
        }
        Collections.sort(confPlacements, Placement.CONFIG_COMPARATOR);
        return confPlacements;
    }

    public List<Placement> getExpectedConfiguredPlacements(Integer stepNum) {
        ArrayList<Placement> expectedConfPlcs = new ArrayList<Placement>();
        HashSet<Placement> signaledPlcs = new HashSet<Placement>();
        List<Placement> allConfPlcs = this.getAllConfiguredPlacements();
        boolean isStepForced = this.isStepForced(stepNum);
        for (Placement placement : allConfPlcs) {
            SortedSet<Integer> stepNums = placement.getStepNumbers();
            if (!stepNums.contains(stepNum) || !isStepForced && !stepNum.equals(stepNums.first())) continue;
            expectedConfPlcs.add(placement);
            signaledPlcs.addAll(placement.getSignaledConfigurations());
        }
        for (Placement signaledPlc : signaledPlcs) {
            if (expectedConfPlcs.contains(signaledPlc)) continue;
            expectedConfPlcs.add(signaledPlc);
        }
        Collections.sort(expectedConfPlcs, Placement.CONFIG_COMPARATOR);
        return expectedConfPlcs;
    }

    public List<Placement> getTierPlacements() {
        ArrayList<Placement> tierPlacements = new ArrayList<Placement>();
        for (Placement placement : this.getContainedItems()) {
            if (!placement.isTier()) continue;
            tierPlacements.add(placement);
        }
        Collections.sort(tierPlacements, Placement.SIMPLE_COMPARATOR);
        return tierPlacements;
    }

    public List<Placement> getPrereqPlacements() {
        ArrayList<Placement> prereqPlacements = new ArrayList<Placement>();
        for (Placement placement : this.getInstalledPlacements()) {
            if (!placement.isPrerequisite()) continue;
            prereqPlacements.add(placement);
        }
        for (Placement placement : this.getAllConfiguredPlacements()) {
            if (prereqPlacements.contains(placement) || !placement.isPrerequisite()) continue;
            prereqPlacements.add(placement);
        }
        return prereqPlacements;
    }
}

