/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dplycmn.planning;

import com.sas.dplycmn.planning.ComponentRelationship;
import com.sas.dplycmn.planning.Placement;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class Component
implements Comparable<Component> {
    private String name = "";
    private String code = "";
    private String externalVersion = "";
    private String internalVersion = "";
    private String productionStatus = "";
    private Set<ComponentRelationship> relationships = new HashSet<ComponentRelationship>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getExternalVersion() {
        return this.externalVersion;
    }

    public void setExternalVersion(String externalVersion) {
        this.externalVersion = externalVersion;
    }

    public String getInternalVersion() {
        return this.internalVersion;
    }

    public void setInternalVersion(String internalVersion) {
        this.internalVersion = internalVersion;
    }

    public String getProductionStatus() {
        return this.productionStatus;
    }

    public void setProductionStatus(String productionStatus) {
        this.productionStatus = productionStatus;
    }

    public void addRelationship(ComponentRelationship relationship) {
        this.relationships.add(relationship);
    }

    public Set<ComponentRelationship> getRelationships() {
        return this.relationships;
    }

    public int baseCompareTo(Component other) {
        int result = this.getCode().compareTo(other.getCode());
        if (0 != result) {
            return result;
        }
        result = this.getInternalVersion().compareTo(other.getInternalVersion());
        if (0 != result) {
            return result;
        }
        return result;
    }

    @Override
    @SuppressWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="Hash code compare ensures alignment with equals()")
    public int compareTo(Component other) {
        int result = this.baseCompareTo(other);
        if (0 != result) {
            return result;
        }
        return this.hashCode() - other.hashCode();
    }

    public SortedSet<Placement> getDeliveredPlacements() {
        TreeSet<Placement> deliveredPlacements = new TreeSet<Placement>(Placement.SIMPLE_COMPARATOR);
        for (ComponentRelationship rel : this.getRelationships()) {
            if (!this.equals(rel.getSubject()) || !rel.isDelivers()) continue;
            deliveredPlacements.add(rel.getPredicate());
        }
        return deliveredPlacements;
    }
}

