/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSDL4JImportedWSDLHelper {
    protected static final Log log = LogFactory.getLog(WSDL4JImportedWSDLHelper.class);
    private static final boolean isTraceEnabled = log.isTraceEnabled();

    public static void processImports(Definition wsdl4JDefinition, List processedDocuments) {
        Map wsdlImports = wsdl4JDefinition.getImports();
        if (wsdlImports != null && !wsdlImports.isEmpty()) {
            Collection importsCollection = wsdlImports.values();
            for (Vector values : importsCollection) {
                int i = 0;
                while (i < values.size()) {
                    Definition importedDef;
                    Import wsdlImport = (Import)values.elementAt(i);
                    if (wsdlImport.getDefinition() != null && (importedDef = wsdlImport.getDefinition()) != null) {
                        String key = importedDef.getDocumentBaseURI();
                        if (key == null) {
                            key = importedDef.getTargetNamespace();
                        }
                        if (processedDocuments.contains(key)) {
                            return;
                        }
                        processedDocuments.add(key);
                        WSDL4JImportedWSDLHelper.processImports(importedDef, processedDocuments);
                        Map namespaces = importedDef.getNamespaces();
                        for (Object key2 : namespaces.keySet()) {
                            if (wsdl4JDefinition.getNamespaces().containsValue(namespaces.get(key2))) continue;
                            wsdl4JDefinition.getNamespaces().put(key2, namespaces.get(key2));
                        }
                        wsdl4JDefinition.getNamespaces().putAll(namespaces);
                        Types t = importedDef.getTypes();
                        if (t != null) {
                            List typesList = t.getExtensibilityElements();
                            int j = 0;
                            while (j < typesList.size()) {
                                Types types = wsdl4JDefinition.getTypes();
                                if (types == null) {
                                    types = wsdl4JDefinition.createTypes();
                                    wsdl4JDefinition.setTypes(types);
                                }
                                types.addExtensibilityElement((ExtensibilityElement)typesList.get(j));
                                ++j;
                            }
                        }
                        Map messagesMap = importedDef.getMessages();
                        wsdl4JDefinition.getMessages().putAll(messagesMap);
                        Map porttypeMap = importedDef.getPortTypes();
                        wsdl4JDefinition.getPortTypes().putAll(porttypeMap);
                        Map bindingMap = importedDef.getBindings();
                        wsdl4JDefinition.getBindings().putAll(bindingMap);
                        Map serviceMap = importedDef.getServices();
                        wsdl4JDefinition.getServices().putAll(serviceMap);
                        List extElementList = importedDef.getExtensibilityElements();
                        wsdl4JDefinition.getExtensibilityElements().addAll(extElementList);
                    }
                    ++i;
                }
            }
        }
    }
}

